/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointsPacket;

public class PatrolPointsRequestPacket {
    private final UUID entityUUID;

    public PatrolPointsRequestPacket(UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    public static void encode(PatrolPointsRequestPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.entityUUID);
    }

    public static PatrolPointsRequestPacket decode(FriendlyByteBuf buf) {
        UUID entityUUID = buf.m_130259_();
        return new PatrolPointsRequestPacket(entityUUID);
    }

    public static void handle(PatrolPointsRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        context.enqueueWork(() -> {
            BaseCombatEntity baseEntity;
            List<BlockPos> patrolPoints;
            ServerLevel world;
            Entity entity;
            if (player != null && (entity = (world = (ServerLevel)((EntityAccessor)player).getLevel()).m_8791_(packet.entityUUID)) instanceof BaseCombatEntity && !(patrolPoints = (baseEntity = (BaseCombatEntity)entity).getPatrolPoints()).isEmpty()) {
                PatrolPointsPacket responsePacket = new PatrolPointsPacket(packet.entityUUID, patrolPoints);
                ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
            }
        });
        context.setPacketHandled(true);
    }
}

