/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataResponsePacket;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentCategory;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentConfigManager;
import ydmsama.hundred_years_war.main.recruitment.data.RecruitmentConfig;

public class RecruitmentDataRequestPacket {
    private final String categoryId;

    public RecruitmentDataRequestPacket(String categoryId) {
        this.categoryId = categoryId;
    }

    public RecruitmentDataRequestPacket() {
        this.categoryId = null;
    }

    public static void encode(RecruitmentDataRequestPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.categoryId != null);
        if (packet.categoryId != null) {
            buf.m_130070_(packet.categoryId);
        }
    }

    public static RecruitmentDataRequestPacket decode(FriendlyByteBuf buf) {
        boolean hasCategory = buf.readBoolean();
        if (hasCategory) {
            String categoryId = buf.m_130277_();
            return new RecruitmentDataRequestPacket(categoryId);
        }
        return new RecruitmentDataRequestPacket();
    }

    public static void handlePacket(ServerPlayer player, RecruitmentDataRequestPacket packet) {
        if (packet.categoryId != null) {
            List<RecruitmentConfig.UnitTypeConfig> unitTypes;
            RecruitmentCategory category = RecruitmentCategory.fromId(packet.categoryId);
            if (category != null) {
                unitTypes = RecruitmentConfigManager.getAvailableUnitTypes((Player)player, category);
            } else {
                unitTypes = new ArrayList<RecruitmentConfig.UnitTypeConfig>();
                System.err.println("\u672a\u627e\u5230\u62db\u52df\u7c7b\u522b: " + packet.categoryId);
            }
            RecruitmentDataResponsePacket response = new RecruitmentDataResponsePacket(packet.categoryId, unitTypes);
            ServerPacketHandler.sendToPlayer(response, player);
            System.out.println("\u5411\u73a9\u5bb6 " + player.m_7755_().getString() + " \u53d1\u9001\u62db\u52df\u6570\u636e\uff0c\u7c7b\u522b: " + packet.categoryId + "\uff0c\u5175\u79cd\u6570\u91cf: " + unitTypes.size());
        } else {
            for (RecruitmentCategory category : RecruitmentConfigManager.getAllCategories()) {
                List<RecruitmentConfig.UnitTypeConfig> unitTypes = RecruitmentConfigManager.getAvailableUnitTypes((Player)player, category);
                RecruitmentDataResponsePacket response = new RecruitmentDataResponsePacket(category.getId(), unitTypes);
                ServerPacketHandler.sendToPlayer(response, player);
                System.out.println("\u5411\u73a9\u5bb6 " + player.m_7755_().getString() + " \u53d1\u9001\u62db\u52df\u6570\u636e\uff0c\u7c7b\u522b: " + category.getId() + "\uff0c\u5175\u79cd\u6570\u91cf: " + unitTypes.size());
            }
        }
    }

    public static void handle(RecruitmentDataRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                RecruitmentDataRequestPacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public String getCategoryId() {
        return this.categoryId;
    }
}

