/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.recruitment.data.RecruitmentConfig;

public class RecruitmentDataResponsePacket {
    private final String categoryId;
    private final List<RecruitmentConfig.UnitTypeConfig> unitTypes;

    public RecruitmentDataResponsePacket(String categoryId, List<RecruitmentConfig.UnitTypeConfig> unitTypes) {
        this.categoryId = categoryId;
        this.unitTypes = unitTypes;
    }

    public static void encode(RecruitmentDataResponsePacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.categoryId);
        buf.writeInt(packet.unitTypes.size());
        for (RecruitmentConfig.UnitTypeConfig unitType : packet.unitTypes) {
            buf.m_130070_(unitType.getId());
            buf.m_130070_(unitType.getTranslationKey());
            buf.writeInt(unitType.getLevels().size());
            for (RecruitmentConfig.ArmyLevelConfig level : unitType.getLevels()) {
                buf.writeInt(level.getLevel());
                buf.m_130070_(level.getTranslationKey());
                buf.writeInt(level.getExpCost());
                buf.writeInt(level.getUnits().size());
                for (RecruitmentConfig.UnitEntry unit : level.getUnits()) {
                    buf.m_130070_(unit.getEntityType());
                    buf.writeInt(unit.getCountRange().getMin());
                    buf.writeInt(unit.getCountRange().getMax());
                    buf.writeInt(unit.getEquipmentLevel());
                }
                List<String> conditions = level.getConditions();
                if (conditions != null) {
                    buf.writeInt(conditions.size());
                    for (String condition : conditions) {
                        buf.m_130070_(condition);
                    }
                    continue;
                }
                buf.writeInt(0);
            }
        }
    }

    public static RecruitmentDataResponsePacket decode(FriendlyByteBuf buf) {
        String categoryId = buf.m_130277_();
        int unitTypesSize = buf.readInt();
        ArrayList<RecruitmentConfig.UnitTypeConfig> unitTypes = new ArrayList<RecruitmentConfig.UnitTypeConfig>();
        for (int i = 0; i < unitTypesSize; ++i) {
            RecruitmentConfig.UnitTypeConfig unitType = new RecruitmentConfig.UnitTypeConfig();
            unitType.setId(buf.m_130277_());
            unitType.setTranslationKey(buf.m_130277_());
            int levelsSize = buf.readInt();
            ArrayList<RecruitmentConfig.ArmyLevelConfig> levels = new ArrayList<RecruitmentConfig.ArmyLevelConfig>();
            for (int j = 0; j < levelsSize; ++j) {
                RecruitmentConfig.ArmyLevelConfig level = new RecruitmentConfig.ArmyLevelConfig();
                level.setLevel(buf.readInt());
                level.setTranslationKey(buf.m_130277_());
                level.setExpCost(buf.readInt());
                int unitsSize = buf.readInt();
                ArrayList<RecruitmentConfig.UnitEntry> units = new ArrayList<RecruitmentConfig.UnitEntry>();
                for (int k = 0; k < unitsSize; ++k) {
                    RecruitmentConfig.UnitEntry unit = new RecruitmentConfig.UnitEntry();
                    unit.setEntityType(buf.m_130277_());
                    RecruitmentConfig.CountRange countRange = new RecruitmentConfig.CountRange();
                    countRange.setMin(buf.readInt());
                    countRange.setMax(buf.readInt());
                    unit.setCountRange(countRange);
                    unit.setEquipmentLevel(buf.readInt());
                    units.add(unit);
                }
                level.setUnits(units);
                int conditionsSize = buf.readInt();
                if (conditionsSize > 0) {
                    ArrayList<String> conditions = new ArrayList<String>();
                    for (int k = 0; k < conditionsSize; ++k) {
                        conditions.add(buf.m_130277_());
                    }
                    level.setConditions(conditions);
                }
                levels.add(level);
            }
            unitType.setLevels(levels);
            unitTypes.add(unitType);
        }
        return new RecruitmentDataResponsePacket(categoryId, unitTypes);
    }

    public static void handlePacket(RecruitmentDataResponsePacket packet) {
        ClientPacketHandler.onRecruitmentDataResponse(packet);
    }

    public static void handle(RecruitmentDataResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> RecruitmentDataResponsePacket.handlePacket(packet));
        context.setPacketHandled(true);
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public List<RecruitmentConfig.UnitTypeConfig> getUnitTypes() {
        return this.unitTypes;
    }
}

