/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;

public class SquadPacket {
    private final List<UUID> entityUUIDs;

    public SquadPacket(List<UUID> entityUUIDs) {
        this.entityUUIDs = entityUUIDs;
    }

    public static void encode(SquadPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityUUIDs.size());
        for (UUID uuid : packet.entityUUIDs) {
            buf.m_130077_(uuid);
        }
    }

    public static SquadPacket decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<UUID> entityUUIDs = new ArrayList<UUID>();
        for (int i = 0; i < size; ++i) {
            entityUUIDs.add(buf.m_130259_());
        }
        return new SquadPacket(entityUUIDs);
    }

    public static void handle(SquadPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ != null) {
                    ArrayList<Entity> selectedEntities = new ArrayList<Entity>();
                    for (UUID uuid : packet.entityUUIDs) {
                        Entity entity = SquadPacket.getEntityByUUID(uuid);
                        if (entity == null) continue;
                        selectedEntities.add(entity);
                    }
                    SelectionHandler.getInstance().setSelectedEntities(selectedEntities);
                }
            });
        }
        context.setPacketHandled(true);
    }

    public static Entity getEntityByUUID(UUID uuid) {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (clientWorld != null) {
            for (Entity entity : clientWorld.m_104735_()) {
                if (!entity.m_20148_().equals(uuid)) continue;
                return entity;
            }
        }
        return null;
    }
}

