/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoResponsePacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamInfoRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_info_request");

    public TeamInfoRequestPacket() {
    }

    public TeamInfoRequestPacket(FriendlyByteBuf buf) {
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static TeamInfoRequestPacket decode(FriendlyByteBuf buf) {
        return new TeamInfoRequestPacket();
    }

    public static void handle(TeamInfoRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                TeamInfoRequestPacket.handlePacket(player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player) {
        UUID playerUUID = player.m_20148_();
        List<UUID> playerTeams = RelationSystem.getPlayerTeams(playerUUID);
        if (!playerTeams.isEmpty()) {
            UUID teamUUID = playerTeams.get(0);
            TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
            TeamInfoRequestPacket.sendTeamInfoResponse(player, teamData);
        } else {
            TeamInfoRequestPacket.sendEmptyTeamInfoResponse(player);
        }
    }

    private static void sendTeamInfoResponse(ServerPlayer player, TeamRelationData teamData) {
        if (teamData == null) {
            TeamInfoRequestPacket.sendEmptyTeamInfoResponse(player);
            return;
        }
        UUID teamUUID = teamData.getUUID();
        String teamName = teamData.getTeamName();
        UUID ownerUUID = null;
        for (UUID memberUUID : teamData.getAllMembers().keySet()) {
            if (teamData.getAllMembers().get(memberUUID) != TeamRelationData.MemberType.OWNER) continue;
            ownerUUID = memberUUID;
            break;
        }
        String ownerName = ownerUUID != null ? TeamInfoRequestPacket.getPlayerName(player, ownerUUID) : "Unknown";
        ArrayList<String> members = new ArrayList<String>();
        ArrayList<String> admins = new ArrayList<String>();
        ArrayList<String> pendingApplications = new ArrayList<String>();
        for (UUID memberUUID : teamData.getAllMembers().keySet()) {
            if (memberUUID.equals(ownerUUID)) continue;
            TeamRelationData.MemberType type = teamData.getAllMembers().get(memberUUID);
            String memberName = TeamInfoRequestPacket.getPlayerName(player, memberUUID);
            if (type == TeamRelationData.MemberType.MEMBER) {
                members.add(memberName);
                continue;
            }
            if (type != TeamRelationData.MemberType.ADMIN) continue;
            admins.add(memberName);
        }
        for (UUID applicantUUID : teamData.getPendingApplications()) {
            pendingApplications.add(TeamInfoRequestPacket.getPlayerName(player, applicantUUID));
        }
        TeamInfoResponsePacket responsePacket = new TeamInfoResponsePacket(true, teamName, teamUUID, ownerName, members, admins, pendingApplications);
        ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
    }

    private static String getPlayerName(ServerPlayer sender, UUID playerUUID) {
        ServerPlayer player;
        if (sender.m_20194_() != null && (player = sender.m_20194_().m_6846_().m_11259_(playerUUID)) != null) {
            return player.m_7755_().getString();
        }
        return "Player_" + playerUUID.toString().substring(0, 8);
    }

    private static void sendEmptyTeamInfoResponse(ServerPlayer player) {
        TeamInfoResponsePacket responsePacket = new TeamInfoResponsePacket(false, "", new UUID(0L, 0L), "", new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());
        ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
    }
}

