/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;

public class TeamInfoResponsePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_info_response");
    private final boolean isInTeam;
    private final String teamName;
    private final UUID teamUUID;
    private final String teamOwnerName;
    private final List<String> teamMembers;
    private final List<String> teamAdmins;
    private final List<String> pendingApplications;

    public TeamInfoResponsePacket(boolean isInTeam, String teamName, UUID teamUUID, String teamOwnerName, List<String> teamMembers, List<String> teamAdmins, List<String> pendingApplications) {
        this.isInTeam = isInTeam;
        this.teamName = teamName;
        this.teamUUID = teamUUID;
        this.teamOwnerName = teamOwnerName;
        this.teamMembers = teamMembers;
        this.teamAdmins = teamAdmins;
        this.pendingApplications = pendingApplications;
    }

    public TeamInfoResponsePacket(FriendlyByteBuf buf) {
        this.isInTeam = buf.readBoolean();
        if (this.isInTeam) {
            this.teamName = buf.m_130277_();
            this.teamUUID = buf.m_130259_();
            this.teamOwnerName = buf.m_130277_();
            int membersCount = buf.m_130242_();
            this.teamMembers = new ArrayList<String>(membersCount);
            for (int i = 0; i < membersCount; ++i) {
                this.teamMembers.add(buf.m_130277_());
            }
            int adminsCount = buf.m_130242_();
            this.teamAdmins = new ArrayList<String>(adminsCount);
            for (int i = 0; i < adminsCount; ++i) {
                this.teamAdmins.add(buf.m_130277_());
            }
            int pendingCount = buf.m_130242_();
            this.pendingApplications = new ArrayList<String>(pendingCount);
            for (int i = 0; i < pendingCount; ++i) {
                this.pendingApplications.add(buf.m_130277_());
            }
        } else {
            this.teamName = "";
            this.teamUUID = new UUID(0L, 0L);
            this.teamOwnerName = "";
            this.teamMembers = new ArrayList<String>();
            this.teamAdmins = new ArrayList<String>();
            this.pendingApplications = new ArrayList<String>();
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isInTeam);
        if (this.isInTeam) {
            buf.m_130070_(this.teamName);
            buf.m_130077_(this.teamUUID);
            buf.m_130070_(this.teamOwnerName);
            buf.m_130130_(this.teamMembers.size());
            for (String member : this.teamMembers) {
                buf.m_130070_(member);
            }
            buf.m_130130_(this.teamAdmins.size());
            for (String admin : this.teamAdmins) {
                buf.m_130070_(admin);
            }
            buf.m_130130_(this.pendingApplications.size());
            for (String pending : this.pendingApplications) {
                buf.m_130070_(pending);
            }
        }
    }

    public static TeamInfoResponsePacket decode(FriendlyByteBuf buf) {
        return new TeamInfoResponsePacket(buf);
    }

    public static void handle(TeamInfoResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TeamInfoResponsePacket.handlePacket(packet)));
        ctx.get().setPacketHandled(true);
    }

    private static void handlePacket(TeamInfoResponsePacket packet) {
        ClientPacketHandler.onTeamInfoResponse(packet);
    }

    public boolean isInTeam() {
        return this.isInTeam;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public String getTeamOwnerName() {
        return this.teamOwnerName;
    }

    public List<String> getTeamMembers() {
        return this.teamMembers;
    }

    public List<String> getTeamAdmins() {
        return this.teamAdmins;
    }

    public List<String> getPendingApplications() {
        return this.pendingApplications;
    }
}

