/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class TeamListResponsePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_list_response");
    private final Map<UUID, TeamInfo> teams = new HashMap<UUID, TeamInfo>();

    public TeamListResponsePacket() {
    }

    public TeamListResponsePacket(FriendlyByteBuf buf) {
        int teamCount = buf.readInt();
        for (int i = 0; i < teamCount; ++i) {
            UUID teamUUID = buf.m_130259_();
            String teamName = buf.m_130277_();
            int memberCount = buf.readInt();
            String ownerName = buf.m_130277_();
            RelationSystem.RelationType relation = RelationSystem.RelationType.valueOf(buf.m_130277_());
            this.teams.put(teamUUID, new TeamInfo(teamName, memberCount, ownerName, relation));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.teams.size());
        for (Map.Entry<UUID, TeamInfo> entry : this.teams.entrySet()) {
            buf.m_130077_(entry.getKey());
            buf.m_130070_(entry.getValue().getTeamName());
            buf.writeInt(entry.getValue().getMemberCount());
            buf.m_130070_(entry.getValue().getOwnerName());
            buf.m_130070_(entry.getValue().getRelation().name());
        }
    }

    public static TeamListResponsePacket decode(FriendlyByteBuf buf) {
        return new TeamListResponsePacket(buf);
    }

    public static void handle(TeamListResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TeamListResponsePacket.handlePacket(packet)));
        ctx.get().setPacketHandled(true);
    }

    private static void handlePacket(TeamListResponsePacket packet) {
        ClientPacketHandler.onTeamListResponse(packet);
    }

    public void addTeam(UUID teamUUID, String teamName, int memberCount, String ownerName, RelationSystem.RelationType relation) {
        this.teams.put(teamUUID, new TeamInfo(teamName, memberCount, ownerName, relation));
    }

    public Map<UUID, TeamInfo> getTeams() {
        return this.teams;
    }

    public static class TeamInfo {
        private final String teamName;
        private final int memberCount;
        private final String ownerName;
        private final RelationSystem.RelationType relation;

        public TeamInfo(String teamName, int memberCount, String ownerName, RelationSystem.RelationType relation) {
            this.teamName = teamName;
            this.memberCount = memberCount;
            this.ownerName = ownerName;
            this.relation = relation;
        }

        public String getTeamName() {
            return this.teamName;
        }

        public int getMemberCount() {
            return this.memberCount;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public RelationSystem.RelationType getRelation() {
            return this.relation;
        }
    }
}

