/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;
import ydmsama.hundred_years_war.main.utils.PlayerRelationData;
import ydmsama.hundred_years_war.main.utils.RelationData;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamMembersRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_members_request");
    private final UUID teamUUID;

    public TeamMembersRequestPacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public TeamMembersRequestPacket(FriendlyByteBuf buf) {
        this.teamUUID = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.teamUUID);
    }

    public static TeamMembersRequestPacket decode(FriendlyByteBuf buf) {
        return new TeamMembersRequestPacket(buf);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public static void handle(TeamMembersRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                TeamMembersRequestPacket.handlePacket(player, packet.getTeamUUID());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, UUID teamUUID) {
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData != null) {
            ArrayList<TeamMembersResponsePacket.Member> members = new ArrayList<TeamMembersResponsePacket.Member>();
            String teamName = teamData.getTeamName();
            Map<UUID, TeamRelationData.MemberType> allMembers = teamData.getAllMembers();
            for (Map.Entry<UUID, TeamRelationData.MemberType> entry : allMembers.entrySet()) {
                UUID memberUUID = entry.getKey();
                TeamRelationData.MemberType memberType = entry.getValue();
                RelationData relationData = RelationSystem.getRelationData(memberUUID);
                String memberName = relationData instanceof PlayerRelationData ? ((PlayerRelationData)relationData).getPlayerName() : Optional.ofNullable(player.m_20194_().m_6846_().m_11259_(memberUUID)).map(p -> p.m_7755_().getString()).orElse("Unknown");
                TeamMembersResponsePacket.Member.Role role = switch (memberType) {
                    case TeamRelationData.MemberType.OWNER -> TeamMembersResponsePacket.Member.Role.OWNER;
                    case TeamRelationData.MemberType.ADMIN -> TeamMembersResponsePacket.Member.Role.ADMIN;
                    default -> TeamMembersResponsePacket.Member.Role.MEMBER;
                };
                long joinTime = System.currentTimeMillis();
                members.add(new TeamMembersResponsePacket.Member(memberName, memberUUID, role, joinTime));
            }
            TeamMembersResponsePacket responsePacket = new TeamMembersResponsePacket(teamUUID, teamName, members);
            ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
        } else {
            ArrayList<TeamMembersResponsePacket.Member> emptyList = new ArrayList<TeamMembersResponsePacket.Member>();
            TeamMembersResponsePacket responsePacket = new TeamMembersResponsePacket(teamUUID, "Unknown Team", emptyList);
            ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
        }
    }
}

