/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationResponsePacket;
import ydmsama.hundred_years_war.main.utils.PlayerRelationData;
import ydmsama.hundred_years_war.main.utils.RelationData;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamRelationRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_relation_request_packet");
    private final UUID teamUUID;

    public TeamRelationRequestPacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.teamUUID);
    }

    public static TeamRelationRequestPacket decode(FriendlyByteBuf buf) {
        UUID teamUUID = buf.m_130259_();
        return new TeamRelationRequestPacket(teamUUID);
    }

    public static void handle(TeamRelationRequestPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                TeamRelationRequestPacket.handlePacket(player, msg.getTeamUUID());
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, UUID teamUUID) {
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData == null) {
            return;
        }
        if (!teamData.isMember(player.m_20148_())) {
            return;
        }
        TeamRelationResponsePacket responsePacket = new TeamRelationResponsePacket(teamUUID);
        for (Map.Entry<UUID, RelationData> entry : RelationSystem.getAllRelationData().entrySet()) {
            UUID targetUUID = entry.getKey();
            RelationData relationData = entry.getValue();
            if (targetUUID.equals(teamUUID) || teamData.isMember(targetUUID)) continue;
            if (relationData instanceof PlayerRelationData) {
                PlayerRelationData targetPlayerData = (PlayerRelationData)relationData;
                RelationSystem.RelationType teamToPlayerRelation = RelationSystem.getRelation(teamUUID, targetUUID);
                RelationSystem.RelationType playerToTeamRelation = RelationSystem.getRelation(targetUUID, teamUUID);
                responsePacket.addRelationInfo(targetUUID, targetPlayerData.getPlayerName(), teamToPlayerRelation, playerToTeamRelation);
                continue;
            }
            if (!(relationData instanceof TeamRelationData)) continue;
            TeamRelationData otherTeamData = (TeamRelationData)relationData;
            RelationSystem.RelationType teamToTeamRelation = RelationSystem.getRelation(teamUUID, targetUUID);
            RelationSystem.RelationType otherTeamToTeamRelation = RelationSystem.getRelation(targetUUID, teamUUID);
            responsePacket.addTeamInfo(targetUUID, otherTeamData.getTeamName(), teamToTeamRelation, otherTeamData.getAllMembers(), otherTeamToTeamRelation);
        }
        ServerPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)responsePacket);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }
}

