/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationRequestPacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamRelationUpdatePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_relation_update_packet");
    private final UUID teamUUID;
    private final Map<UUID, RelationSystem.RelationType> relationUpdates = new HashMap<UUID, RelationSystem.RelationType>();

    public TeamRelationUpdatePacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public void addRelationUpdate(UUID targetUUID, RelationSystem.RelationType relationType) {
        this.relationUpdates.put(targetUUID, relationType);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.teamUUID);
        buf.writeInt(this.relationUpdates.size());
        for (Map.Entry<UUID, RelationSystem.RelationType> entry : this.relationUpdates.entrySet()) {
            buf.m_130077_(entry.getKey());
            buf.writeInt(entry.getValue().ordinal());
        }
    }

    public static TeamRelationUpdatePacket decode(FriendlyByteBuf buf) {
        UUID teamUUID = buf.m_130259_();
        TeamRelationUpdatePacket packet = new TeamRelationUpdatePacket(teamUUID);
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            UUID targetUUID = buf.m_130259_();
            RelationSystem.RelationType relationType = RelationSystem.RelationType.values()[buf.readInt()];
            packet.addRelationUpdate(targetUUID, relationType);
        }
        return packet;
    }

    public static void handlePacket(ServerPlayer player, TeamRelationUpdatePacket packet) {
        UUID playerUUID = player.m_20148_();
        UUID teamUUID = packet.getTeamUUID();
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData == null) {
            return;
        }
        TeamRelationData.MemberType memberType = teamData.getMemberType(playerUUID);
        if (memberType != TeamRelationData.MemberType.ADMIN && memberType != TeamRelationData.MemberType.OWNER) {
            return;
        }
        for (Map.Entry<UUID, RelationSystem.RelationType> entry : packet.relationUpdates.entrySet()) {
            UUID targetUUID = entry.getKey();
            RelationSystem.RelationType relationType = entry.getValue();
            RelationSystem.setRelation(teamUUID, targetUUID, relationType);
            Set<UUID> ourTeamMembers = teamData.getAllMembers().keySet();
            TeamRelationData targetTeamData = RelationSystem.getTeamRelationData(targetUUID);
            if (targetTeamData != null) {
                Set<UUID> theirTeamMembers = targetTeamData.getAllMembers().keySet();
                for (UUID ourMemberUUID : ourTeamMembers) {
                    RelationSystem.setRelation(ourMemberUUID, targetUUID, relationType);
                    for (UUID theirMemberUUID : theirTeamMembers) {
                        RelationSystem.setRelation(ourMemberUUID, theirMemberUUID, relationType);
                    }
                }
                continue;
            }
            for (UUID memberUUID : ourTeamMembers) {
                RelationSystem.setRelation(memberUUID, targetUUID, relationType);
            }
        }
        TeamRelationRequestPacket.handlePacket(player, teamUUID);
    }

    public static void handle(TeamRelationUpdatePacket packet, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getSender() != null) {
                TeamRelationUpdatePacket.handlePacket(ctx.getSender(), packet);
            }
        });
        ctx.setPacketHandled(true);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public Map<UUID, RelationSystem.RelationType> getRelationUpdates() {
        return this.relationUpdates;
    }
}

