/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.item.TransportOrderItem;

public class TransportActionPacket {
    private final boolean isMainHand;

    public TransportActionPacket(boolean isMainHand) {
        this.isMainHand = isMainHand;
    }

    public static void encode(TransportActionPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.isMainHand);
    }

    public static TransportActionPacket decode(FriendlyByteBuf buf) {
        boolean isMainHand = buf.readBoolean();
        return new TransportActionPacket(isMainHand);
    }

    public static void handle(TransportActionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                TransportActionPacket.handlePacket(player, packet.isMainHand);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, boolean isMainHand) {
        ItemStack stack;
        ItemStack itemStack = stack = isMainHand ? player.m_21205_() : player.m_21206_();
        if (stack.m_41720_() instanceof TransportOrderItem) {
            TransportOrderItem.handleKeyAction(player, stack);
        }
    }
}

