/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.data.TransportData;

public class TransportDataUpdatePacket {
    private final BlockPos pos;
    private final TransportData transportData;

    public TransportDataUpdatePacket(BlockPos pos, TransportData transportData) {
        this.pos = pos;
        this.transportData = transportData;
    }

    public static void encode(TransportDataUpdatePacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.m_130079_(packet.transportData.serializeNBT());
    }

    public static TransportDataUpdatePacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        TransportData data = new TransportData();
        data.deserializeNBT(buf.m_130260_());
        return new TransportDataUpdatePacket(pos, data);
    }

    public static void handle(TransportDataUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = context.getSender();
            if (player != null && (blockEntity = player.m_9236_().m_7702_(packet.pos)) instanceof TransportWorkstationBlockEntity) {
                TransportWorkstationBlockEntity workstation = (TransportWorkstationBlockEntity)blockEntity;
                workstation.setTransportData(packet.transportData);
                workstation.syncToClient();
            }
        });
        context.setPacketHandled(true);
    }
}

