/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.item.TransportOrderItem;

public class UnbindTransportOrderPacket {
    public static void encode(UnbindTransportOrderPacket packet, FriendlyByteBuf buf) {
    }

    public static UnbindTransportOrderPacket decode(FriendlyByteBuf buf) {
        return new UnbindTransportOrderPacket();
    }

    public static void handle(UnbindTransportOrderPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                UnbindTransportOrderPacket.handleUnbind(player);
            }
        });
        context.setPacketHandled(true);
    }

    private static void handleUnbind(ServerPlayer player) {
        ItemStack mainHandItem = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandItem = player.m_21120_(InteractionHand.OFF_HAND);
        ItemStack transportOrderStack = null;
        InteractionHand hand = null;
        if (mainHandItem.m_41778_().contains("transport_order")) {
            transportOrderStack = mainHandItem;
            hand = InteractionHand.MAIN_HAND;
        } else if (offHandItem.m_41778_().contains("transport_order")) {
            transportOrderStack = offHandItem;
            hand = InteractionHand.OFF_HAND;
        }
        if (transportOrderStack != null && hand != null) {
            BlockPos boundPos = TransportOrderItem.getBoundWorkstation(transportOrderStack);
            if (boundPos != null) {
                transportOrderStack.m_41749_("BoundPos");
                transportOrderStack.m_41749_("TransportData");
                player.m_150109_().m_6596_();
                player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.unbound"), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.not_bound"), true);
            }
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.no_item"), true);
        }
    }
}

