/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import ydmsama.hundred_years_war.main.blocks.BaseStructureCoreBlockEntity;
import ydmsama.hundred_years_war.main.structure.ConstructionTask;

@Mod.EventBusSubscriber
public class ConstructionManager {
    private static final List<ConstructionTask> tasks = Collections.synchronizedList(new ArrayList());
    private static final List<BaseStructureCoreBlockEntity> blocksToRestore = Collections.synchronizedList(new ArrayList());

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            for (ServerLevel level : server.m_129785_()) {
                ConstructionManager.tick(level);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        tasks.clear();
        blocksToRestore.clear();
    }

    public static void addTask(ConstructionTask task) {
        tasks.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(ServerLevel serverLevel) {
        List<Object> list = tasks;
        synchronized (list) {
            Iterator<ConstructionTask> iterator = tasks.iterator();
            while (iterator.hasNext()) {
                ConstructionTask task = iterator.next();
                task.tick();
                if (!task.isComplete()) continue;
                iterator.remove();
            }
        }
        list = blocksToRestore;
        synchronized (list) {
            Iterator<BaseStructureCoreBlockEntity> blockIterator = blocksToRestore.iterator();
            while (blockIterator.hasNext()) {
                BaseStructureCoreBlockEntity blockEntity = blockIterator.next();
                blockEntity.restoreTask(serverLevel);
                blockIterator.remove();
            }
        }
    }

    public static void addBlockEntityToRestore(BaseStructureCoreBlockEntity blockEntity) {
        blocksToRestore.add(blockEntity);
    }
}

