/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.structure;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import ydmsama.hundred_years_war.main.blocks.BaseStructureCoreBlockEntity;
import ydmsama.hundred_years_war.main.blocks.ModBlocks;
import ydmsama.hundred_years_war.main.mixins.StructureBlockInfoAccessor;
import ydmsama.hundred_years_war.main.mixins.StructureTemplateAccessor;

public class ConstructionTask {
    private final ServerLevel serverLevel;
    private final StructureTemplate structureTemplate;
    private final StructurePlaceSettings placeSettings;
    private final BlockPos buildPos;
    private final int totalTicks;
    private final String templateName;
    private final double blocksPerSecond;
    private int elapsedTicks;
    private final List<StructureTemplate.StructureBlockInfo> blockList;
    private int totalBlocks;
    private int currentBlockIndex;
    private BaseStructureCoreBlockEntity coreBlockEntity;
    private boolean forceComplete = false;
    private final boolean isBatchMode;
    private final double blocksPerTick;
    private final double blocksPerBatch;
    private final int batchIntervalTicks = 20;
    private final int totalBatches;
    private double blockPlacementAccumulator = 0.0;

    public ConstructionTask(ServerLevel serverLevel, StructureTemplate structureTemplate, StructurePlaceSettings placeSettings, BlockPos centerPos, int totalTicks, String templateName, int currentBlockIndex, BaseStructureCoreBlockEntity coreBlockEntity) {
        this.serverLevel = serverLevel;
        this.structureTemplate = structureTemplate;
        this.placeSettings = placeSettings;
        this.buildPos = this.getBuildPosition(centerPos);
        this.totalTicks = totalTicks;
        this.templateName = templateName;
        this.elapsedTicks = 0;
        this.blockList = new ArrayList<StructureTemplate.StructureBlockInfo>(((StructureTemplateAccessor)structureTemplate).getPalettes().get(0).m_74652_());
        this.blockList.sort((block1, block2) -> {
            Block block1Type = ((StructureBlockInfoAccessor)block1).getState().m_60734_();
            Block block2Type = ((StructureBlockInfoAccessor)block2).getState().m_60734_();
            if (block1Type == ModBlocks.BASE_STRUCTURE_CORE.get()) {
                return -1;
            }
            if (block2Type == ModBlocks.BASE_STRUCTURE_CORE.get()) {
                return 1;
            }
            if (block1Type instanceof FallingBlock && !(block2Type instanceof FallingBlock)) {
                return 1;
            }
            if (!(block1Type instanceof FallingBlock) && block2Type instanceof FallingBlock) {
                return -1;
            }
            return 0;
        });
        this.totalBlocks = this.blockList.size();
        this.currentBlockIndex = currentBlockIndex;
        this.coreBlockEntity = coreBlockEntity;
        this.blocksPerTick = (double)this.totalBlocks / (double)this.totalTicks;
        this.blocksPerSecond = this.blocksPerTick * 20.0;
        if (this.blocksPerSecond > 1.0) {
            this.isBatchMode = true;
            this.totalBatches = (int)Math.ceil((double)totalTicks / 20.0);
            this.blocksPerBatch = (double)this.totalBlocks / (double)this.totalBatches;
        } else {
            this.isBatchMode = false;
            this.blocksPerBatch = this.blocksPerTick;
            this.totalBatches = 0;
        }
    }

    public boolean isComplete() {
        if (this.forceComplete) {
            return true;
        }
        if (this.currentBlockIndex >= this.totalBlocks) {
            if (this.coreBlockEntity != null) {
                this.coreBlockEntity.setTaskComplete(true);
            }
            return true;
        }
        return false;
    }

    public void tick() {
        if (!this.isComplete()) {
            if (this.elapsedTicks == 0 && !this.canBuildHere()) {
                this.forceComplete = true;
                return;
            }
            ++this.elapsedTicks;
            if (this.isBatchMode) {
                if (this.elapsedTicks % 20 == 0) {
                    this.blockPlacementAccumulator += this.blocksPerBatch;
                    int blocksToPlace = (int)this.blockPlacementAccumulator;
                    this.blockPlacementAccumulator -= (double)blocksToPlace;
                    for (int i = 0; i < blocksToPlace && this.currentBlockIndex < this.totalBlocks; ++i) {
                        StructureTemplate.StructureBlockInfo blockInfo = this.blockList.get(this.currentBlockIndex);
                        this.placeBlock(blockInfo);
                        ++this.currentBlockIndex;
                    }
                    if (this.coreBlockEntity != null) {
                        this.coreBlockEntity.setCurrentBatchIndex(this.coreBlockEntity.getCurrentBatchIndex() + 1);
                    }
                }
            } else {
                this.blockPlacementAccumulator += this.blocksPerTick;
                int blocksToPlace = (int)this.blockPlacementAccumulator;
                this.blockPlacementAccumulator -= (double)blocksToPlace;
                for (int i = 0; i < blocksToPlace && this.currentBlockIndex < this.totalBlocks; ++i) {
                    StructureTemplate.StructureBlockInfo blockInfo = this.blockList.get(this.currentBlockIndex);
                    this.placeBlock(blockInfo);
                    ++this.currentBlockIndex;
                }
                if (this.coreBlockEntity != null) {
                    this.coreBlockEntity.setCurrentBatchIndex(this.coreBlockEntity.getCurrentBatchIndex() + 1);
                }
            }
            if (this.coreBlockEntity != null) {
                this.coreBlockEntity.setCurrentBlockIndex(this.currentBlockIndex);
            }
        }
    }

    private void placeBlock(StructureTemplate.StructureBlockInfo blockInfo) {
        BlockPos relativePos = ((StructureBlockInfoAccessor)blockInfo).getPos();
        BlockPos rotatedPos = StructureTemplate.m_74563_((StructurePlaceSettings)this.placeSettings, (BlockPos)relativePos);
        BlockPos absolutePos = rotatedPos.m_121955_((Vec3i)this.buildPos);
        BlockState state = ((StructureBlockInfoAccessor)blockInfo).getState().m_60715_(this.placeSettings.m_74401_()).m_60717_(this.placeSettings.m_74404_());
        this.serverLevel.m_7731_(absolutePos, state, 3);
        if (state.m_60734_() == ModBlocks.BASE_STRUCTURE_CORE.get()) {
            this.coreBlockEntity = (BaseStructureCoreBlockEntity)this.serverLevel.m_7702_(absolutePos);
            if (this.coreBlockEntity instanceof BaseStructureCoreBlockEntity) {
                this.coreBlockEntity.setTemplateData(this.templateName, this.structureTemplate.m_163801_(), this.placeSettings.m_74404_(), this.placeSettings.m_74401_(), this.buildPos);
            }
        }
    }

    public boolean canBuildHere() {
        return this.checkFoundation();
    }

    private boolean checkFoundation() {
        Vec3i size = this.structureTemplate.m_163801_();
        int sizeX = size.m_123341_();
        int sizeZ = size.m_123343_();
        for (int layer = 1; layer <= 2; ++layer) {
            int currentY = this.buildPos.m_123342_() - layer;
            int nonEmptyBlocks = 0;
            int totalBlocks = sizeX * sizeZ;
            for (int x = 0; x < sizeX; ++x) {
                for (int z = 0; z < sizeZ; ++z) {
                    BlockPos relativePos = new BlockPos(x, 0, z);
                    BlockPos rotatedPos = StructureTemplate.m_74563_((StructurePlaceSettings)this.placeSettings, (BlockPos)relativePos);
                    BlockPos absolutePos = new BlockPos(rotatedPos.m_123341_() + this.buildPos.m_123341_(), currentY, rotatedPos.m_123343_() + this.buildPos.m_123343_());
                    BlockState state = this.serverLevel.m_8055_(absolutePos);
                    if (state.m_60795_()) continue;
                    ++nonEmptyBlocks;
                }
            }
            double percentage = (double)nonEmptyBlocks / (double)totalBlocks * 100.0;
            if (!(percentage < 75.0)) continue;
            return false;
        }
        return true;
    }

    public BlockPos getBuildPosition(BlockPos position1) {
        Vec3i rotatedSize = ConstructionTask.rotateVec3i(this.structureTemplate.m_163801_(), this.placeSettings.m_74404_());
        int offsetX = rotatedSize.m_123341_() / 2;
        int offsetY = rotatedSize.m_123342_() / 2;
        int offsetZ = rotatedSize.m_123343_() / 2;
        if (rotatedSize.m_123341_() % 2 == 0) {
            --offsetX;
        }
        if (rotatedSize.m_123342_() % 2 == 0) {
            --offsetY;
        }
        if (rotatedSize.m_123343_() % 2 == 0) {
            --offsetZ;
        }
        BlockPos position2 = position1.m_7918_(-offsetX, 0, -offsetZ);
        return position2;
    }

    static Vec3i rotateVec3i(Vec3i vec, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new Vec3i(-vec.m_123343_(), vec.m_123342_(), vec.m_123341_());
            case Rotation.CLOCKWISE_180 -> new Vec3i(-vec.m_123341_(), vec.m_123342_(), -vec.m_123343_());
            case Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(vec.m_123343_(), vec.m_123342_(), -vec.m_123341_());
            default -> vec;
        };
    }

    public int getElapsedTicks() {
        return this.elapsedTicks;
    }
}

