/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.projectile.BlockBreakable;

public class BlockBreakHandler {
    private static BlockBreakHandler instance;
    private final Random random = new Random();

    private BlockBreakHandler() {
    }

    public static BlockBreakHandler getInstance() {
        if (instance == null) {
            instance = new BlockBreakHandler();
        }
        return instance;
    }

    public void handleBlockBreaking(Projectile projectile, Level level, Vec3 pos) {
        if (!(projectile instanceof BlockBreakable)) {
            return;
        }
        BlockBreakable breakable = (BlockBreakable)projectile;
        if (!breakable.canBreakBlocks()) {
            return;
        }
        float radius = breakable.getBreakRadius();
        float maxHardness = breakable.getMaxBreakableHardness();
        int maxBlocks = breakable.getMaxBreakableBlocks();
        float baseProb = breakable.getBaseBreakProbability();
        this.breakBlocks(level, pos, radius, maxHardness, maxBlocks, baseProb);
    }

    private void breakBlocks(Level level, Vec3 center, float radius, float maxHardness, int maxBlocks, float baseProb) {
        if (!level.f_46443_ && radius > 0.0f && maxHardness > 0.0f && maxBlocks > 0 && baseProb > 0.0f) {
            BlockState state;
            BlockPos centerPos = new BlockPos((int)Math.floor(center.f_82479_), (int)Math.floor(center.f_82480_), (int)Math.floor(center.f_82481_));
            List<BlockPos> affectedBlocks = this.getBlocksInRadius(centerPos, radius);
            ArrayList<BlockPos> blocksToBreak = new ArrayList<BlockPos>();
            for (BlockPos pos : affectedBlocks) {
                float hardness;
                if (blocksToBreak.size() >= maxBlocks) break;
                state = level.m_8055_(pos);
                if (state.m_60795_() || state.m_60734_() == Blocks.f_50752_ || (hardness = state.m_60800_((BlockGetter)level, pos)) < 0.0f || hardness > maxHardness) continue;
                double distance = Math.sqrt(pos.m_123331_((Vec3i)centerPos));
                float distanceFactor = 1.0f - (float)(distance / (double)radius);
                float breakProbability = baseProb * distanceFactor;
                if (!(this.random.nextFloat() <= breakProbability)) continue;
                blocksToBreak.add(pos);
            }
            for (BlockPos pos : blocksToBreak) {
                state = level.m_8055_(pos);
                level.m_46961_(pos, false);
            }
        }
    }

    private List<BlockPos> getBlocksInRadius(BlockPos center, float radius) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        int intRadius = (int)Math.ceil(radius);
        for (int x = -intRadius; x <= intRadius; ++x) {
            for (int y = -intRadius; y <= intRadius; ++y) {
                for (int z = -intRadius; z <= intRadius; ++z) {
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (!(distance <= (double)radius)) continue;
                    blocks.add(center.m_7918_(x, y, z));
                }
            }
        }
        return blocks;
    }
}

