/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class CreativeModeSettings {
    private static final Map<UUID, Settings> SETTINGS = new ConcurrentHashMap<UUID, Settings>();

    private CreativeModeSettings() {
    }

    private static Settings getSettings(UUID playerId) {
        return SETTINGS.computeIfAbsent(playerId, id -> new Settings());
    }

    public static Settings getSettings(Player player) {
        return CreativeModeSettings.getSettings(player.m_20148_());
    }

    public static void setSummonFriendly(Player player, boolean friendly) {
        CreativeModeSettings.getSettings(player).setSummonFriendly(friendly);
    }

    public static void setControlAllUnits(Player player, boolean allow) {
        CreativeModeSettings.getSettings(player).setControlAllUnits(allow);
    }

    public static boolean isSummonFriendly(Player player) {
        if (!(player instanceof ServerPlayer) || !player.m_7500_()) {
            return false;
        }
        return CreativeModeSettings.getSettings(player).isSummonFriendly();
    }

    public static boolean canControlAllUnits(Player player) {
        if (!(player instanceof ServerPlayer) || !player.m_7500_()) {
            return false;
        }
        return CreativeModeSettings.getSettings(player).isControlAllUnits();
    }

    public static void remove(Player player) {
        SETTINGS.remove(player.m_20148_());
    }

    public static void sendSummonFeedback(Player player) {
        if (!(player instanceof ServerPlayer) || !player.m_7500_()) {
            return;
        }
        boolean friendly = CreativeModeSettings.isSummonFriendly(player);
        MutableComponent alignment = Component.m_237115_((String)(friendly ? "hud.hundred_years_war.creative_summon_relation.friendly" : "hud.hundred_years_war.creative_summon_relation.hostile")).m_130940_(friendly ? ChatFormatting.GREEN : ChatFormatting.RED);
        MutableComponent message = Component.m_237110_((String)"message.hundred_years_war.creative_summon_state", (Object[])new Object[]{alignment});
        player.m_5661_((Component)message, true);
    }

    public static final class Settings {
        private boolean summonFriendly;
        private boolean controlAllUnits = true;

        public boolean isSummonFriendly() {
            return this.summonFriendly;
        }

        public void setSummonFriendly(boolean summonFriendly) {
            this.summonFriendly = summonFriendly;
        }

        public boolean isControlAllUnits() {
            return this.controlAllUnits;
        }

        public void setControlAllUnits(boolean controlAllUnits) {
            this.controlAllUnits = controlAllUnits;
        }
    }
}

