/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ProjectileHitUtils {
    public static Vec3 getPreciseHitLocation(HitResult hitResult, Projectile projectile) {
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return ProjectileHitUtils.calculatePreciseEntityHitLocation(entityHitResult, projectile);
        }
        return hitResult.m_82450_();
    }

    private static Vec3 calculatePreciseEntityHitLocation(EntityHitResult entityHitResult, Projectile projectile) {
        Vec3 reverseRayEnd;
        Entity hitEntity = entityHitResult.m_82443_();
        Vec3 projectilePos = projectile.m_20182_();
        Vec3 projectileMotion = projectile.m_20184_();
        if (projectileMotion.m_82556_() < 1.0E-7) {
            return projectilePos;
        }
        AABB entityBounds = hitEntity.m_20191_();
        Vec3 rayStart = projectilePos.m_82546_(projectileMotion.m_82541_().m_82490_(0.1));
        double rayLength = Math.max(projectileMotion.m_82553_() * 2.0, 5.0);
        Vec3 rayEnd = projectilePos.m_82549_(projectileMotion.m_82541_().m_82490_(rayLength));
        Optional clipResult = entityBounds.m_82371_(rayStart, rayEnd);
        if (clipResult.isPresent()) {
            return (Vec3)clipResult.get();
        }
        Vec3 reverseRayStart = projectilePos.m_82549_(projectileMotion.m_82541_().m_82490_(0.5));
        Optional reverseClipResult = entityBounds.m_82371_(reverseRayStart, reverseRayEnd = projectilePos.m_82546_(projectileMotion.m_82541_().m_82490_(rayLength)));
        if (reverseClipResult.isPresent()) {
            return (Vec3)reverseClipResult.get();
        }
        if (entityBounds.m_82390_(projectilePos)) {
            return ProjectileHitUtils.getClosestPointOnAABB(entityBounds, projectilePos);
        }
        return projectilePos;
    }

    private static Vec3 getClosestPointOnAABB(AABB aabb, Vec3 point) {
        double clampedX = Math.max(aabb.f_82288_, Math.min(point.f_82479_, aabb.f_82291_));
        double clampedY = Math.max(aabb.f_82289_, Math.min(point.f_82480_, aabb.f_82292_));
        double clampedZ = Math.max(aabb.f_82290_, Math.min(point.f_82481_, aabb.f_82293_));
        if (clampedX == point.f_82479_ && clampedY == point.f_82480_ && clampedZ == point.f_82481_) {
            double distToMinX = point.f_82479_ - aabb.f_82288_;
            double distToMaxX = aabb.f_82291_ - point.f_82479_;
            double distToMinY = point.f_82480_ - aabb.f_82289_;
            double distToMaxY = aabb.f_82292_ - point.f_82480_;
            double distToMinZ = point.f_82481_ - aabb.f_82290_;
            double distToMaxZ = aabb.f_82293_ - point.f_82481_;
            double minDist = Math.min(Math.min(Math.min(distToMinX, distToMaxX), Math.min(distToMinY, distToMaxY)), Math.min(distToMinZ, distToMaxZ));
            if (minDist == distToMinX) {
                clampedX = aabb.f_82288_;
            } else if (minDist == distToMaxX) {
                clampedX = aabb.f_82291_;
            } else if (minDist == distToMinY) {
                clampedY = aabb.f_82289_;
            } else if (minDist == distToMaxY) {
                clampedY = aabb.f_82292_;
            } else if (minDist == distToMinZ) {
                clampedZ = aabb.f_82290_;
            } else if (minDist == distToMaxZ) {
                clampedZ = aabb.f_82293_;
            }
        }
        return new Vec3(clampedX, clampedY, clampedZ);
    }
}

