/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import ydmsama.hundred_years_war.main.utils.RelationData;

public class TeamRelationData
extends RelationData {
    private String teamName;
    private final Map<UUID, MemberType> members = new HashMap<UUID, MemberType>();
    private final Set<UUID> pendingApplications = new HashSet<UUID>();

    public TeamRelationData(UUID uuid, String teamName) {
        super(uuid);
        this.teamName = teamName;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public void addMember(UUID playerUuid, MemberType memberType) {
        this.members.put(playerUuid, memberType);
        this.pendingApplications.remove(playerUuid);
    }

    public boolean removeMember(UUID playerUuid) {
        return this.members.remove(playerUuid) != null;
    }

    public boolean updateMemberType(UUID playerUuid, MemberType memberType) {
        if (this.members.containsKey(playerUuid)) {
            this.members.put(playerUuid, memberType);
            return true;
        }
        return false;
    }

    public MemberType getMemberType(UUID playerUuid) {
        return this.members.get(playerUuid);
    }

    public boolean isMember(UUID playerUuid) {
        return this.members.containsKey(playerUuid);
    }

    public Map<UUID, MemberType> getAllMembers() {
        return Collections.unmodifiableMap(this.members);
    }

    public List<UUID> getMembersByType(MemberType type) {
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (Map.Entry<UUID, MemberType> entry : this.members.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public List<UUID> getOwners() {
        return this.getMembersByType(MemberType.OWNER);
    }

    public List<UUID> getAdmins() {
        return this.getMembersByType(MemberType.ADMIN);
    }

    public boolean addApplication(UUID playerUuid) {
        if (this.isMember(playerUuid)) {
            return false;
        }
        return this.pendingApplications.add(playerUuid);
    }

    public boolean removeApplication(UUID playerUuid) {
        return this.pendingApplications.remove(playerUuid);
    }

    public boolean approveApplication(UUID playerUuid, MemberType memberType) {
        if (this.pendingApplications.contains(playerUuid)) {
            this.pendingApplications.remove(playerUuid);
            return true;
        }
        return false;
    }

    public boolean rejectApplication(UUID playerUuid) {
        return this.pendingApplications.remove(playerUuid);
    }

    public boolean hasApplication(UUID playerUuid) {
        return this.pendingApplications.contains(playerUuid);
    }

    public Set<UUID> getPendingApplications() {
        return Collections.unmodifiableSet(this.pendingApplications);
    }

    @Override
    public CompoundTag saveToNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("UUID", this.uuid.toString());
        tag.m_128359_("TeamName", this.teamName);
        ListTag membersTag = new ListTag();
        for (Map.Entry<UUID, MemberType> entry : this.members.entrySet()) {
            CompoundTag memberTag = new CompoundTag();
            memberTag.m_128359_("UUID", entry.getKey().toString());
            memberTag.m_128359_("Type", entry.getValue().name());
            membersTag.add((Object)memberTag);
        }
        tag.m_128365_("Members", (Tag)membersTag);
        ListTag applicationsTag = new ListTag();
        for (UUID applicantUuid : this.pendingApplications) {
            applicationsTag.add((Object)StringTag.m_129297_((String)applicantUuid.toString()));
        }
        tag.m_128365_("Applications", (Tag)applicationsTag);
        return tag;
    }

    @Override
    public void loadFromNbt(CompoundTag tag) {
        int i;
        this.teamName = tag.m_128461_("TeamName");
        this.members.clear();
        this.pendingApplications.clear();
        if (tag.m_128441_("Members")) {
            ListTag membersTag = tag.m_128437_("Members", 10);
            for (i = 0; i < membersTag.size(); ++i) {
                CompoundTag memberTag = membersTag.m_128728_(i);
                UUID memberUuid = UUID.fromString(memberTag.m_128461_("UUID"));
                MemberType memberType = MemberType.valueOf(memberTag.m_128461_("Type"));
                this.members.put(memberUuid, memberType);
            }
        }
        if (tag.m_128441_("Applications")) {
            ListTag applicationsTag = tag.m_128437_("Applications", 8);
            for (i = 0; i < applicationsTag.size(); ++i) {
                UUID applicantUuid = UUID.fromString(applicationsTag.m_128778_(i));
                this.pendingApplications.add(applicantUuid);
            }
        }
    }

    public static enum MemberType {
        OWNER,
        ADMIN,
        MEMBER;

    }
}

