/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.config.ServerModConfig;

public class TreeFellingHandler {
    private static TreeFellingHandler instance;
    private final Random random = new Random();
    private static final int MAX_SEARCH_RADIUS = 20;
    private static final int[][] DIRECTIONS_26;

    private TreeFellingHandler() {
    }

    public static TreeFellingHandler getInstance() {
        if (instance == null) {
            instance = new TreeFellingHandler();
        }
        return instance;
    }

    public int fellTreesAroundSiegeEntity(Level level, Entity siegeEntity) {
        if (level.f_46443_) {
            return 0;
        }
        AABB boundingBox = siegeEntity.m_20191_();
        double entityWidth = Math.max(boundingBox.m_82362_(), boundingBox.m_82385_());
        double entityHeight = boundingBox.m_82376_();
        double horizontalRadius = entityWidth / 2.0 + ServerModConfig.INSTANCE.siegeTreeFellingExtraRange;
        double verticalRadius = entityHeight + ServerModConfig.INSTANCE.siegeTreeFellingExtraRange;
        int fellCount = 0;
        HashSet<BlockPos> processedPositions = new HashSet<BlockPos>();
        int intHorizontalRadius = (int)Math.ceil(horizontalRadius);
        int intVerticalRadius = (int)Math.ceil(verticalRadius);
        Vec3 center = siegeEntity.m_20182_();
        BlockPos centerPos = new BlockPos((int)center.f_82479_, (int)center.f_82480_, (int)center.f_82481_);
        for (int x = -intHorizontalRadius; x <= intHorizontalRadius; ++x) {
            for (int y = -intVerticalRadius; y <= intVerticalRadius; ++y) {
                for (int z = -intHorizontalRadius; z <= intHorizontalRadius; ++z) {
                    TreeStructure tree;
                    BlockState blockState;
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    if (processedPositions.contains(checkPos)) continue;
                    double horizontalDistance = Math.sqrt(x * x + z * z);
                    double verticalDistance = Math.abs(y);
                    if (horizontalDistance > horizontalRadius || verticalDistance > verticalRadius || !this.isLogBlock(blockState = level.m_8055_(checkPos)) && !this.isLeafBlock(blockState) || (tree = this.analyzeTree(level, checkPos, processedPositions)) == null || !this.isValidNaturalTree(tree)) continue;
                    this.fellTree(level, tree, center);
                    processedPositions.addAll(tree.getAllPositions());
                    ++fellCount;
                }
            }
        }
        return fellCount;
    }

    private TreeStructure analyzeTree(Level level, BlockPos startPos, Set<BlockPos> globalProcessed) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<BlockPos> logPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> leafPositions = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.offer(startPos);
        visited.add(startPos);
        int minY = startPos.m_123342_();
        int maxY = startPos.m_123342_();
        while (!queue.isEmpty() && visited.size() < ServerModConfig.INSTANCE.maxTreeLogCount + 200) {
            BlockPos current = (BlockPos)queue.poll();
            BlockState currentState = level.m_8055_(current);
            if (this.isLogBlock(currentState)) {
                logPositions.add(current);
                minY = Math.min(minY, current.m_123342_());
                maxY = Math.max(maxY, current.m_123342_());
                if (maxY - minY > ServerModConfig.INSTANCE.maxTreeHeight) {
                    return null;
                }
            } else if (this.isLeafBlock(currentState)) {
                leafPositions.add(current);
            }
            for (int[] dir : DIRECTIONS_26) {
                BlockState neighborState;
                BlockPos neighborPos = current.m_7918_(dir[0], dir[1], dir[2]);
                if (Math.abs(neighborPos.m_123341_() - startPos.m_123341_()) > 20 || Math.abs(neighborPos.m_123343_() - startPos.m_123343_()) > 20 || Math.abs(neighborPos.m_123342_() - startPos.m_123342_()) > ServerModConfig.INSTANCE.maxTreeHeight || visited.contains(neighborPos) || globalProcessed.contains(neighborPos) || !this.isLogBlock(neighborState = level.m_8055_(neighborPos)) && !this.isLeafBlock(neighborState)) continue;
                visited.add(neighborPos);
                queue.offer(neighborPos);
            }
        }
        if (logPositions.size() >= ServerModConfig.INSTANCE.minTreeLogCount || logPositions.isEmpty() && !leafPositions.isEmpty()) {
            return new TreeStructure(logPositions, leafPositions, minY, maxY);
        }
        return null;
    }

    private boolean isValidNaturalTree(TreeStructure tree) {
        int logCount = tree.logPositions.size();
        int leafCount = tree.leafPositions.size();
        int height = tree.maxY - tree.minY + 1;
        if (logCount == 0 && leafCount > 0) {
            return true;
        }
        if (logCount > 0) {
            if (logCount < ServerModConfig.INSTANCE.minTreeLogCount || logCount > ServerModConfig.INSTANCE.maxTreeLogCount) {
                return false;
            }
            if (height < ServerModConfig.INSTANCE.minTreeHeight || height > ServerModConfig.INSTANCE.maxTreeHeight) {
                return false;
            }
            if ((double)leafCount < (double)logCount * 0.5) {
                return false;
            }
            return this.hasVerticalTrunk(tree);
        }
        return false;
    }

    private boolean hasVerticalTrunk(TreeStructure tree) {
        HashSet<BlockPos> bottomLogs = new HashSet<BlockPos>();
        for (BlockPos pos : tree.logPositions) {
            if (pos.m_123342_() != tree.minY) continue;
            bottomLogs.add(pos);
        }
        for (BlockPos bottomLog : bottomLogs) {
            int consecutiveHeight = 1;
            BlockPos checkPos = bottomLog.m_7494_();
            while (tree.logPositions.contains(checkPos) && consecutiveHeight < tree.getHeight()) {
                ++consecutiveHeight;
                checkPos = checkPos.m_7494_();
            }
            if (consecutiveHeight < Math.min(1, tree.getHeight() / 2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void fellTree(Level level, TreeStructure tree, Vec3 siegePosition) {
        HashMap<String, List> verticalColumns = new HashMap<String, List>();
        for (BlockPos blockPos : tree.leafPositions) {
            String string = blockPos.m_123341_() + "," + blockPos.m_123343_();
            verticalColumns.computeIfAbsent(string, k -> new ArrayList()).add(blockPos);
        }
        for (BlockPos blockPos : tree.logPositions) {
            String string = blockPos.m_123341_() + "," + blockPos.m_123343_();
            verticalColumns.computeIfAbsent(string, k -> new ArrayList()).add(blockPos);
        }
        ArrayList<VerticalColumnDistance> columnsToDestroy = new ArrayList<VerticalColumnDistance>();
        for (Map.Entry entry : verticalColumns.entrySet()) {
            List columnBlocks = (List)entry.getValue();
            if (columnBlocks.isEmpty()) continue;
            BlockPos representative = (BlockPos)columnBlocks.get(0);
            double horizontalDistance = Math.sqrt(Math.pow((double)representative.m_123341_() - siegePosition.f_82479_, 2.0) + Math.pow((double)representative.m_123343_() - siegePosition.f_82481_, 2.0));
            columnBlocks.sort(Comparator.comparingInt(Vec3i::m_123342_));
            columnsToDestroy.add(new VerticalColumnDistance(columnBlocks, horizontalDistance));
        }
        columnsToDestroy.sort(Comparator.comparingDouble(c -> c.horizontalDistance));
        int n = ServerModConfig.INSTANCE.maxSiegeTreeBlocksPerAction;
        boolean bl = false;
        block3: for (VerticalColumnDistance columnInfo : columnsToDestroy) {
            void var7_17;
            if (var7_17 >= n) break;
            for (BlockPos pos : columnInfo.columnBlocks) {
                if (var7_17 >= n) continue block3;
                BlockState state = level.m_8055_(pos);
                if (state.m_60795_()) continue;
                if (this.random.nextFloat() < ServerModConfig.INSTANCE.siegeTreeParticleChance) {
                    level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                }
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
                ++var7_17;
            }
        }
    }

    private boolean isLogBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13105_);
    }

    private boolean isLeafBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13035_);
    }

    static {
        DIRECTIONS_26 = new int[][]{{-1, 0, -1}, {-1, 0, 0}, {-1, 0, 1}, {0, 0, -1}, {0, 0, 1}, {1, 0, -1}, {1, 0, 0}, {1, 0, 1}, {-1, 1, -1}, {-1, 1, 0}, {-1, 1, 1}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {1, 1, -1}, {1, 1, 0}, {1, 1, 1}, {-1, -1, -1}, {-1, -1, 0}, {-1, -1, 1}, {0, -1, -1}, {0, -1, 0}, {0, -1, 1}, {1, -1, -1}, {1, -1, 0}, {1, -1, 1}};
    }

    private static class TreeStructure {
        final Set<BlockPos> logPositions;
        final Set<BlockPos> leafPositions;
        final int minY;
        final int maxY;

        TreeStructure(Set<BlockPos> logPositions, Set<BlockPos> leafPositions, int minY, int maxY) {
            this.logPositions = logPositions;
            this.leafPositions = leafPositions;
            this.minY = minY;
            this.maxY = maxY;
        }

        Set<BlockPos> getAllPositions() {
            HashSet<BlockPos> all = new HashSet<BlockPos>(this.logPositions);
            all.addAll(this.leafPositions);
            return all;
        }

        int getHeight() {
            return this.maxY - this.minY + 1;
        }
    }

    private static class VerticalColumnDistance {
        final List<BlockPos> columnBlocks;
        final double horizontalDistance;

        VerticalColumnDistance(List<BlockPos> columnBlocks, double horizontalDistance) {
            this.columnBlocks = columnBlocks;
            this.horizontalDistance = horizontalDistance;
        }
    }
}

