/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import com.google.common.collect.Multimap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import ydmsama.hundred_years_war.main.item.PikeItem;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class WeaponTypeHelper {
    public static String getItemRegistryName(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return null;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
        return itemId != null ? itemId.toString() : null;
    }

    public static String getItemNamespace(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return null;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
        return itemId != null ? itemId.m_135827_() : null;
    }

    public static String getItemPath(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return null;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
        return itemId != null ? itemId.m_135815_() : null;
    }

    public static boolean isSwordLikeWeapon(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof SwordItem && !(item instanceof PikeItem)) {
            return true;
        }
        if (itemStack.m_204117_(ItemTags.f_271388_)) {
            return true;
        }
        String registryName = WeaponTypeHelper.getItemRegistryName(itemStack);
        if (registryName != null) {
            if (registryName.contains("tconstruct") && (registryName.contains("sword") || registryName.contains("blade"))) {
                return true;
            }
            if ("tetra:modular_sword".equals(registryName)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAxeLikeWeapon(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof AxeItem) {
            return true;
        }
        if (itemStack.m_204117_(ItemTags.f_271207_)) {
            return true;
        }
        String registryName = WeaponTypeHelper.getItemRegistryName(itemStack);
        if (registryName != null) {
            if (registryName.contains("tconstruct") && registryName.contains("axe")) {
                return true;
            }
            if ("tetra:modular_double".equals(registryName) || "tetra:modular_single".equals(registryName)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isBowLikeWeapon(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof BowItem) {
            return true;
        }
        if (item instanceof ProjectileWeaponItem && !(item instanceof CrossbowItem)) {
            return true;
        }
        String registryName = WeaponTypeHelper.getItemRegistryName(itemStack);
        return registryName != null && registryName.contains("tconstruct") && (registryName.contains("bow") || registryName.contains("crossbow"));
    }

    public static boolean isCrossbowLikeWeapon(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CrossbowItem) {
            return true;
        }
        String registryName = WeaponTypeHelper.getItemRegistryName(itemStack);
        return registryName != null && registryName.contains("tconstruct") && registryName.contains("crossbow");
    }

    public static boolean isPikeLikeWeapon(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        return item instanceof PikeItem;
    }

    public static boolean isLanceLikeWeapon(ItemStack itemStack) {
        boolean isLance;
        if (itemStack.m_41619_()) {
            return false;
        }
        boolean bl = isLance = itemStack.m_150930_((Item)HywItemRegistry.WOODEN_LANCE.get()) || itemStack.m_150930_((Item)HywItemRegistry.IRON_LANCE.get()) || itemStack.m_150930_((Item)HywItemRegistry.GOLDEN_LANCE.get()) || itemStack.m_150930_((Item)HywItemRegistry.DIAMOND_LANCE.get());
        if (isLance) {
            return true;
        }
        String registryName = WeaponTypeHelper.getItemRegistryName(itemStack);
        return registryName != null && registryName.contains("tconstruct") && registryName.contains("lance");
    }

    public static boolean isShieldLikeItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof ShieldItem) {
            return true;
        }
        String registryName = WeaponTypeHelper.getItemRegistryName(itemStack);
        return registryName != null && registryName.contains("tconstruct") && registryName.contains("shield");
    }

    public static boolean isSameWeaponType(ItemStack item1, ItemStack item2) {
        if (item1.m_41619_() || item2.m_41619_()) {
            return false;
        }
        if (WeaponTypeHelper.isSwordLikeWeapon(item1) && WeaponTypeHelper.isSwordLikeWeapon(item2)) {
            return true;
        }
        if (WeaponTypeHelper.isPikeLikeWeapon(item1) && WeaponTypeHelper.isPikeLikeWeapon(item2)) {
            return true;
        }
        if (WeaponTypeHelper.isBowLikeWeapon(item1) && WeaponTypeHelper.isBowLikeWeapon(item2)) {
            return true;
        }
        if (WeaponTypeHelper.isAxeLikeWeapon(item1) && WeaponTypeHelper.isAxeLikeWeapon(item2)) {
            return true;
        }
        if (WeaponTypeHelper.isCrossbowLikeWeapon(item1) && WeaponTypeHelper.isCrossbowLikeWeapon(item2)) {
            return true;
        }
        if (WeaponTypeHelper.isLanceLikeWeapon(item1) && WeaponTypeHelper.isLanceLikeWeapon(item2)) {
            return true;
        }
        return WeaponTypeHelper.isShieldLikeItem(item1) && WeaponTypeHelper.isShieldLikeItem(item2);
    }

    private static boolean hasAttackDamageAttribute(ItemStack itemStack) {
        try {
            Multimap attributes = itemStack.m_41638_(EquipmentSlot.MAINHAND);
            return attributes.containsKey((Object)Attributes.f_22281_);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isToolLikeItem(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof DiggerItem) {
            return true;
        }
        return itemStack.m_204117_(ItemTags.f_271360_) || itemStack.m_204117_(ItemTags.f_271138_) || itemStack.m_204117_(ItemTags.f_271298_);
    }
}

