/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.ui.MemberDisplayListWidget;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;

@Environment(value=EnvType.CLIENT)
public class MemberDisplayListEntry
extends class_4265.class_4266<MemberDisplayListEntry> {
    private final String playerName;
    private final UUID playerUUID;
    private final TeamMembersResponsePacket.Member.Role role;
    private final long joinTime;
    private final MemberDisplayListWidget parent;
    private final List<class_364> children = new ArrayList<class_364>();
    private final class_310 minecraft;
    private static final class_2960 PLAYER_ICON = new class_2960("hundred_years_war", "textures/gui/player.png");
    private static final int ICON_SIZE = 16;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public MemberDisplayListEntry(String playerName, UUID playerUUID, TeamMembersResponsePacket.Member.Role role, long joinTime, MemberDisplayListWidget parent) {
        this.playerName = playerName;
        this.playerUUID = playerUUID;
        this.role = role;
        this.joinTime = joinTime;
        this.parent = parent;
        this.minecraft = class_310.method_1551();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public TeamMembersResponsePacket.Member.Role getRole() {
        return this.role;
    }

    public long getJoinTime() {
        return this.joinTime;
    }

    public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
        int nameColor;
        String currentPlayerName = class_310.method_1551().field_1724.method_5477().getString();
        boolean isSelf = this.playerName.equals(currentPlayerName);
        String roleSymbol = "";
        switch (this.role) {
            case OWNER: {
                nameColor = -22016;
                roleSymbol = " \u2605";
                break;
            }
            case ADMIN: {
                nameColor = -11162881;
                roleSymbol = " \u2699";
                break;
            }
            default: {
                nameColor = -1;
            }
        }
        Object displayName = this.playerName;
        if (isSelf) {
            displayName = "\u00a7l" + (String)displayName;
            guiGraphics.method_25294(left + 2, top, left + width - 2, top + height, 503381760);
        }
        guiGraphics.method_25303(this.minecraft.field_1772, (String)displayName + roleSymbol, left + 10, top + 4, nameColor);
        Object roleText = switch (this.role) {
            case TeamMembersResponsePacket.Member.Role.OWNER -> this.minecraft.field_1772.method_1726() ? class_2561.method_43471((String)"ui.hundred_years_war.team_owner").getString() : "(" + class_2561.method_43471((String)"ui.hundred_years_war.team_owner").getString() + ")";
            case TeamMembersResponsePacket.Member.Role.ADMIN -> this.minecraft.field_1772.method_1726() ? class_2561.method_43471((String)"ui.hundred_years_war.team_admin").getString() : "(" + class_2561.method_43471((String)"ui.hundred_years_war.team_admin").getString() + ")";
            default -> this.minecraft.field_1772.method_1726() ? class_2561.method_43471((String)"ui.hundred_years_war.team_member").getString() : "(" + class_2561.method_43471((String)"ui.hundred_years_war.team_member").getString() + ")";
        };
        int roleColor = -5592406;
        guiGraphics.method_25303(this.minecraft.field_1772, (String)roleText, left + width - this.minecraft.field_1772.method_1727((String)roleText) - 10, top + 4, roleColor);
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    @NotNull
    public List<? extends class_6379> method_37025() {
        return this.children.stream().filter(child -> child instanceof class_6379).map(child -> (class_6379)child).collect(Collectors.toList());
    }
}

