/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.MemberListWidget;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;

@Environment(value=EnvType.CLIENT)
public class MemberListEntry
extends class_4265.class_4266<MemberListEntry> {
    private final String memberName;
    private final MemberListWidget parent;
    private final List<class_364> children = new ArrayList<class_364>();
    private final class_310 minecraft;
    private CustomButton removeButton;
    private CustomButton roleButton;
    private static final class_2960 PERSONAL_ICON = new class_2960("hundred_years_war", "textures/gui/personal.png");
    private static final class_2960 ADMIN_ICON = new class_2960("hundred_years_war", "textures/gui/team.png");
    private static final class_2960 OWNER_ICON = new class_2960("hundred_years_war", "textures/gui/team.png");
    private static final int ICON_SIZE = 16;
    private MemberRole currentRole;
    private MemberRole originalRole;
    private UUID memberUUID;
    private Consumer<UUID> removeCallback;
    private BiConsumer<UUID, MemberRole> roleChangeCallback;
    private boolean isSelf = false;
    private boolean hasChanged = false;

    public MemberListEntry(String memberName, MemberListWidget parent) {
        this.memberName = memberName;
        this.parent = parent;
        this.minecraft = class_310.method_1551();
        this.currentRole = MemberRole.MEMBER;
        this.originalRole = MemberRole.MEMBER;
        this.roleButton = new CustomButton(0, 0, 60, 20, (class_2561)class_2561.method_43471((String)this.currentRole.getTranslationKey()).method_27694(style -> style.method_36139(this.currentRole.getColor())), button -> this.onRoleToggle());
        this.children.add(this.roleButton);
        this.removeButton = new CustomButton(0, 0, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.remove"), button -> this.onRemoveClick());
        this.children.add(this.removeButton);
        this.removeButton.setColor(-5636096, -3407872, -11206656);
    }

    public static MemberListEntry create(String memberName, UUID memberUUID, boolean isAdmin, boolean isOwner, boolean isSelf, MemberListWidget parent, Consumer<UUID> removeCallback) {
        return MemberListEntry.create(memberName, memberUUID, isAdmin, isOwner, isSelf, parent, removeCallback, null);
    }

    public static MemberListEntry create(String memberName, UUID memberUUID, boolean isAdmin, boolean isOwner, boolean isSelf, MemberListWidget parent, Consumer<UUID> removeCallback, BiConsumer<UUID, MemberRole> roleChangeCallback) {
        MemberListEntry entry = new MemberListEntry(memberName, parent);
        entry.memberUUID = memberUUID;
        entry.isSelf = isSelf;
        entry.removeCallback = removeCallback;
        entry.roleChangeCallback = roleChangeCallback;
        entry.currentRole = isOwner ? MemberRole.OWNER : (isAdmin ? MemberRole.ADMIN : MemberRole.MEMBER);
        entry.originalRole = entry.currentRole;
        entry.updateRoleButton();
        if (roleChangeCallback == null) {
            entry.roleButton.field_22763 = false;
        }
        if (isSelf || isOwner) {
            entry.removeButton.field_22763 = false;
        }
        return entry;
    }

    protected void onRemoveClick() {
        if (this.removeCallback != null && this.memberUUID != null) {
            this.removeCallback.accept(this.memberUUID);
        }
    }

    protected void onRoleToggle() {
        if (this.roleChangeCallback != null) {
            this.currentRole = this.currentRole.next();
            this.updateRoleButton();
            this.hasChanged = !this.currentRole.equals((Object)this.originalRole);
            this.roleChangeCallback.accept(this.memberUUID, this.currentRole);
        }
    }

    private void updateRoleButton() {
        this.roleButton.method_25355((class_2561)class_2561.method_43471((String)this.currentRole.getTranslationKey()).method_27694(style -> style.method_36139(this.currentRole.getColor())));
    }

    public MemberRole getCurrentRole() {
        return this.currentRole;
    }

    public MemberRole getOriginalRole() {
        return this.originalRole;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public UUID getMemberUUID() {
        return this.memberUUID;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
        int nameColor = this.currentRole.getColor();
        guiGraphics.method_25303(this.minecraft.field_1772, this.memberName + (this.currentRole == MemberRole.OWNER ? " \u2605" : (this.currentRole == MemberRole.ADMIN ? " \u2699" : "")), left + 5, top + 6, nameColor);
        int buttonY = top + 2;
        int removeButtonWidth = 50;
        int roleButtonWidth = 50;
        int roleButtonLeft = left + width - removeButtonWidth - roleButtonWidth - 10;
        int removeButtonLeft = left + width - removeButtonWidth - 5;
        this.roleButton.method_46421(roleButtonLeft);
        this.roleButton.method_46419(buttonY);
        this.roleButton.method_25358(roleButtonWidth);
        this.removeButton.method_46421(removeButtonLeft);
        this.removeButton.method_46419(buttonY);
        this.removeButton.method_25358(removeButtonWidth);
        this.roleButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.removeButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 listener : new ArrayList<class_364>(this.children)) {
            if (!listener.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    @NotNull
    public List<? extends class_6379> method_37025() {
        ArrayList<class_6379> result = new ArrayList<class_6379>();
        for (class_364 child : this.children) {
            if (!(child instanceof class_6379)) continue;
            result.add((class_6379)child);
        }
        return result;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum MemberRole {
        MEMBER(0, "ui.hundred_years_war.team_member", 0xFFFFFF),
        ADMIN(1, "ui.hundred_years_war.team_admin", -11162881),
        OWNER(2, "ui.hundred_years_war.team_owner", -22016);

        private final int id;
        private final String translationKey;
        private final int color;

        private MemberRole(int id, String translationKey, int color) {
            this.id = id;
            this.translationKey = translationKey;
            this.color = color;
        }

        public MemberRole next() {
            MemberRole[] values = MemberRole.values();
            return values[(this.id + 1) % values.length];
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public int getColor() {
            return this.color;
        }

        public static MemberRole fromServerRole(TeamMembersResponsePacket.Member.Role role) {
            return switch (role) {
                default -> throw new IncompatibleClassChangeError();
                case TeamMembersResponsePacket.Member.Role.OWNER -> OWNER;
                case TeamMembersResponsePacket.Member.Role.ADMIN -> ADMIN;
                case TeamMembersResponsePacket.Member.Role.MEMBER -> MEMBER;
            };
        }

        public TeamMembersResponsePacket.Member.Role toServerRole() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case OWNER -> TeamMembersResponsePacket.Member.Role.OWNER;
                case ADMIN -> TeamMembersResponsePacket.Member.Role.ADMIN;
                case MEMBER -> TeamMembersResponsePacket.Member.Role.MEMBER;
            };
        }
    }
}

