/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;

@Environment(value=EnvType.CLIENT)
public class SelectionHUD {
    private static final int MARGIN_LEFT = 5;
    private static final int MARGIN_TOP = 5;
    private static final int LINE_HEIGHT = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(class_332 guiGraphics) {
        ArrayList<class_1297> safeCopy;
        List<class_1297> selectedEntitiesWithDuplicates;
        if (!Freecam.isEnabled()) {
            return;
        }
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        List<class_1297> list = selectedEntitiesWithDuplicates = selectionHandler.getSelectedEntities();
        synchronized (list) {
            safeCopy = new ArrayList<class_1297>(selectedEntitiesWithDuplicates);
        }
        ArrayList<class_1297> selectedEntities = new ArrayList<class_1297>(new HashSet<class_1297>(safeCopy));
        if (selectedEntities.isEmpty()) {
            return;
        }
        if (selectedEntities.size() == 1) {
            SelectionHUD.renderSingleEntityInfo(guiGraphics, (class_1297)selectedEntities.get(0));
        } else {
            SelectionHUD.renderMultipleEntitiesInfo(guiGraphics, selectedEntities);
        }
    }

    private static class_1297 getEffectiveEntity(class_1297 entity) {
        if (entity instanceof class_1496 && !entity.method_5685().isEmpty()) {
            return (class_1297)entity.method_5685().get(0);
        }
        return entity;
    }

    private static void renderSingleEntityInfo(class_332 guiGraphics, class_1297 entity) {
        if (entity instanceof MultiSeatVehicle) {
            MultiSeatVehicle multiSeatVehicle = (MultiSeatVehicle)entity;
            SelectionHUD.renderVehiclePassengerInfo(guiGraphics, multiSeatVehicle, entity);
            return;
        }
        class_1297 effectiveEntity = SelectionHUD.getEffectiveEntity(entity);
        if (!(effectiveEntity instanceof BaseCombatEntity)) {
            return;
        }
        int y = 5;
        String entityType = effectiveEntity.method_5864().method_5882();
        class_5250 typeText = class_2561.method_43471((String)"hud.hundred_years_war.unit_type").method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)entityType));
        guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)typeText, 5, y, 0xFFFFFF);
        y += 10;
        if (effectiveEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)effectiveEntity;
            class_5250 healthText = class_2561.method_43470((String)String.format("%.1f/%.1f", Float.valueOf(livingEntity.method_6032()), Float.valueOf(livingEntity.method_6063())));
            guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)healthText, 5, y, 0xFFFFFF);
            y += 10;
            if (effectiveEntity instanceof BaseCombatEntity) {
                BaseCombatEntity combatEntity = (BaseCombatEntity)effectiveEntity;
                if (!(effectiveEntity instanceof IPuppet)) {
                    class_5250 levelText = class_2561.method_43471((String)"hud.hundred_years_war.level").method_27693(": ").method_27693(String.valueOf(combatEntity.getLevel()));
                    guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)levelText, 5, y, 0xFFFFFF);
                    class_5250 killsText = class_2561.method_43471((String)"hud.hundred_years_war.kills").method_27693(": ").method_27693(String.valueOf(combatEntity.getKillCount()));
                    guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)killsText, 5, y += 10, 0xFFFFFF);
                }
            }
        }
    }

    private static void renderMultipleEntitiesInfo(class_332 guiGraphics, List<class_1297> entities) {
        int y = 5;
        HashMap<String, Integer> entityCounts = new HashMap<String, Integer>();
        int totalEffectiveUnits = 0;
        for (class_1297 entity : entities) {
            class_1297 effectiveEntity = SelectionHUD.getEffectiveEntity(entity);
            if (!(effectiveEntity instanceof BaseCombatEntity)) continue;
            String entityType = effectiveEntity.method_5864().method_5882();
            entityCounts.merge(entityType, 1, Integer::sum);
            ++totalEffectiveUnits;
        }
        class_5250 totalText = class_2561.method_43471((String)"hud.hundred_years_war.selected_units_count").method_27693(": ").method_27693(String.valueOf(totalEffectiveUnits));
        guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)totalText, 5, y, 0xFFFFFF);
        y += 10;
        for (Map.Entry entry : entityCounts.entrySet()) {
            class_5250 unitText = class_2561.method_43471((String)((String)entry.getKey())).method_27693(": ").method_27693(String.valueOf(entry.getValue()));
            guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)unitText, 5, y, 0xFFFFFF);
            y += 10;
        }
    }

    private static void renderVehiclePassengerInfo(class_332 guiGraphics, MultiSeatVehicle multiSeatVehicle, class_1297 vehicleEntity) {
        int y = 5;
        String vehicleType = vehicleEntity.method_5864().method_5882();
        class_5250 typeText = class_2561.method_43471((String)"hud.hundred_years_war.unit_type").method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)vehicleType));
        guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)typeText, 5, y, 0xFFFFFF);
        y += 10;
        if (vehicleEntity instanceof class_1309) {
            class_1309 livingVehicle = (class_1309)vehicleEntity;
            class_5250 healthText = class_2561.method_43470((String)String.format("%.1f/%.1f", Float.valueOf(livingVehicle.method_6032()), Float.valueOf(livingVehicle.method_6063())));
            guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)healthText, 5, y, 0xFFFFFF);
            y += 10;
        }
        int currentPassengers = multiSeatVehicle.getPassengerCount();
        int maxPassengers = multiSeatVehicle.getMaxPassengers();
        class_5250 passengerCountText = class_2561.method_43471((String)"hud.hundred_years_war.passenger_count").method_27693(": ").method_27693(String.valueOf(currentPassengers)).method_27693("/").method_27693(String.valueOf(maxPassengers));
        guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)passengerCountText, 5, y, 0xFFFFFF);
        y += 10;
        ArrayList passengers = new ArrayList(vehicleEntity.method_5685());
        if (!passengers.isEmpty()) {
            HashMap<String, Integer> passengerCounts = new HashMap<String, Integer>();
            int totalPassengers = 0;
            for (class_1297 class_12972 : passengers) {
                class_1297 effectivePassenger = SelectionHUD.getEffectiveEntity(class_12972);
                if (!(effectivePassenger instanceof BaseCombatEntity)) continue;
                String passengerType = effectivePassenger.method_5864().method_5882();
                passengerCounts.merge(passengerType, 1, Integer::sum);
                ++totalPassengers;
            }
            for (Map.Entry entry : passengerCounts.entrySet()) {
                class_5250 passengerText = class_2561.method_43471((String)((String)entry.getKey())).method_27693(": ").method_27693(String.valueOf(entry.getValue()));
                guiGraphics.method_27535(class_310.method_1551().field_1772, (class_2561)passengerText, 5, y, 0xFFFFFF);
                y += 10;
            }
        }
    }
}

