/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.CustomConfirmScreen;
import ydmsama.hundred_years_war.client.freecam.ui.TeamRelationListEntry;
import ydmsama.hundred_years_war.client.freecam.ui.TeamRelationListWidget;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationUpdatePacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Environment(value=EnvType.CLIENT)
public class TeamRelationUI
extends class_437 {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private static final int SEARCH_BOX_HEIGHT = 20;
    private static final int PLAYER_ITEM_HEIGHT = 24;
    private static final int PLAYER_LIST_HEIGHT = 150;
    private int leftPos;
    private int topPos;
    private class_342 searchBox;
    private TeamRelationListWidget playerListWidget;
    private String searchText = "";
    private List<PlayerRelationInfo> playerInfoList = new ArrayList<PlayerRelationInfo>();
    private List<PlayerRelationInfo> filteredPlayerInfoList = new ArrayList<PlayerRelationInfo>();
    private CustomButton applyButton;
    private boolean hasChanges = false;
    private final UUID teamUUID;
    private final String teamName;
    private final class_437 parentScreen;

    public TeamRelationUI(class_437 parentScreen, UUID teamUUID, String teamName) {
        super((class_2561)class_2561.method_43471((String)"ui.hundred_years_war.team_relation_ui"));
        this.parentScreen = parentScreen;
        this.teamUUID = teamUUID;
        this.teamName = teamName;
        ClientPacketHandler.requestTeamRelationData(teamUUID);
    }

    public void onTeamRelationDataUpdate(TeamRelationResponsePacket packet) {
        Object info;
        this.playerInfoList.clear();
        for (Map.Entry<UUID, TeamRelationResponsePacket.RelationInfo> entry : packet.getRelationInfoMap().entrySet()) {
            info = entry.getValue();
            PlayerRelationInfo playerInfo = new PlayerRelationInfo(entry.getKey(), ((TeamRelationResponsePacket.RelationInfo)info).getPlayerName(), ((TeamRelationResponsePacket.RelationInfo)info).getTeamRelation(), ((TeamRelationResponsePacket.RelationInfo)info).getTheirRelation(), TeamRelationListEntry.EntryType.PERSONAL);
            playerInfo.resetChanged();
            this.playerInfoList.add(playerInfo);
        }
        for (Map.Entry<UUID, Object> entry : packet.getTeamInfoMap().entrySet()) {
            info = (TeamRelationResponsePacket.TeamInfo)entry.getValue();
            RelationSystem.RelationType theirRelation = ((TeamRelationResponsePacket.TeamInfo)info).getTheirRelation() != null ? ((TeamRelationResponsePacket.TeamInfo)info).getTheirRelation() : RelationSystem.RelationType.NEUTRAL;
            PlayerRelationInfo teamInfo = new PlayerRelationInfo(entry.getKey(), ((TeamRelationResponsePacket.TeamInfo)info).getTeamName(), ((TeamRelationResponsePacket.TeamInfo)info).getTeamRelation(), theirRelation, TeamRelationListEntry.EntryType.TEAM);
            teamInfo.resetChanged();
            this.playerInfoList.add(teamInfo);
        }
        this.updateFilteredPlayerList();
        if (this.playerListWidget != null) {
            this.updatePlayerList();
        }
        this.hasChanges = false;
        this.updateApplyButton();
        this.field_22787.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"message.hundred_years_war.team_relation_settings_updated"));
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - 240) / 2;
        this.topPos = (this.field_22790 - 250) / 2;
        this.searchBox = new class_342(this.field_22793, this.leftPos + 10, this.topPos + 20 + 15, 220, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(true);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1852(this.searchText);
        this.searchBox.method_1863(this::onSearchTextChanged);
        this.method_37063((class_364)this.searchBox);
        int playerListTop = this.topPos + 20 + 15 + 20 + 5;
        this.playerListWidget = new TeamRelationListWidget(this, this.field_22787, 220, 150, playerListTop, playerListTop + 150, 24);
        this.playerListWidget.method_25333(this.leftPos + 10);
        this.updateFilteredPlayerList();
        this.updatePlayerList();
        this.method_25429((class_364)this.playerListWidget);
        this.applyButton = new CustomButton(this.leftPos + 10, this.topPos + 250 - 20 - 10, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.apply"), button -> this.applyChanges());
        this.applyButton.field_22763 = true;
        this.method_37063(this.applyButton);
        this.method_37063(new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.back"), button -> this.method_25419()));
    }

    private void updateApplyButton() {
        if (this.applyButton != null) {
            this.applyButton.field_22763 = true;
        }
    }

    private void applyChanges() {
        TeamRelationUpdatePacket updatePacket = new TeamRelationUpdatePacket(this.teamUUID);
        for (PlayerRelationInfo info : this.playerInfoList) {
            if (!info.hasChanged()) continue;
            updatePacket.addRelationUpdate(info.getPlayerUUID(), info.getMyRelation());
        }
        ClientPacketHandler.sendTeamRelationUpdate(updatePacket);
        this.field_22787.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"message.hundred_years_war.applying_team_relation_settings"));
        this.field_22787.method_1507(this.parentScreen);
    }

    private void updateFilteredPlayerList() {
        Map<UUID, PlayerRelationInfo> teamInfoMap = new HashMap<UUID, PlayerRelationInfo>();
        HashMap<UUID, List> teamMembersMap = new HashMap<UUID, List>();
        List<PlayerRelationInfo> soloPlayers = new ArrayList<PlayerRelationInfo>();
        TeamRelationResponsePacket relationData = ClientPacketHandler.getLatestTeamRelationData();
        for (PlayerRelationInfo playerRelationInfo : this.playerInfoList) {
            if (playerRelationInfo.getEntryType() == TeamRelationListEntry.EntryType.TEAM) {
                teamInfoMap.put(playerRelationInfo.getPlayerUUID(), playerRelationInfo);
                teamMembersMap.computeIfAbsent(playerRelationInfo.getPlayerUUID(), k -> new ArrayList());
                continue;
            }
            boolean belongsToTeam = false;
            if (relationData != null) {
                for (Map.Entry<UUID, TeamRelationResponsePacket.TeamInfo> entry2 : relationData.getTeamInfoMap().entrySet()) {
                    UUID uUID = entry2.getKey();
                    TeamRelationResponsePacket.TeamInfo teamInfo = entry2.getValue();
                    if (!teamInfo.getMembers().containsKey(playerRelationInfo.getPlayerUUID())) continue;
                    teamMembersMap.computeIfAbsent(uUID, k -> new ArrayList()).add(playerRelationInfo);
                    belongsToTeam = true;
                    break;
                }
            }
            if (belongsToTeam) continue;
            soloPlayers.add(playerRelationInfo);
        }
        if (!this.searchText.isEmpty()) {
            String searchLower = this.searchText.toLowerCase();
            List list = soloPlayers.stream().filter(info -> info.getPlayerName().toLowerCase().contains(searchLower)).collect(Collectors.toList());
            HashSet<UUID> teamsWithMatchingMembers = new HashSet<UUID>();
            HashMap filteredTeamMembersMap = new HashMap();
            for (Map.Entry entry3 : teamMembersMap.entrySet()) {
                UUID teamUUID = (UUID)entry3.getKey();
                List members = (List)entry3.getValue();
                List filteredMembers = members.stream().filter(info -> info.getPlayerName().toLowerCase().contains(searchLower)).collect(Collectors.toList());
                if (filteredMembers.isEmpty()) continue;
                filteredTeamMembersMap.put(teamUUID, filteredMembers);
                teamsWithMatchingMembers.add(teamUUID);
            }
            Map<UUID, PlayerRelationInfo> map = teamInfoMap.entrySet().stream().filter(entry -> ((PlayerRelationInfo)entry.getValue()).getPlayerName().toLowerCase().contains(searchLower) || teamsWithMatchingMembers.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            soloPlayers = list;
            teamInfoMap = map;
            teamMembersMap = filteredTeamMembersMap;
        }
        this.filteredPlayerInfoList = new ArrayList<PlayerRelationInfo>();
        this.filteredPlayerInfoList.addAll(soloPlayers);
        for (Map.Entry entry4 : teamInfoMap.entrySet()) {
            UUID teamUUID = (UUID)entry4.getKey();
            PlayerRelationInfo teamInfo = (PlayerRelationInfo)entry4.getValue();
            this.filteredPlayerInfoList.add(teamInfo);
            if (!teamMembersMap.containsKey(teamUUID)) continue;
            this.filteredPlayerInfoList.addAll((Collection)teamMembersMap.get(teamUUID));
        }
    }

    private boolean isTeamMember(UUID playerUUID) {
        TeamRelationResponsePacket packet = ClientPacketHandler.getLatestTeamRelationData();
        if (packet != null && packet.getTeamUUID().equals(this.teamUUID)) {
            for (Map.Entry<UUID, TeamRelationResponsePacket.TeamInfo> entry : packet.getTeamInfoMap().entrySet()) {
                if (!entry.getValue().getMembers().containsKey(playerUUID)) continue;
                return true;
            }
        }
        return false;
    }

    private void updatePlayerList() {
        if (this.playerListWidget != null) {
            this.playerListWidget.clearAllEntries();
            HashMap<UUID, Integer> teamIndexMap = new HashMap<UUID, Integer>();
            HashMap teamMembersMap = new HashMap();
            for (int i = 0; i < this.filteredPlayerInfoList.size(); ++i) {
                PlayerRelationInfo info = this.filteredPlayerInfoList.get(i);
                TeamRelationListEntry teamRelationListEntry = TeamRelationListEntry.createForRelationUI(info.getPlayerName(), info.getPlayerUUID(), info.getMyRelation(), info.getTheirRelation(), this.playerListWidget, this::onRelationChanged, info.getEntryType());
                int entryIndex = this.playerListWidget.addEntry(teamRelationListEntry);
                if (info.getEntryType() != TeamRelationListEntry.EntryType.TEAM) continue;
                teamIndexMap.put(info.getPlayerUUID(), entryIndex);
                teamMembersMap.put(info.getPlayerUUID(), new ArrayList());
            }
            TeamRelationResponsePacket relationData = ClientPacketHandler.getLatestTeamRelationData();
            if (relationData != null) {
                block1: for (int i = 0; i < this.filteredPlayerInfoList.size(); ++i) {
                    PlayerRelationInfo playerRelationInfo = this.filteredPlayerInfoList.get(i);
                    if (playerRelationInfo.getEntryType() != TeamRelationListEntry.EntryType.PERSONAL) continue;
                    for (Map.Entry<UUID, TeamRelationResponsePacket.TeamInfo> teamEntry : relationData.getTeamInfoMap().entrySet()) {
                        UUID teamUUID = teamEntry.getKey();
                        TeamRelationResponsePacket.TeamInfo teamInfo = teamEntry.getValue();
                        if (!teamInfo.getMembers().containsKey(playerRelationInfo.getPlayerUUID())) continue;
                        if (!teamIndexMap.containsKey(teamUUID)) continue block1;
                        ((List)teamMembersMap.get(teamUUID)).add(i);
                        continue block1;
                    }
                }
                for (Map.Entry entry : teamMembersMap.entrySet()) {
                    UUID teamUUID = (UUID)entry.getKey();
                    List memberIndices = (List)entry.getValue();
                    this.playerListWidget.setTeamMembers(teamUUID, memberIndices);
                }
            }
        }
    }

    private void onRelationChanged(UUID playerUUID, RelationSystem.RelationType newRelation) {
        for (PlayerRelationInfo info : this.playerInfoList) {
            TeamRelationResponsePacket relationData;
            if (!info.getPlayerUUID().equals(playerUUID)) continue;
            info.setMyRelation(newRelation);
            if (info.getEntryType() != TeamRelationListEntry.EntryType.TEAM || (relationData = ClientPacketHandler.getLatestTeamRelationData()) == null || !relationData.getTeamInfoMap().containsKey(playerUUID)) break;
            TeamRelationResponsePacket.TeamInfo teamInfo = relationData.getTeamInfoMap().get(playerUUID);
            block1: for (UUID memberUUID : teamInfo.getMembers().keySet()) {
                for (PlayerRelationInfo memberInfo : this.playerInfoList) {
                    if (!memberInfo.getPlayerUUID().equals(memberUUID)) continue;
                    memberInfo.setMyRelation(newRelation);
                    this.updateMemberEntryRelation(memberUUID, newRelation);
                    continue block1;
                }
            }
        }
        this.hasChanges = true;
        this.updateApplyButton();
    }

    private void updateMemberEntryRelation(UUID memberUUID, RelationSystem.RelationType newRelation) {
        for (TeamRelationListEntry entry : this.playerListWidget.method_25396()) {
            if (!entry.getPlayerUUID().equals(memberUUID)) continue;
            entry.setRelation(TeamRelationListEntry.convertFromSystemRelation(newRelation));
            break;
        }
    }

    private void onSearchTextChanged(String text) {
        this.searchText = text;
        this.updateFilteredPlayerList();
        this.updatePlayerList();
        if (this.playerListWidget != null) {
            this.playerListWidget.method_25307(0.0);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.teamName), this.leftPos + 120, this.topPos + 10 + 15, 0xFFFFFF);
        guiGraphics.method_25303(this.field_22793, class_2561.method_43471((String)"ui.hundred_years_war.search").getString().split("\\.\\.\\.")[0], this.leftPos + 10, this.topPos + 20 + 5, 0xFFFFFF);
        if (this.playerListWidget != null) {
            this.playerListWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.filteredPlayerInfoList.isEmpty()) {
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.no_members_found"), this.leftPos + 120, this.topPos + 20 + 60, 0xBBBBBB);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.playerListWidget != null && this.playerListWidget.method_25405(mouseX, mouseY) && this.playerListWidget.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.playerListWidget.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.playerListWidget != null && this.playerListWidget.method_25405(mouseX, mouseY)) {
            return this.playerListWidget.method_25401(mouseX, mouseY, delta);
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.method_25370() && this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.searchBox.method_25370() && this.searchBox.method_25400(codePoint, modifiers)) {
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public void method_25419() {
        if (this.hasChanges) {
            class_310.method_1551().method_1507((class_437)new CustomConfirmScreen(this, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.confirm"), (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.unsaved_changes_confirm"), this::closeConfirmed));
        } else {
            this.closeConfirmed(true);
        }
    }

    private void closeConfirmed(boolean confirmed) {
        if (confirmed) {
            class_310.method_1551().method_1507(this.parentScreen);
        } else {
            class_310.method_1551().method_1507((class_437)this);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PlayerRelationInfo {
        private final UUID playerUUID;
        private final String playerName;
        private RelationSystem.RelationType myRelation;
        private final RelationSystem.RelationType theirRelation;
        private boolean hasChanged = false;
        private final TeamRelationListEntry.EntryType entryType;

        public PlayerRelationInfo(UUID playerUUID, String playerName, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation) {
            this(playerUUID, playerName, myRelation, theirRelation, TeamRelationListEntry.EntryType.PERSONAL);
        }

        public PlayerRelationInfo(UUID playerUUID, String playerName, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation, TeamRelationListEntry.EntryType entryType) {
            this.playerUUID = playerUUID;
            this.playerName = playerName;
            this.myRelation = myRelation;
            this.theirRelation = theirRelation;
            this.entryType = entryType;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public RelationSystem.RelationType getMyRelation() {
            return this.myRelation;
        }

        public void setMyRelation(RelationSystem.RelationType relation) {
            if (this.myRelation != relation) {
                this.myRelation = relation;
                this.hasChanged = true;
            }
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }

        public void resetChanged() {
            this.hasChanged = false;
        }

        public TeamRelationListEntry.EntryType getEntryType() {
            return this.entryType;
        }
    }
}

