/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.manual;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualImage;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualPage;

@Environment(value=EnvType.CLIENT)
public class ManualContentParser {
    private static final Pattern IMAGE_PATTERN = Pattern.compile("\\[img\\|u=([^|]+)(?:\\|w=(\\d+))?\\|dx=(-?\\d+)\\|dy=(-?\\d+)\\]");
    private static final int DEFAULT_IMAGE_WIDTH = 64;
    private static final Pattern FORMAT_CODE_PATTERN = Pattern.compile("\u00a7[0-9a-fk-or]");

    public static List<ManualPage> parseContent(class_2561 content, int width, class_327 font, int maxLinesPerPage, int lineHeight) {
        ArrayList<ManualPage> pages = new ArrayList<ManualPage>();
        ArrayList<class_5481> allLines = new ArrayList<class_5481>();
        HashMap<Integer, List<ManualImage>> imageMap = new HashMap<Integer, List<ManualImage>>();
        String fullText = content.getString();
        Matcher matcher = IMAGE_PATTERN.matcher(fullText);
        int lastMatchEnd = 0;
        while (matcher.find()) {
            String textBefore = fullText.substring(lastMatchEnd, matcher.start());
            ManualContentParser.addTextToLines(textBefore, width, font, allLines);
            String textureName = matcher.group(1);
            int imgWidth = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : width;
            int dx = Integer.parseInt(matcher.group(3));
            int dy = Integer.parseInt(matcher.group(4));
            ManualImage image = ManualImage.createWithLineHeight(textureName, lineHeight, 1, dx, dy, imgWidth);
            int calculatedLines = image.getCalculatedLines(lineHeight);
            int currentLineInPage = allLines.size() % maxLinesPerPage;
            if (currentLineInPage > 0 && currentLineInPage + calculatedLines > maxLinesPerPage) {
                while (allLines.size() % maxLinesPerPage != 0) {
                    allLines.add(class_5481.field_26385);
                }
            }
            int imageStartLine = allLines.size();
            imageMap.computeIfAbsent(imageStartLine, k -> new ArrayList()).add(image);
            for (int i = 0; i < calculatedLines; ++i) {
                allLines.add(class_5481.field_26385);
            }
            lastMatchEnd = matcher.end();
        }
        String remainingText = fullText.substring(lastMatchEnd);
        ManualContentParser.addTextToLines(remainingText, width, font, allLines);
        int totalLines = allLines.size();
        if (totalLines == 0) {
            pages.add(new ManualPage(new ArrayList<class_5481>(), new ArrayList<ManualImage>(), lineHeight));
            return pages;
        }
        int pageCount = (int)Math.ceil((double)totalLines / (double)maxLinesPerPage);
        if (pageCount == 0) {
            pageCount = 1;
        }
        for (int i = 0; i < pageCount; ++i) {
            int absoluteLineIndex;
            int startLineOfPage = i * maxLinesPerPage;
            int endLineOfPage = Math.min(startLineOfPage + maxLinesPerPage, totalLines);
            List pageLinesSource = allLines.subList(startLineOfPage, endLineOfPage);
            ArrayList<class_5481> finalPageLines = new ArrayList<class_5481>(pageLinesSource);
            int trimmedLines = 0;
            while (!finalPageLines.isEmpty() && finalPageLines.get(0) == class_5481.field_26385 && !ManualContentParser.isLineImagePlaceholder(absoluteLineIndex = startLineOfPage + trimmedLines, imageMap, lineHeight)) {
                finalPageLines.remove(0);
                ++trimmedLines;
            }
            ArrayList<ManualImage> pageImages = new ArrayList<ManualImage>();
            for (Map.Entry entry : imageMap.entrySet()) {
                int imageLineInPage;
                int finalImageLine;
                int imageAbsoluteStartLine = (Integer)entry.getKey();
                if (imageAbsoluteStartLine < startLineOfPage || imageAbsoluteStartLine >= endLineOfPage || (finalImageLine = (imageLineInPage = imageAbsoluteStartLine - startLineOfPage) - trimmedLines) < 0) continue;
                for (ManualImage templateImage : (List)entry.getValue()) {
                    int finalY = finalImageLine * lineHeight + templateImage.getOffsetY();
                    ManualImage finalImage = ManualImage.createWithLineHeight(templateImage.getTextureName(), lineHeight, templateImage.getCalculatedLines(lineHeight), templateImage.getOffsetX(), finalY, templateImage.getWidth());
                    pageImages.add(finalImage);
                }
            }
            ManualPage page = new ManualPage(finalPageLines, pageImages, lineHeight);
            pages.add(page);
        }
        return pages;
    }

    private static boolean isLineImagePlaceholder(int lineIndex, Map<Integer, List<ManualImage>> imageMap, int lineHeight) {
        for (Map.Entry<Integer, List<ManualImage>> entry : imageMap.entrySet()) {
            ManualImage image;
            int calculatedLines;
            int imageStartLine = entry.getKey();
            if (lineIndex < imageStartLine || entry.getValue().isEmpty() || lineIndex >= imageStartLine + (calculatedLines = (image = entry.getValue().get(0)).getCalculatedLines(lineHeight))) continue;
            return true;
        }
        return false;
    }

    private static void addTextToLines(String text, int width, class_327 font, List<class_5481> lines) {
        if (text != null && !text.isEmpty()) {
            lines.addAll(font.method_1728((class_5348)class_2561.method_43470((String)text), width));
        }
    }

    private static List<ImageEntry> findImages(String text) {
        ArrayList<ImageEntry> images = new ArrayList<ImageEntry>();
        Matcher matcher = IMAGE_PATTERN.matcher(text);
        while (matcher.find()) {
            String textureName = matcher.group(1);
            int width = matcher.group(2) != null ? Integer.parseInt(matcher.group(2)) : 0;
            int offsetX = Integer.parseInt(matcher.group(3));
            int offsetY = Integer.parseInt(matcher.group(4));
            images.add(new ImageEntry(textureName, width, offsetX, offsetY, matcher.start(), matcher.end()));
        }
        return images;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ImageEntry {
        String textureName;
        int width;
        int calculatedLines;
        int offsetX;
        int offsetY;
        int startIndex;
        int endIndex;
        int lineNumber;
        int pageIndex;
        int offsetLineInPage;
        boolean wasMovedToNextPage;
        int pageBreakLines;

        ImageEntry(String textureName, int width, int offsetX, int offsetY, int startIndex, int endIndex) {
            this.textureName = textureName;
            this.width = width;
            this.calculatedLines = 1;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.lineNumber = -1;
            this.pageIndex = 0;
            this.offsetLineInPage = 0;
            this.wasMovedToNextPage = false;
            this.pageBreakLines = 0;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class FormatState {
        private Set<Character> activeFormats = new HashSet<Character>();
        private Character currentColor = null;

        private FormatState() {
        }

        public void applyFormatCode(char code) {
            if (code >= '0' && code <= '9' || code >= 'a' && code <= 'f') {
                this.activeFormats.clear();
                this.currentColor = Character.valueOf(code);
            } else if (code == 'r') {
                this.activeFormats.clear();
                this.currentColor = null;
            } else {
                this.activeFormats.add(Character.valueOf(code));
            }
        }

        public String getFormatPrefix() {
            StringBuilder prefix = new StringBuilder();
            if (this.currentColor != null) {
                prefix.append("\u00a7").append(this.currentColor);
            }
            for (char format : this.activeFormats) {
                prefix.append("\u00a7").append(format);
            }
            return prefix.toString();
        }

        public FormatState copy() {
            FormatState copy = new FormatState();
            copy.activeFormats = new HashSet<Character>(this.activeFormats);
            copy.currentColor = this.currentColor;
            return copy;
        }

        public boolean hasActiveFormats() {
            return this.currentColor != null || !this.activeFormats.isEmpty();
        }
    }
}

