/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.manual;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ManualImage {
    private static final Map<String, int[]> TEXTURE_DIMENSIONS_CACHE = new HashMap<String, int[]>();
    private final String textureName;
    private final class_2960 texture;
    private final int width;
    private final int height;
    private final int offsetX;
    private final int offsetY;

    private ManualImage(String textureName, int width, int height, int offsetX, int offsetY) {
        this.textureName = textureName;
        this.texture = new class_2960("hundred_years_war", "textures/gui/" + textureName);
        this.width = width;
        this.height = height;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public static int[] getTextureDimensions(String textureName) {
        if (TEXTURE_DIMENSIONS_CACHE.containsKey(textureName)) {
            return TEXTURE_DIMENSIONS_CACHE.get(textureName);
        }
        class_2960 textureLocation = new class_2960("hundred_years_war", "textures/gui/" + textureName);
        int[] dimensions = new int[]{64, 64};
        try {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            try (InputStream resource = resourceManager.open(textureLocation);){
                class_1011 nativeImage = class_1011.method_4309((InputStream)resource);
                dimensions[0] = nativeImage.method_4307();
                dimensions[1] = nativeImage.method_4323();
                nativeImage.close();
            }
        }
        catch (IOException e) {
            System.err.println("\u65e0\u6cd5\u52a0\u8f7d\u7eb9\u7406: " + textureName + ", \u9519\u8bef: " + e.getMessage());
        }
        TEXTURE_DIMENSIONS_CACHE.put(textureName, dimensions);
        return dimensions;
    }

    public static ManualImage createWithLineHeight(String textureName, int lineHeight, int lines, int offsetX, int offsetY, int contentWidth) {
        int targetHeight;
        int targetWidth;
        int[] dimensions = ManualImage.getTextureDimensions(textureName);
        int texWidth = dimensions[0];
        int texHeight = dimensions[1];
        if (contentWidth > 0) {
            targetWidth = contentWidth;
            targetHeight = Math.round((float)targetWidth * ((float)texHeight / (float)texWidth));
        } else {
            targetHeight = lineHeight * lines;
            targetWidth = Math.round((float)texWidth * ((float)targetHeight / (float)texHeight));
        }
        return new ManualImage(textureName, targetWidth, targetHeight, offsetX, offsetY);
    }

    public static ManualImage createWithLineHeight(String textureName, int lineHeight, int lines, int offsetX, int offsetY) {
        return ManualImage.createWithLineHeight(textureName, lineHeight, lines, offsetX, offsetY, 0);
    }

    public void render(class_332 guiGraphics, int x, int y) {
        int renderX = x + this.offsetX;
        int renderY = y + this.offsetY;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25290(this.texture, renderX, renderY, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        RenderSystem.disableBlend();
    }

    public boolean isHovered(int mouseX, int mouseY, int screenX, int screenY) {
        int imgX = screenX + this.offsetX;
        int imgY = screenY + this.offsetY;
        return mouseX >= imgX && mouseX <= imgX + this.width && mouseY >= imgY && mouseY <= imgY + this.height;
    }

    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY, int screenX, int screenY) {
    }

    public String getTextureName() {
        return this.textureName;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getCalculatedLines(int lineHeight) {
        if (lineHeight <= 0) {
            return 1;
        }
        return (int)Math.ceil((double)this.height / (double)lineHeight);
    }
}

