/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.manual;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.ui.manual.TableOfContentsWidget;

@Environment(value=EnvType.CLIENT)
public class ManualTableOfContentsEntry
extends class_4265.class_4266<ManualTableOfContentsEntry> {
    private final class_2561 title;
    private final TableOfContentsWidget parent;
    private final List<class_364> children = new ArrayList<class_364>();
    private final class_310 minecraft;
    private final Runnable onClick;
    private boolean isHovered = false;
    private int scrollOffset = 0;
    private long lastScrollTime = 0L;
    private static final int SCROLL_INTERVAL_MS = 30;
    private static final int SCROLL_PADDING = 10;

    public ManualTableOfContentsEntry(class_2561 title, TableOfContentsWidget parent, Runnable onClick) {
        this.title = title;
        this.parent = parent;
        this.onClick = onClick;
        this.minecraft = class_310.method_1551();
    }

    public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
        this.isHovered = isHovered;
        int textColor = isHovered ? 0xFFFFFF : 0xDDDDDD;
        int availableWidth = width - 10;
        int textWidth = this.minecraft.field_1772.method_27525((class_5348)this.title);
        if (isHovered) {
            guiGraphics.method_25294(left, top, left + width, top + height, 0x40FFFFFF);
        }
        int textY = top + (height - 8) / 2;
        if (isHovered && textWidth > availableWidth) {
            long now = System.currentTimeMillis();
            if (now - this.lastScrollTime >= 30L) {
                this.lastScrollTime = now;
                ++this.scrollOffset;
                int fullCycle = textWidth + 10;
                if (this.scrollOffset > fullCycle) {
                    this.scrollOffset = 0;
                }
            }
            guiGraphics.method_27535(this.minecraft.field_1772, this.title, left + 5 - this.scrollOffset, textY, textColor);
            guiGraphics.method_27535(this.minecraft.field_1772, this.title, left + 5 - this.scrollOffset + textWidth + 10, textY, textColor);
        } else {
            this.scrollOffset = 0;
            this.lastScrollTime = System.currentTimeMillis();
            guiGraphics.method_27535(this.minecraft.field_1772, this.title, left + 5, textY, textColor);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isHovered && button == 0) {
            this.onClick.run();
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    @NotNull
    public List<? extends class_6379> method_37025() {
        ArrayList<class_6379> result = new ArrayList<class_6379>();
        for (class_364 child : this.children) {
            if (!(child instanceof class_6379)) continue;
            result.add((class_6379)child);
        }
        return result;
    }
}

