/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_310;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;

@Environment(value=EnvType.CLIENT)
public class CommandStaffHandler {
    private static CommandStaffHandler instance;
    private class_1799 currentCommandStaff;
    private class_2338 targetBlockPos;
    private class_1297 attackTargetEntity;
    private class_2338 attackMoveBlockPos;
    private final Set<BaseCombatEntity> teamEntities = new HashSet<BaseCombatEntity>();
    private boolean formationMode = false;

    private CommandStaffHandler() {
    }

    public static CommandStaffHandler getInstance() {
        if (instance == null) {
            instance = new CommandStaffHandler();
        }
        return instance;
    }

    public void updateCurrentCommandStaff(class_1657 player) {
        class_1799 mainHandItem = player.method_6047();
        if (!mainHandItem.method_7960() && mainHandItem.method_7909() instanceof CommandStaffItem) {
            this.currentCommandStaff = mainHandItem;
            this.updateTeamEntities();
            this.updateRenderTargets();
        } else {
            this.currentCommandStaff = null;
            this.teamEntities.clear();
            this.clearRenderData();
        }
    }

    private void updateTeamEntities() {
        this.teamEntities.clear();
        class_310 minecraft = class_310.method_1551();
        if (this.currentCommandStaff != null && minecraft.field_1687 != null && this.currentCommandStaff.method_7985() && this.currentCommandStaff.method_7969().method_10573("TeamEntityUUIDs", 9)) {
            ArrayList<UUID> teamUUIDs = new ArrayList<UUID>();
            class_2499 uuidList = this.currentCommandStaff.method_7969().method_10554("TeamEntityUUIDs", 8);
            for (int i = 0; i < uuidList.size(); ++i) {
                String uuidString = uuidList.method_10608(i);
                teamUUIDs.add(UUID.fromString(uuidString));
            }
            for (class_1297 entity : minecraft.field_1687.method_18112()) {
                if (!(entity instanceof BaseCombatEntity) || !teamUUIDs.contains(entity.method_5667())) continue;
                this.teamEntities.add((BaseCombatEntity)entity);
            }
        }
    }

    private void updateRenderTargets() {
        class_2487 posTag;
        this.targetBlockPos = null;
        this.attackTargetEntity = null;
        this.attackMoveBlockPos = null;
        if (this.currentCommandStaff == null || !this.currentCommandStaff.method_7985()) {
            return;
        }
        class_2487 nbt = this.currentCommandStaff.method_7969();
        class_310 minecraft = class_310.method_1551();
        if (nbt.method_10573("TargetBlockPos", 10)) {
            posTag = nbt.method_10562("TargetBlockPos");
            this.targetBlockPos = new class_2338(posTag.method_10550("X"), posTag.method_10550("Y"), posTag.method_10550("Z"));
        }
        if (nbt.method_10573("AttackMoveBlockPos", 10)) {
            posTag = nbt.method_10562("AttackMoveBlockPos");
            this.attackMoveBlockPos = new class_2338(posTag.method_10550("X"), posTag.method_10550("Y"), posTag.method_10550("Z"));
        }
        if (nbt.method_10573("AttackTargetEntity", 11) && minecraft.field_1687 != null) {
            UUID targetUUID = nbt.method_25926("AttackTargetEntity");
            for (class_1297 entity : minecraft.field_1687.method_18112()) {
                if (!entity.method_5667().equals(targetUUID)) continue;
                this.attackTargetEntity = entity;
                break;
            }
        }
    }

    public void setTargetBlockPos(class_2338 pos) {
        this.targetBlockPos = pos;
    }

    public void setAttackMoveBlockPos(class_2338 pos) {
        this.attackMoveBlockPos = pos;
    }

    public void setTargetEntity(class_1297 entity) {
        this.targetBlockPos = null;
        this.attackMoveBlockPos = null;
        this.attackTargetEntity = null;
    }

    public void setAttackTargetEntity(class_1297 entity) {
        this.targetBlockPos = null;
        this.attackMoveBlockPos = null;
        this.attackTargetEntity = entity;
    }

    public class_2338 getTargetBlockPos() {
        return this.targetBlockPos;
    }

    public class_2338 getAttackMoveBlockPos() {
        return this.attackMoveBlockPos;
    }

    public class_1297 getAttackTargetEntity() {
        return this.attackTargetEntity;
    }

    public Set<BaseCombatEntity> getTeamEntities() {
        return this.teamEntities;
    }

    public boolean isEntityInTeam(class_1297 entity) {
        return entity instanceof BaseCombatEntity && this.teamEntities.contains(entity);
    }

    public void clearRenderData() {
        this.targetBlockPos = null;
        this.attackMoveBlockPos = null;
        this.attackTargetEntity = null;
    }

    public void toggleFormationMode() {
        this.formationMode = !this.formationMode;
    }

    public boolean isFormationMode() {
        return this.formationMode;
    }

    public void clientTick() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null) {
            return;
        }
        this.updateCurrentCommandStaff((class_1657)minecraft.field_1724);
    }
}

