/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1308;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_909;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.models.PriestModel;
import ydmsama.hundred_years_war.client.renderer.layers.FactionTintLayer;
import ydmsama.hundred_years_war.main.entity.entities.PriestEntity;

@Environment(value=EnvType.CLIENT)
public class PriestRenderer
extends class_909<PriestEntity, PriestModel<PriestEntity>> {
    private final PriestModel<PriestEntity> normalModel;
    private final PriestModel<PriestEntity> slimModel;
    private static final Map<Integer, String> GENDER_SUFFIX_CACHE = new ConcurrentHashMap<Integer, String>();

    public PriestRenderer(class_5617.class_5618 context) {
        super(context, new PriestModel(context.method_32167(PriestModel.LAYER_LOCATION), false), 0.5f);
        this.normalModel = new PriestModel(context.method_32167(PriestModel.LAYER_LOCATION), false);
        this.slimModel = new PriestModel(context.method_32167(PriestModel.SLIM_LAYER_LOCATION), true);
        this.method_4046(new FactionTintLayer(this));
        this.preloadCommonSkinGenders();
    }

    private void preloadCommonSkinGenders() {
        for (int i = 1; i <= 6; ++i) {
            this.getGenderSuffixFromSkinIndex(i);
        }
    }

    public static void clearGenderCache() {
        GENDER_SUFFIX_CACHE.clear();
    }

    @NotNull
    public class_2960 getTextureLocation(PriestEntity entity) {
        int skinIndex = entity.getCurrentSkinIndex();
        String genderSuffix = this.getGenderSuffixFromSkinIndex(skinIndex);
        return new class_2960("hundred_years_war", "textures/entity/priest/priest" + skinIndex + genderSuffix + ".png");
    }

    public void render(PriestEntity entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        boolean useSlim = this.shouldUseSlimModel(entity.getCurrentSkinIndex());
        this.field_4737 = useSlim ? this.slimModel : this.normalModel;
        super.method_4072((class_1308)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private String getGenderSuffixFromSkinIndex(int skinIndex) {
        return GENDER_SUFFIX_CACHE.computeIfAbsent(skinIndex, this::detectGenderSuffixFromFile);
    }

    private String detectGenderSuffixFromFile(int skinIndex) {
        try {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            class_2960 femaleTexture = new class_2960("hundred_years_war", "textures/entity/priest/priest" + skinIndex + "f.png");
            if (resourceManager.method_14486(femaleTexture).isPresent()) {
                return "f";
            }
            class_2960 maleTexture = new class_2960("hundred_years_war", "textures/entity/priest/priest" + skinIndex + "m.png");
            if (resourceManager.method_14486(maleTexture).isPresent()) {
                return "m";
            }
            return "m";
        }
        catch (Exception e) {
            return "m";
        }
    }

    private boolean shouldUseSlimModel(int skinIndex) {
        String genderSuffix = this.getGenderSuffixFromSkinIndex(skinIndex);
        return "f".equals(genderSuffix);
    }
}

