/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationScreenHandler;

@Environment(value=EnvType.CLIENT)
public class CraftingWorkstationScreen
extends class_465<CraftingWorkstationScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("minecraft", "textures/gui/container/crafting_table.png");
    private class_1799[] localRecipeTemplate = new class_1799[9];
    private class_1799 localExpectedOutput = class_1799.field_8037;
    private List<class_3955> matchingRecipes = new ArrayList<class_3955>();
    private int currentRecipeIndex = 0;

    public CraftingWorkstationScreen(CraftingWorkstationScreenHandler handler, class_1661 playerInventory, class_2561 title) {
        super((class_1703)handler, playerInventory, title);
        this.field_2792 = 176;
        this.field_2779 = 166;
        class_1799[] serverTemplate = handler.getRecipeTemplate();
        for (int i = 0; i < 9; ++i) {
            this.localRecipeTemplate[i] = serverTemplate != null && serverTemplate[i] != null ? serverTemplate[i].method_7972() : class_1799.field_8037;
        }
        class_1799 serverOutput = handler.getExpectedOutput();
        this.localExpectedOutput = serverOutput != null ? serverOutput.method_7972() : class_1799.field_8037;
        boolean hasRecipe = false;
        for (int i = 0; i < 9; ++i) {
            if (this.localRecipeTemplate[i] == null || this.localRecipeTemplate[i].method_7960()) continue;
            hasRecipe = true;
            break;
        }
        if (hasRecipe) {
            this.updateExpectedOutput();
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.inventory"), button -> this.openInventory()).method_46433(this.field_2776 + this.field_2792 - 57, this.field_2800 + 3).method_46437(50, 13).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.apply"), button -> this.applyRecipe()).method_46433(this.field_2776 + 124, this.field_2800 + 62).method_46437(46, 20).method_46431());
        if (this.matchingRecipes.size() > 1) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), button -> this.previousRecipe()).method_46433(this.field_2776 + 110, this.field_2800 + 35).method_46437(12, 16).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), button -> this.nextRecipe()).method_46433(this.field_2776 + 142, this.field_2800 + 35).method_46437(12, 16).method_46431());
        }
    }

    private void openInventory() {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            ClientPacketHandler.sendOpenCraftingInventory(((CraftingWorkstationScreenHandler)this.field_2797).getBlockEntity().method_11016());
        }
    }

    private void applyRecipe() {
        ClientPacketHandler.sendCraftingRecipeUpdate(((CraftingWorkstationScreenHandler)this.field_2797).getBlockEntity().method_11016(), this.localRecipeTemplate, this.localExpectedOutput);
        if (this.field_22787 != null) {
            this.method_25419();
        }
    }

    private void previousRecipe() {
        if (this.matchingRecipes.size() > 1) {
            this.currentRecipeIndex = (this.currentRecipeIndex - 1 + this.matchingRecipes.size()) % this.matchingRecipes.size();
            this.updateOutputFromCurrentRecipe();
        }
    }

    private void nextRecipe() {
        if (this.matchingRecipes.size() > 1) {
            this.currentRecipeIndex = (this.currentRecipeIndex + 1) % this.matchingRecipes.size();
            this.updateOutputFromCurrentRecipe();
        }
    }

    private void updateOutputFromCurrentRecipe() {
        if (this.currentRecipeIndex >= 0 && this.currentRecipeIndex < this.matchingRecipes.size()) {
            class_1715 craftingInventory = this.createCraftingContainer();
            this.localExpectedOutput = this.matchingRecipes.get(this.currentRecipeIndex).method_8116((class_1263)craftingInventory, this.field_22787.field_1687.method_30349());
        }
    }

    private class_1715 createCraftingContainer() {
        class_1715 craftingInventory = new class_1715(new class_1703(null, -1){

            public class_1799 method_7601(class_1657 player, int slot) {
                return class_1799.field_8037;
            }

            public boolean method_7597(class_1657 player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            if (this.localRecipeTemplate[i] == null) continue;
            craftingInventory.method_5447(i, this.localRecipeTemplate[i].method_7972());
        }
        return craftingInventory;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        this.renderRecipeView(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    private void renderRecipeView(class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_25302(TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int index = row * 3 + col;
                int x = this.field_2776 + 30 + col * 18;
                int y = this.field_2800 + 17 + row * 18;
                graphics.method_25294(x - 1, y - 1, x + 17, y + 17, -7631989);
                graphics.method_25294(x, y, x + 16, y + 16, -13158601);
                if (this.localRecipeTemplate[index] == null || this.localRecipeTemplate[index].method_7960()) continue;
                graphics.method_51427(this.localRecipeTemplate[index], x, y);
            }
        }
        int outputX = this.field_2776 + 124;
        int outputY = this.field_2800 + 35;
        graphics.method_25294(outputX - 1, outputY - 1, outputX + 17, outputY + 17, -7631989);
        graphics.method_25294(outputX, outputY, outputX + 16, outputY + 16, -13158601);
        if (this.localExpectedOutput != null && !this.localExpectedOutput.method_7960()) {
            graphics.method_51427(this.localExpectedOutput, outputX, outputY);
            graphics.method_51431(this.field_22793, this.localExpectedOutput, outputX, outputY);
        }
        graphics.method_25302(TEXTURE, this.field_2776 + 90, this.field_2800 + 35, 176, 0, 22, 15);
        if (this.matchingRecipes.size() > 1) {
            String recipeInfo = this.currentRecipeIndex + 1 + "/" + this.matchingRecipes.size();
            graphics.method_25300(this.field_22793, recipeInfo, this.field_2776 + 133, this.field_2800 + 55, 0x404040);
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
        graphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        super.method_25402(mouseX, mouseY, button);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int index = row * 3 + col;
                int x = this.field_2776 + 30 + col * 18;
                int y = this.field_2800 + 17 + row * 18;
                if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 16))) continue;
                if (button == 0) {
                    class_1799 carriedStack = this.field_22787.field_1724.field_7512.method_34255();
                    if (!carriedStack.method_7960()) {
                        this.localRecipeTemplate[index] = carriedStack.method_7972();
                        this.localRecipeTemplate[index].method_7939(1);
                        this.updateExpectedOutput();
                        return true;
                    }
                    class_1799 mainHandStack = this.field_22787.field_1724.method_6047();
                    if (mainHandStack.method_7960()) continue;
                    this.localRecipeTemplate[index] = mainHandStack.method_7972();
                    this.localRecipeTemplate[index].method_7939(1);
                    this.updateExpectedOutput();
                    return true;
                }
                if (button != 1) continue;
                this.localRecipeTemplate[index] = class_1799.field_8037;
                this.updateExpectedOutput();
                return true;
            }
        }
        int outputX = this.field_2776 + 124;
        int outputY = this.field_2800 + 35;
        if (!(mouseX >= (double)outputX) || !(mouseX < (double)(outputX + 16)) || !(mouseY >= (double)outputY) || mouseY < (double)(outputY + 16)) {
            // empty if block
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        class_1799 heldStack;
        if (this.field_2787 != null && this.field_2787.method_7681() && !(heldStack = this.field_2787.method_7677()).method_7960()) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    int index = row * 3 + col;
                    int x = this.field_2776 + 30 + col * 18;
                    int y = this.field_2800 + 17 + row * 18;
                    if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 16))) continue;
                    this.localRecipeTemplate[index] = heldStack.method_7972();
                    this.localRecipeTemplate[index].method_7939(1);
                    this.updateExpectedOutput();
                    return true;
                }
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private void updateExpectedOutput() {
        if (this.field_22787 != null && this.field_22787.field_1687 != null) {
            class_1715 craftingInventory = this.createCraftingContainer();
            this.matchingRecipes.clear();
            this.currentRecipeIndex = 0;
            class_1863 recipeManager = this.field_22787.field_1687.method_8433();
            for (class_3955 recipe : recipeManager.method_30027(class_3956.field_17545)) {
                if (!recipe.method_8115((class_1263)craftingInventory, (class_1937)this.field_22787.field_1687)) continue;
                this.matchingRecipes.add(recipe);
            }
            this.localExpectedOutput = !this.matchingRecipes.isEmpty() ? this.matchingRecipes.get(0).method_8116((class_1263)craftingInventory, this.field_22787.field_1687.method_30349()) : class_1799.field_8037;
            this.method_25426();
        }
    }
}

