/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_757;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.screen.widgets.RepeatButton;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstationBlockEntity;

@Environment(value=EnvType.CLIENT)
public class LumberWorkstationRangeScreen
extends class_437 {
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 176;
    private final LumberWorkstationBlockEntity blockEntity;
    private int tempRangeLeft;
    private int tempRangeRight;
    private int tempRangeUp;
    private boolean tempShowRange;
    private static final int PREVIEW_SIZE = 120;
    private static final int CELL_SIZE = 8;
    private static final int MAX_DISPLAY_RANGE = 8;
    private final List<RepeatButton> repeatButtons = new ArrayList<RepeatButton>();
    private static final int MAX_RANGE_LEFT = 10;
    private static final int MAX_RANGE_RIGHT = 10;
    private static final int MAX_RANGE_UP = 20;

    public LumberWorkstationRangeScreen(LumberWorkstationBlockEntity blockEntity) {
        super((class_2561)class_2561.method_43470((String)""));
        this.blockEntity = blockEntity;
        this.tempRangeLeft = blockEntity.getWorkRangeLeft();
        this.tempRangeRight = blockEntity.getWorkRangeRight();
        this.tempRangeUp = blockEntity.getWorkRangeUp();
        this.tempShowRange = blockEntity.isShowRange();
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        RepeatButton leftPlusBtn = new RepeatButton(centerX - 120, centerY, 20, 20, (class_2561)class_2561.method_43470((String)"+"), () -> {
            if (this.tempRangeLeft < 10) {
                ++this.tempRangeLeft;
            }
        });
        this.method_37063((class_364)leftPlusBtn);
        this.repeatButtons.add(leftPlusBtn);
        RepeatButton leftMinusBtn = new RepeatButton(centerX - 95, centerY, 20, 20, (class_2561)class_2561.method_43470((String)"-"), () -> {
            if (this.tempRangeLeft > 0) {
                --this.tempRangeLeft;
            }
        });
        this.method_37063((class_364)leftMinusBtn);
        this.repeatButtons.add(leftMinusBtn);
        RepeatButton rightMinusBtn = new RepeatButton(centerX + 75, centerY, 20, 20, (class_2561)class_2561.method_43470((String)"-"), () -> {
            if (this.tempRangeRight > 0) {
                --this.tempRangeRight;
            }
        });
        this.method_37063((class_364)rightMinusBtn);
        this.repeatButtons.add(rightMinusBtn);
        RepeatButton rightPlusBtn = new RepeatButton(centerX + 100, centerY, 20, 20, (class_2561)class_2561.method_43470((String)"+"), () -> {
            if (this.tempRangeRight < 10) {
                ++this.tempRangeRight;
            }
        });
        this.method_37063((class_364)rightPlusBtn);
        this.repeatButtons.add(rightPlusBtn);
        RepeatButton upPlusBtn = new RepeatButton(centerX - 10, centerY - 80, 20, 20, (class_2561)class_2561.method_43470((String)"+"), () -> {
            if (this.tempRangeUp < 20) {
                ++this.tempRangeUp;
            }
        });
        this.method_37063((class_364)upPlusBtn);
        this.repeatButtons.add(upPlusBtn);
        RepeatButton upMinusBtn = new RepeatButton(centerX - 10, centerY - 55, 20, 20, (class_2561)class_2561.method_43470((String)"-"), () -> {
            if (this.tempRangeUp > 0) {
                --this.tempRangeUp;
            }
        });
        this.method_37063((class_364)upMinusBtn);
        this.repeatButtons.add(upMinusBtn);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"ui.hundred_years_war.lumber_workstation.confirm"), button -> {
            this.applyChanges();
            this.method_25419();
        }).method_46434(centerX - 50, centerY + 80, 40, 15).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"ui.hundred_years_war.lumber_workstation.cancel"), button -> this.method_25419()).method_46434(centerX + 10, centerY + 80, 40, 15).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"ui.hundred_years_war.lumber_workstation.reset"), button -> {
            this.tempRangeLeft = 3;
            this.tempRangeRight = 3;
            this.tempRangeUp = 3;
        }).method_46434(centerX - 20, centerY + 63, 40, 15).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)(this.tempShowRange ? "ui.hundred_years_war.lumber_workstation.hide_range" : "ui.hundred_years_war.lumber_workstation.show_range")), button -> {
            this.tempShowRange = !this.tempShowRange;
            button.method_25355((class_2561)class_2561.method_43471((String)(this.tempShowRange ? "ui.hundred_years_war.lumber_workstation.hide_range" : "ui.hundred_years_war.lumber_workstation.show_range")));
        }).method_46434(centerX + 30, centerY + 63, 60, 15).method_46431());
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        for (RepeatButton button : this.repeatButtons) {
            button.tick();
        }
        this.method_25420(graphics);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        graphics.method_25294(centerX - 140, centerY - 100, centerX + 140, centerY + 100, Integer.MIN_VALUE);
        graphics.method_27534(this.field_22793, this.field_22785, centerX, centerY - 90, 0xFFFFFF);
        this.drawRangePreview(graphics, centerX, centerY);
        this.drawRangeInfo(graphics, centerX, centerY);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    private void drawRangePreview(class_332 graphics, int centerX, int centerY) {
        int excess;
        boolean exceedsUp;
        int previewX = centerX - 60;
        int previewY = centerY - 30;
        graphics.method_25294(previewX - 2, previewY - 2, previewX + 120 + 2, previewY + 120 - 36 + 2, -13421773);
        graphics.method_25294(previewX, previewY, previewX + 120, previewY + 120 - 36, -10066330);
        int centerGridX = 7;
        int centerGridY = 8;
        int gridLeft = centerGridX - this.tempRangeLeft;
        int gridRight = centerGridX + this.tempRangeRight;
        int gridTop = centerGridY - this.tempRangeUp;
        int gridBottom = centerGridY;
        for (int gridX = gridLeft; gridX <= gridRight; ++gridX) {
            for (int gridY = gridTop; gridY <= gridBottom; ++gridY) {
                int pixelX = previewX + gridX * 8;
                int pixelY = previewY + gridY * 8;
                if (pixelX < previewX || pixelX + 8 > previewX + 120 || pixelY < previewY || pixelY + 8 > previewY + 120 - 36) continue;
                if (gridX == centerGridX && gridY == centerGridY) {
                    graphics.method_25294(pixelX, pixelY + 8, pixelX + 8, pixelY + 16, -65536);
                }
                graphics.method_25294(pixelX, pixelY, pixelX + 8, pixelY + 8, -2147418368);
            }
        }
        int totalWidth = this.tempRangeLeft + this.tempRangeRight + 1;
        int totalHeight = this.tempRangeUp + 1;
        int workAreaPixelX = previewX + gridLeft * 8;
        int workAreaPixelY = previewY + gridTop * 8;
        int workAreaPixelWidth = totalWidth * 8;
        int workAreaPixelHeight = totalHeight * 8;
        boolean exceedsLeft = workAreaPixelX < previewX;
        boolean exceedsRight = workAreaPixelX + workAreaPixelWidth > previewX + 120;
        boolean bl = exceedsUp = workAreaPixelY < previewY;
        if (exceedsLeft) {
            excess = (previewX - workAreaPixelX) / 8;
            graphics.method_51433(this.field_22793, "+" + excess, previewX + 2, previewY + 60, 0xFFFF00, false);
        }
        if (exceedsRight) {
            excess = (workAreaPixelX + workAreaPixelWidth - previewX - 120) / 8;
            graphics.method_51433(this.field_22793, "+" + excess, previewX + 120 - 20, previewY + 60, 0xFFFF00, false);
        }
        if (exceedsUp) {
            excess = (previewY - workAreaPixelY) / 8;
            graphics.method_51433(this.field_22793, "+" + excess, previewX + 60 - 5, previewY + 2, 0xFFFF00, false);
        }
    }

    private void drawRangeInfo(class_332 graphics, int centerX, int centerY) {
        graphics.method_51433(this.field_22793, class_2561.method_43469((String)"ui.hundred_years_war.lumber_workstation.left", (Object[])new Object[]{this.tempRangeLeft}).getString(), centerX - 120, centerY - 25, 0xFFFFFF, false);
        graphics.method_51433(this.field_22793, class_2561.method_43469((String)"ui.hundred_years_war.lumber_workstation.right", (Object[])new Object[]{this.tempRangeRight}).getString(), centerX + 80, centerY - 25, 0xFFFFFF, false);
        graphics.method_51433(this.field_22793, class_2561.method_43469((String)"ui.hundred_years_war.lumber_workstation.up", (Object[])new Object[]{this.tempRangeUp}).getString(), centerX - 15, centerY - 95, 0xFFFFFF, false);
        int totalWidth = this.tempRangeLeft + this.tempRangeRight + 1;
        int totalHeight = this.tempRangeUp + 1;
        graphics.method_25300(this.field_22793, class_2561.method_43469((String)"ui.hundred_years_war.lumber_workstation.work_area", (Object[])new Object[]{totalWidth, totalHeight}).getString(), centerX, centerY + 15, 0xFFFFFF);
    }

    private void applyChanges() {
        ClientPacketHandler.sendLumberWorkstationRangePacket(this.blockEntity.method_11016(), this.tempRangeLeft, this.tempRangeRight, this.tempRangeUp, this.tempShowRange);
    }

    public boolean method_25421() {
        return false;
    }
}

