/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_638;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportOrderScreenHandler;
import ydmsama.hundred_years_war.main.data.TransportData;

@Environment(value=EnvType.CLIENT)
public class TransportOrderScreen
extends class_465<TransportOrderScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("minecraft", "textures/gui/container/generic_54.png");
    private static final int SCROLL_AREA_HEIGHT = 120;
    private static final int ENTRY_HEIGHT = 52;
    private TransportData transportData;
    private TransportData originalData;
    private List<RouteEntry> routeEntries = new ArrayList<RouteEntry>();
    private int scrollOffset = 0;
    private int totalContentHeight = 0;
    private boolean isDraggingScrollbar = false;
    private double scrollDragStartY = 0.0;
    private int scrollDragStartOffset = 0;

    public TransportOrderScreen(TransportOrderScreenHandler handler, class_1661 playerInventory, class_2561 title) {
        super((class_1703)handler, playerInventory, title);
        this.field_2792 = 256;
        this.field_2779 = 240;
        this.field_25270 = this.field_2779 - 94;
        this.transportData = this.cloneTransportData(handler.getTransportData());
        this.originalData = this.cloneTransportData(handler.getTransportData());
    }

    private TransportData cloneTransportData(TransportData source) {
        TransportData clone = new TransportData();
        clone.deserializeNBT(source.serializeNBT());
        return clone;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.apply"), button -> this.applyChanges()).method_46433(this.field_2776 + this.field_2792 - 85, this.field_2800 + 5).method_46437(40, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.method_25419()).method_46433(this.field_2776 + this.field_2792 - 42, this.field_2800 + 5).method_46437(40, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.transport_order.unbind"), button -> this.unbindWorkstation()).method_46433(this.field_2776 + 5, this.field_2800 + 15).method_46437(50, 12).method_46431());
        this.updateRouteEntries();
    }

    private void applyChanges() {
        class_2338 boundPos = ((TransportOrderScreenHandler)this.field_2797).getBoundPos();
        if (boundPos != null) {
            ClientPacketHandler.sendTransportDataUpdate(boundPos, this.transportData);
        }
        this.method_25419();
    }

    private void unbindWorkstation() {
        ClientPacketHandler.sendUnbindTransportOrder();
        this.method_25419();
    }

    private void updateRouteEntries() {
        for (RouteEntry entry : this.routeEntries) {
            if (entry == null || entry.quantityBox == null) continue;
            this.method_37066((class_364)entry.quantityBox);
        }
        this.routeEntries.clear();
        List<TransportData.TransportRoute> routes = this.transportData.getRoutes();
        this.totalContentHeight = routes.size() * 52;
        for (int i = 0; i < routes.size(); ++i) {
            RouteEntry entry = new RouteEntry(i, routes.get(i));
            this.routeEntries.add(entry);
            this.method_25429((class_364)entry.quantityBox);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        this.drawGuiFrame(graphics, mouseX, mouseY);
        graphics.method_44379(this.field_2776, this.field_2800 + 30, this.field_2776 + this.field_2792 - 10, this.field_2800 + 30 + 120);
        for (RouteEntry entry : this.routeEntries) {
            int entryY = this.field_2800 + 30 + entry.index * 52 - this.scrollOffset;
            boolean isVisible = entryY + 52 > this.field_2800 + 30 && entryY < this.field_2800 + 30 + 120;
            entry.quantityBox.method_46421(this.field_2776 + 8 + 65);
            entry.quantityBox.method_46419(entryY + 12);
            entry.quantityBox.field_22764 = isVisible;
            entry.quantityBox.field_22763 = isVisible;
            if (!isVisible) continue;
            entry.render(graphics, this.field_2776 + 8, entryY, mouseX, mouseY);
        }
        graphics.method_44380();
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
    }

    private void drawGuiFrame(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_25294(this.field_2776, this.field_2800, this.field_2776 + this.field_2792, this.field_2800 + this.field_2779, -3750202);
        graphics.method_25294(this.field_2776, this.field_2800, this.field_2776 + this.field_2792, this.field_2800 + 1, -13158601);
        graphics.method_25294(this.field_2776, this.field_2800 + this.field_2779 - 1, this.field_2776 + this.field_2792, this.field_2800 + this.field_2779, -13158601);
        graphics.method_25294(this.field_2776, this.field_2800, this.field_2776 + 1, this.field_2800 + this.field_2779, -13158601);
        graphics.method_25294(this.field_2776 + this.field_2792 - 1, this.field_2800, this.field_2776 + this.field_2792, this.field_2800 + this.field_2779, -13158601);
        graphics.method_25294(this.field_2776 + 1, this.field_2800 + 1, this.field_2776 + this.field_2792 - 1, this.field_2800 + this.field_2779 - 1, -2039584);
        graphics.method_25294(this.field_2776 + 4, this.field_2800 + 30, this.field_2776 + this.field_2792 - 14, this.field_2800 + 30 + 120, -986896);
        graphics.method_25294(this.field_2776 + this.field_2792 - 10, this.field_2800 + 30, this.field_2776 + this.field_2792 - 4, this.field_2800 + 30 + 120, -5592406);
        if (this.totalContentHeight > 120) {
            boolean isHovered;
            int scrollBarHeight = Math.max(20, (int)(14400.0f / (float)this.totalContentHeight));
            int scrollBarY = this.field_2800 + 30 + (int)((float)this.scrollOffset * (float)(120 - scrollBarHeight) / (float)(this.totalContentHeight - 120));
            int scrollBarX = this.field_2776 + this.field_2792 - 9;
            int scrollBarRight = this.field_2776 + this.field_2792 - 5;
            boolean bl = isHovered = mouseX >= scrollBarX && mouseX < scrollBarRight && mouseY >= scrollBarY && mouseY < scrollBarY + scrollBarHeight;
            int scrollBarColor = this.isDraggingScrollbar ? -12566464 : (isHovered ? -11513776 : -10461088);
            graphics.method_25294(scrollBarX, scrollBarY, scrollBarRight, scrollBarY + scrollBarHeight, scrollBarColor);
        }
        int invY = this.field_2800 + 158;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = this.field_2776 + 47 + col * 18;
                int y = invY + row * 18;
                graphics.method_25294(x - 1, y - 1, x + 17, y + 17, -7631989);
                graphics.method_25294(x, y, x + 16, y + 16, -13158601);
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = this.field_2776 + 47 + col * 18;
            int y = invY + 58;
            graphics.method_25294(x - 1, y - 1, x + 17, y + 17, -7631989);
            graphics.method_25294(x, y, x + 16, y + 16, -13158601);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean handled = super.method_25402(mouseX, mouseY, button);
        if (button == 0 && this.totalContentHeight > 120) {
            int scrollBarX = this.field_2776 + this.field_2792 - 10;
            int scrollBarRight = this.field_2776 + this.field_2792 - 4;
            int scrollBarTop = this.field_2800 + 30;
            int scrollBarBottom = this.field_2800 + 30 + 120;
            if (mouseX >= (double)scrollBarX && mouseX < (double)scrollBarRight && mouseY >= (double)scrollBarTop && mouseY < (double)scrollBarBottom) {
                int scrollBarHeight = Math.max(20, (int)(14400.0f / (float)this.totalContentHeight));
                int scrollBarY = scrollBarTop + (int)((float)this.scrollOffset * (float)(120 - scrollBarHeight) / (float)(this.totalContentHeight - 120));
                if (mouseY >= (double)scrollBarY && mouseY < (double)(scrollBarY + scrollBarHeight)) {
                    this.isDraggingScrollbar = true;
                    this.scrollDragStartY = mouseY;
                    this.scrollDragStartOffset = this.scrollOffset;
                    return true;
                }
                float clickRatio = (float)(mouseY - (double)scrollBarTop) / 120.0f;
                this.scrollOffset = (int)(clickRatio * (float)(this.totalContentHeight - 120));
                this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.totalContentHeight - 120));
                return true;
            }
        }
        int scrollAreaTop = this.field_2800 + 30;
        int scrollAreaBottom = this.field_2800 + 30 + 120;
        if (mouseY >= (double)scrollAreaTop && mouseY < (double)scrollAreaBottom) {
            for (RouteEntry entry : this.routeEntries) {
                int entryY = this.field_2800 + 30 + entry.index * 52 - this.scrollOffset;
                if (entryY + 52 <= scrollAreaTop || entryY >= scrollAreaBottom) continue;
                entry.quantityBox.method_46421(this.field_2776 + 8 + 65);
                entry.quantityBox.method_46419(entryY + 12);
                boolean needsUpdate = entry.handleClick(this.field_2776 + 8, entryY, mouseX, mouseY, button);
                if (!needsUpdate) continue;
                if (entry.needsListUpdate) {
                    this.updateRouteEntries();
                }
                return true;
            }
        }
        return handled;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar && button == 0 && this.totalContentHeight > 120) {
            int scrollBarHeight = Math.max(20, (int)(14400.0f / (float)this.totalContentHeight));
            double mouseDelta = mouseY - this.scrollDragStartY;
            double scrollRatio = mouseDelta / (double)(120 - scrollBarHeight);
            int newOffset = this.scrollDragStartOffset + (int)(scrollRatio * (double)(this.totalContentHeight - 120));
            this.scrollOffset = Math.max(0, Math.min(newOffset, this.totalContentHeight - 120));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        class_1799 heldStack;
        if (button == 0 && this.isDraggingScrollbar) {
            this.isDraggingScrollbar = false;
            return true;
        }
        if (this.field_2787 != null && this.field_2787.method_7681() && !(heldStack = this.field_2787.method_7677()).method_7960()) {
            int scrollAreaTop = this.field_2800 + 30;
            int scrollAreaBottom = this.field_2800 + 30 + 120;
            for (RouteEntry entry : this.routeEntries) {
                int entryY = this.field_2800 + 30 + entry.index * 52 - this.scrollOffset;
                if (entryY + 52 <= scrollAreaTop || entryY >= scrollAreaBottom) continue;
                int slotY = entryY + 26;
                for (int i = 0; i < 8; ++i) {
                    int slotX = this.field_2776 + 8 + i * 18;
                    if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 16))) continue;
                    class_1799 filterStack = heldStack.method_7972();
                    filterStack.method_7939(1);
                    entry.route.setFilter(i, filterStack);
                    this.updateRouteEntries();
                    return true;
                }
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.totalContentHeight > 120) {
            this.scrollOffset -= (int)(delta * 10.0);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.totalContentHeight - 120));
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return super.method_25400(chr, modifiers);
    }

    private boolean isSlotUnderMouse(class_1735 slot, double mouseX, double mouseY) {
        int x = this.field_2776 + slot.field_7873;
        int y = this.field_2800 + slot.field_7872;
        return mouseX >= (double)x && mouseX < (double)(x + 16) && mouseY >= (double)y && mouseY < (double)(y + 16);
    }

    private String ellipsizeByWidth(String text, int maxWidthPixels) {
        if (text == null) {
            return "";
        }
        if (this.field_22793.method_1727(text) <= maxWidthPixels) {
            return text;
        }
        String ell = "\u2026";
        int ellW = this.field_22793.method_1727(ell);
        if (ellW > maxWidthPixels) {
            return ell;
        }
        int totalCodePoints = text.codePointCount(0, text.length());
        int lo = 0;
        int hi = totalCodePoints;
        while (lo < hi) {
            int mid = (lo + hi + 1) / 2;
            int charIndex = text.offsetByCodePoints(0, mid);
            String substr = text.substring(0, charIndex);
            if (this.field_22793.method_1727(substr) <= maxWidthPixels - ellW) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        if (lo == 0) {
            return ell;
        }
        int cutIndex = text.offsetByCodePoints(0, lo);
        return text.substring(0, cutIndex) + ell;
    }

    @Environment(value=EnvType.CLIENT)
    private class RouteEntry {
        final int index;
        final TransportData.TransportRoute route;
        private class_342 quantityBox;
        boolean needsListUpdate = false;

        RouteEntry(int index, TransportData.TransportRoute route) {
            this.index = index;
            this.route = route;
            this.quantityBox = new class_342(TransportOrderScreen.this.field_22793, 0, 0, 30, 12, (class_2561)class_2561.method_43470((String)""));
            this.quantityBox.method_1880(3);
            this.quantityBox.method_1852(String.valueOf(route.getQuantity()));
            this.quantityBox.method_1890(s -> s.matches("^[0-9]{0,3}$"));
            this.quantityBox.method_1856(true);
            this.quantityBox.method_1868(0xFFFFFF);
            this.quantityBox.method_1860(0x808080);
            this.quantityBox.method_1858(true);
            this.quantityBox.method_1863(s -> {
                try {
                    int quantity = s.isEmpty() ? 0 : Integer.parseInt(s);
                    quantity = Math.max(0, Math.min(quantity, 999));
                    route.setQuantity(quantity);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }

        void render(class_332 graphics, int x, int y, int mouseX, int mouseY) {
            class_638 level = ((TransportOrderScreen)TransportOrderScreen.this).field_22787.field_1687;
            if (level == null) {
                return;
            }
            class_2338 pos = this.route.getTargetPos();
            class_2680 state = level.method_8320(pos);
            class_2248 block = state.method_26204();
            String blockName = String.format("%d. %s", this.index + 1, block.method_9518().getString());
            blockName = TransportOrderScreen.this.ellipsizeByWidth(blockName, 112);
            graphics.method_51433(TransportOrderScreen.this.field_22793, blockName, x, y, 0x404040, false);
            String posString = String.format("[%d, %d, %d]", pos.method_10263(), pos.method_10264(), pos.method_10260());
            graphics.method_51433(TransportOrderScreen.this.field_22793, posString, x + 120, y, 0x404040, false);
            int buttonY = y + 12;
            String modeText = class_2561.method_43471((String)this.route.getMode().getTranslationKey()).getString();
            modeText = TransportOrderScreen.this.ellipsizeByWidth(modeText, 54);
            this.drawButton(graphics, x, buttonY, 60, 12, modeText, this.isInside(mouseX, mouseY, x, buttonY, 60, 12));
            this.quantityBox.method_46421(x + 65);
            this.quantityBox.method_46419(buttonY);
            this.quantityBox.method_25394(graphics, mouseX, mouseY, 0.0f);
            this.drawButton(graphics, x + 220, y, 12, 9, "X", this.isInside(mouseX, mouseY, x + 220, y, 12, 9));
            this.drawButton(graphics, x + 220, buttonY, 12, 12, "\u25b2", this.isInside(mouseX, mouseY, x + 220, buttonY, 12, 12));
            this.drawButton(graphics, x + 220, buttonY + 14, 12, 12, "\u25bc", this.isInside(mouseX, mouseY, x + 220, buttonY + 14, 12, 12));
            int slotY = buttonY + 14;
            List<class_1799> filters = this.route.getFilters();
            for (int i = 0; i < 8; ++i) {
                int slotX = x + i * 18;
                boolean hovered = this.isInside(mouseX, mouseY, slotX, slotY, 16, 16);
                int bgColor = hovered ? -5197648 : -8355712;
                int innerColor = hovered ? -3092272 : -4144960;
                graphics.method_25294(slotX, slotY, slotX + 16, slotY + 16, bgColor);
                graphics.method_25294(slotX + 1, slotY + 1, slotX + 15, slotY + 15, innerColor);
                if (i >= filters.size() || filters.get(i).method_7960()) continue;
                class_1799 displayStack = filters.get(i).method_7972();
                displayStack.method_7939(1);
                graphics.method_51427(displayStack, slotX, slotY);
            }
            graphics.method_25294(x - 4, y + 52 - 2, x + 232, y + 52 - 1, -8355712);
        }

        boolean handleClick(int x, int y, double mouseX, double mouseY, int button) {
            List<TransportData.TransportRoute> routes;
            this.needsListUpdate = false;
            if (this.isInside(mouseX, mouseY, x, y + 12, 60, 12)) {
                this.route.toggleMode();
                return true;
            }
            if (this.isInside(mouseX, mouseY, x + 220, y, 12, 9)) {
                TransportOrderScreen.this.transportData.getRoutes().remove(this.index);
                this.needsListUpdate = true;
                return true;
            }
            if (this.isInside(mouseX, mouseY, x + 220, y + 12, 12, 12) && this.index > 0) {
                List<TransportData.TransportRoute> routes2 = TransportOrderScreen.this.transportData.getRoutes();
                TransportData.TransportRoute temp = routes2.get(this.index);
                routes2.set(this.index, routes2.get(this.index - 1));
                routes2.set(this.index - 1, temp);
                this.needsListUpdate = true;
                return true;
            }
            if (this.isInside(mouseX, mouseY, x + 220, y + 26, 12, 12) && this.index < (routes = TransportOrderScreen.this.transportData.getRoutes()).size() - 1) {
                TransportData.TransportRoute temp = routes.get(this.index);
                routes.set(this.index, routes.get(this.index + 1));
                routes.set(this.index + 1, temp);
                this.needsListUpdate = true;
                return true;
            }
            int slotY = y + 26;
            for (int i = 0; i < 8; ++i) {
                if (!this.isInside(mouseX, mouseY, x + i * 18, slotY, 16, 16)) continue;
                if (button == 0) {
                    class_1799 carriedStack = ((TransportOrderScreen)TransportOrderScreen.this).field_22787.field_1724.field_7512.method_34255();
                    if (!carriedStack.method_7960()) {
                        class_1799 filterStack = carriedStack.method_7972();
                        filterStack.method_7939(1);
                        this.route.setFilter(i, filterStack);
                        return true;
                    }
                    for (class_1735 slot : ((TransportOrderScreenHandler)((TransportOrderScreen)TransportOrderScreen.this).field_2797).field_7761) {
                        if (!slot.method_7681() || !TransportOrderScreen.this.isSlotUnderMouse(slot, mouseX, mouseY)) continue;
                        class_1799 filterStack = slot.method_7677().method_7972();
                        filterStack.method_7939(1);
                        this.route.setFilter(i, filterStack);
                        return true;
                    }
                    continue;
                }
                if (button != 1) continue;
                this.route.setFilter(i, class_1799.field_8037);
                return true;
            }
            return false;
        }

        private boolean isInside(double mouseX, double mouseY, int x, int y, int width, int height) {
            return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
        }

        private void drawButton(class_332 graphics, int x, int y, int width, int height, String text, boolean hovered) {
            int bgColor = hovered ? -5197648 : -6250336;
            graphics.method_25294(x, y, x + width, y + height, bgColor);
            graphics.method_25294(x, y, x + width, y + 1, -10461088);
            graphics.method_25294(x, y + height - 1, x + width, y + height, -10461088);
            graphics.method_25294(x, y, x + 1, y + height, -10461088);
            graphics.method_25294(x + width - 1, y, x + width, y + height, -10461088);
            int textWidth = TransportOrderScreen.this.field_22793.method_1727(text);
            int textX = x + (width - textWidth) / 2;
            Objects.requireNonNull(TransportOrderScreen.this.field_22793);
            int textY = y + (height - 9) / 2;
            graphics.method_51433(TransportOrderScreen.this.field_22793, text, textX, textY, 0xFFFFFF, false);
        }
    }
}

