/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.structure;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.structure.BuildModeRenderer;

@Environment(value=EnvType.CLIENT)
public class BuildModeHandler {
    private static boolean buildModeEnabled = false;
    private static String activeTemplate = "";
    private static class_3965 lastHitResult = null;
    private static class_2470 rotation = class_2470.field_11467;

    public static void initialize() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (buildModeEnabled && Freecam.isEnabled()) {
                BuildModeHandler.detectHitResult();
            }
        });
    }

    private static void detectHitResult() {
        class_239 result;
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 != null && minecraft.field_1687 != null && (result = Freecam.getFreeCamera().camPick(200.0, 0.0f, true, false)) instanceof class_3965) {
            lastHitResult = (class_3965)result;
        }
    }

    public static class_2338 getCenterPosition() {
        if (lastHitResult == null || BuildModeRenderer.getStructureSize() == null) {
            return null;
        }
        class_2338 position1 = lastHitResult.method_17777();
        while (!BuildModeHandler.isSolidBlock(position1) && position1.method_10264() > 0) {
            position1 = position1.method_10074();
        }
        return position1;
    }

    public static class_2338 getBuildPosition() {
        if (lastHitResult == null || BuildModeRenderer.getStructureSize() == null) {
            return null;
        }
        class_2338 position1 = lastHitResult.method_17777();
        class_2382 rotatedSize = BuildModeRenderer.rotateVec3i(BuildModeRenderer.getStructureSize(), rotation);
        while (!BuildModeHandler.isSolidBlock(position1) && position1.method_10264() > 0) {
            position1 = position1.method_10074();
        }
        int offsetX = rotatedSize.method_10263() / 2;
        int offsetY = rotatedSize.method_10264() / 2;
        int offsetZ = rotatedSize.method_10260() / 2;
        if (rotatedSize.method_10263() % 2 == 0) {
            --offsetX;
        }
        if (rotatedSize.method_10264() % 2 == 0) {
            --offsetY;
        }
        if (rotatedSize.method_10260() % 2 == 0) {
            --offsetZ;
        }
        class_2338 position2 = position1.method_10069(-offsetX, 0, -offsetZ);
        return position2;
    }

    private static boolean isSolidBlock(class_2338 pos) {
        assert (class_310.method_1551().field_1687 != null);
        class_2680 blockState = class_310.method_1551().field_1687.method_8320(pos);
        return blockState.method_26216((class_1922)class_310.method_1551().field_1687, pos);
    }

    public static int toggleBuildMode(CommandContext<class_2168> context) {
        buildModeEnabled = !buildModeEnabled;
        return 1;
    }

    public static void toggleBuildMode() {
        buildModeEnabled = !buildModeEnabled;
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 != null && minecraft.field_1724.method_7337()) {
            class_5250 message = class_2561.method_43471((String)"msg.hyw.buildMode").method_10852((class_2561)class_2561.method_43471((String)(buildModeEnabled ? "msg.hyw.enabled" : "msg.hyw.disabled")).method_27692(buildModeEnabled ? class_124.field_1060 : class_124.field_1061));
            minecraft.field_1724.method_7353((class_2561)message, true);
        }
    }

    public static int setActiveTemplate(CommandContext<class_2168> context) {
        activeTemplate = StringArgumentType.getString(context, (String)"template");
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"msg.hyw.active_template", (Object[])new Object[]{activeTemplate}), true);
        ClientPacketHandler.sendRequestTemplateSize(activeTemplate);
        return 1;
    }

    public static void rotateStructure() {
        switch (rotation) {
            case field_11467: {
                rotation = class_2470.field_11463;
                break;
            }
            case field_11463: {
                rotation = class_2470.field_11464;
                break;
            }
            case field_11464: {
                rotation = class_2470.field_11465;
                break;
            }
            case field_11465: {
                rotation = class_2470.field_11467;
            }
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 != null) {
            minecraft.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.hyw.structure_rotated", (Object[])new Object[]{rotation}), true);
        }
    }

    public static class_2470 getRotation() {
        return rotation;
    }

    public static boolean isBuildModeEnabled() {
        return buildModeEnabled;
    }

    public static String getActiveTemplate() {
        return activeTemplate;
    }

    public static class_3965 getLastHitResult() {
        return lastHitResult;
    }
}

