/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import ydmsama.hundred_years_war.main.blocks.ModBlocks;
import ydmsama.hundred_years_war.main.commands.Commands;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.handler.ModTickHandler;
import ydmsama.hundred_years_war.main.handler.WorldTickHandler;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.RelationSyncPacket;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentConfigManager;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.registry.LootTableModifiers;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.structure.ConstructionManager;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.ExpBlacklistManager;
import ydmsama.hundred_years_war.main.utils.FirstJoinHandler;
import ydmsama.hundred_years_war.main.utils.FreecamStateManager;
import ydmsama.hundred_years_war.main.utils.PuppetStateHandler;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.ServerManager;
import ydmsama.hundred_years_war.main.utils.TargetListManager;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class HundredYearsWar
implements ModInitializer {
    public void onInitialize() {
        ServerModConfig.load();
        File configDir = new File("config/hundredyearswar");
        if (!configDir.exists()) {
            configDir.mkdirs();
            System.out.println("\u5df2\u521b\u5efaconfig/hundredyearswar\u76ee\u5f55");
        }
        System.out.println("\u6b63\u5728\u52a0\u8f7dBaseCombatEntity\u76ee\u6807\u5217\u8868...");
        TargetListManager.loadTargetList();
        System.out.println("BaseCombatEntity\u76ee\u6807\u5217\u8868\u52a0\u8f7d\u5b8c\u6210");
        System.out.println("\u6b63\u5728\u52a0\u8f7d\u7ecf\u9a8c\u9ed1\u540d\u5355...");
        ExpBlacklistManager.loadExpBlacklist();
        System.out.println("\u7ecf\u9a8c\u9ed1\u540d\u5355\u52a0\u8f7d\u5b8c\u6210");
        HywItemRegistry.initialize();
        HywAttributes.initialize();
        ModBlocks.initialize();
        this.registerCommands();
        this.setupServerLifecycleEvents();
        this.initializeOtherSystems();
        WorldTickHandler.register();
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                FirstJoinHandler.handlePlayerFirstJoin(player);
                UUID playerUUID = player.method_5667();
                String playerName = player.method_5477().getString();
                RelationSystem.addPlayerAndEnsureRelations(playerUUID, playerName);
                RelationSyncPacket.sendToClient(player);
                ServerPacketHandler.sendCreativeSettingsSync(player);
                for (UUID teamUUID : RelationSystem.getAllTeams().keySet()) {
                    TeamRelationData team = RelationSystem.getTeamRelationData(teamUUID);
                    if (team == null || !"Player's Elite Squad".equals(team.getTeamName())) continue;
                    boolean hasOwner = false;
                    for (Map.Entry<UUID, TeamRelationData.MemberType> entry : team.getAllMembers().entrySet()) {
                        if (entry.getValue() != TeamRelationData.MemberType.OWNER) continue;
                        hasOwner = true;
                        break;
                    }
                    if (hasOwner) break;
                    team.addMember(playerUUID, TeamRelationData.MemberType.OWNER);
                    System.out.println("\u73a9\u5bb6 " + playerName + " \u5df2\u88ab\u8bbe\u7f6e\u4e3a\u56e2\u961f Player's Elite Squad \u7684\u6240\u6709\u8005");
                    break;
                }
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            UUID playerUUID = player.method_5667();
            FreecamStateManager.removePlayerState(playerUUID);
            PuppetStateHandler.clearPlayerState(playerUUID);
            CreativeModeSettings.remove((class_1657)player);
        });
        ConstructionManager.register();
        LootTableModifiers.init();
        ServerManager.init();
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, environment, registrationEnvironment) -> Commands.registerCommands((CommandDispatcher<class_2168>)dispatcher));
    }

    private void setupServerLifecycleEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Path worldPath = server.method_27050(class_5218.field_24188);
            FirstJoinHandler.loadFirstJoinData(worldPath);
            Path relationSavePath = worldPath.resolve("relations.dat");
            RelationSystem.loadRelations(relationSavePath);
            RecruitmentConfigManager.loadAllConfigs();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            Path worldPath = server.method_27050(class_5218.field_24188);
            FirstJoinHandler.saveFirstJoinData(worldPath);
            Path relationSavePath = worldPath.resolve("relations.dat");
            try {
                RelationSystem.saveRelations(relationSavePath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            FreecamStateManager.clearAllStates();
            PuppetStateHandler.clearAllTemporaryStates();
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Path squadsPath = server.method_27050(class_5218.field_24188).resolve("squads.dat");
            try {
                SelectionSystem.loadSquads(squadsPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Path puppetStatesPath = server.method_27050(class_5218.field_24188).resolve("puppet_states.dat");
            try {
                PuppetStateHandler.loadPersistentStates(puppetStatesPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            Path squadsPath = server.method_27050(class_5218.field_24188).resolve("squads.dat");
            try {
                SelectionSystem.saveSquads(squadsPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path puppetStatesPath = server.method_27050(class_5218.field_24188).resolve("puppet_states.dat");
            try {
                PuppetStateHandler.savePersistentStates(puppetStatesPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void initializeOtherSystems() {
        HywEntityRegistry.registerEntities();
        ServerPacketHandler.registerReceivers();
        ModTickHandler.registerTickHandler();
    }
}

