/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1430;
import net.minecraft.class_1452;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;

public class BreedingWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int WORK_INTERVAL = 60;
    public static final int MAX_RANGE_LEFT = 8;
    public static final int MAX_RANGE_RIGHT = 8;
    public static final int MAX_RANGE_UP = 16;
    public static final int MAX_RANGE_DOWN = 0;
    private int maxAnimals = 10;
    private int workTimer = 0;
    private final Random random = new Random();

    public BreedingWorkstationBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.BREEDING_WORKSTATION_BLOCK_ENTITY, pos, blockState);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = 0;
        this.showRange = true;
        this.maxAnimals = 10;
        this.workTimer = 0;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, BreedingWorkstationBlockEntity blockEntity) {
        if (level != null && !level.field_9236) {
            blockEntity.serverTick();
        }
    }

    private void serverTick() {
        if (!this.activated) {
            return;
        }
        --this.workTimer;
        if (this.workTimer <= 0) {
            this.workTimer = 60 + this.random.nextInt(20) - 10;
            this.performBreedingWork();
        }
    }

    @Override
    public void triggerWork() {
        this.collectDroppedItems();
        this.performBreedingWork();
    }

    private void performBreedingWork() {
        class_1429 animal22;
        class_238 workArea = this.getWorkArea();
        List animals = this.field_11863.method_18467(class_1429.class, workArea);
        animals.removeIf(animal -> !animal.method_5805() || animal.method_31481());
        if (animals.isEmpty()) {
            return;
        }
        ArrayList<class_1429> adults = new ArrayList<class_1429>();
        for (class_1429 animal22 : animals) {
            if (animal22.method_6109()) continue;
            adults.add(animal22);
        }
        if (adults.size() > this.maxAnimals) {
            Collections.shuffle(adults, this.random);
            for (int i = this.maxAnimals; i < adults.size(); ++i) {
                this.killAnimal((class_1429)adults.get(i));
            }
        }
        Iterator iterator = animals.iterator();
        while (!(!iterator.hasNext() || this.canAndShouldFeedAnimal(animal22 = (class_1429)iterator.next()) && this.feedAnimal(animal22))) {
        }
    }

    private boolean canAndShouldFeedAnimal(class_1429 animal) {
        if (!animal.method_5805() || animal.method_31481()) {
            return false;
        }
        if (animal.method_5618() != 0 || !animal.method_6482()) {
            return false;
        }
        return this.hasAnimalFood(animal);
    }

    private boolean hasAnimalFood(class_1429 animal) {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (!this.isValidAnimalFood(animal, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean feedAnimal(class_1429 animal) {
        if (!animal.method_5805() || animal.method_31481() || animal.method_5618() != 0 || !animal.method_6482()) {
            return false;
        }
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (!this.isValidAnimalFood(animal, stack)) continue;
            stack.method_7934(1);
            this.method_5431();
            animal.method_6480(null);
            return true;
        }
        return false;
    }

    private boolean isValidAnimalFood(class_1429 animal, class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return animal.method_6481(stack);
    }

    private void killAnimal(class_1429 animal) {
        if (!animal.method_5805() || animal.method_31481()) {
            return;
        }
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        if (animal instanceof class_1430) {
            drops.add(new class_1799((class_1935)class_1802.field_8046, 1 + this.random.nextInt(3)));
            drops.add(new class_1799((class_1935)class_1802.field_8745, 0 + this.random.nextInt(3)));
        } else if (animal instanceof class_1452) {
            drops.add(new class_1799((class_1935)class_1802.field_8389, 1 + this.random.nextInt(3)));
        } else if (animal instanceof class_1472) {
            drops.add(new class_1799((class_1935)class_1802.field_8748, 1 + this.random.nextInt(3)));
            if (this.random.nextBoolean()) {
                drops.add(new class_1799((class_1935)class_1802.field_19044, 1 + this.random.nextInt(2)));
            }
        } else if (animal instanceof class_1428) {
            drops.add(new class_1799((class_1935)class_1802.field_8726, 1));
            drops.add(new class_1799((class_1935)class_1802.field_8153, 0 + this.random.nextInt(3)));
        } else if (animal instanceof class_1463) {
            drops.add(new class_1799((class_1935)class_1802.field_8504, 1));
            if (this.random.nextFloat() < 0.1f) {
                drops.add(new class_1799((class_1935)class_1802.field_8073, 1));
            }
        }
        for (class_1799 drop : drops) {
            class_1799 remaining = this.insertItem(drop.method_7972());
            if (remaining.method_7960()) continue;
            class_2248.method_9577((class_1937)this.field_11863, (class_2338)animal.method_24515(), (class_1799)remaining);
        }
        animal.method_31472();
    }

    private class_1799 insertItem(class_1799 stack) {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            int maxStackSize;
            int canAdd;
            class_1799 slotStack = this.inventory.method_5438(i);
            if (slotStack.method_7960()) {
                this.inventory.method_5447(i, stack.method_7972());
                this.method_5431();
                return class_1799.field_8037;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)stack) || (canAdd = (maxStackSize = Math.min(slotStack.method_7914(), this.inventory.method_5444())) - slotStack.method_7947()) <= 0) continue;
            int toAdd = Math.min(canAdd, stack.method_7947());
            slotStack.method_7933(toAdd);
            stack.method_7934(toAdd);
            this.method_5431();
            if (!stack.method_7960()) continue;
            return class_1799.field_8037;
        }
        return stack;
    }

    @Override
    public class_2350 getFacing() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)BreedingWorkstation.FACING)) {
            return (class_2350)state.method_11654((class_2769)BreedingWorkstation.FACING);
        }
        return class_2350.field_11043;
    }

    @Override
    public void setWorkRangeLeft(int range) {
        super.setWorkRangeLeft(range);
    }

    @Override
    public void setWorkRangeRight(int range) {
        super.setWorkRangeRight(range);
    }

    @Override
    public void setWorkRangeUp(int range) {
        super.setWorkRangeUp(range);
    }

    @Override
    public void setWorkRangeDown(int range) {
        super.setWorkRangeDown(range);
    }

    public int getMaxAnimals() {
        return this.maxAnimals;
    }

    public void setMaxAnimals(int maxAnimals) {
        this.maxAnimals = Math.max(0, Math.min(maxAnimals, 50));
        this.method_5431();
        if (this.activated && this.field_11863 != null && !this.field_11863.field_9236) {
            this.performBreedingWork();
        }
    }

    @Override
    public int getMaxRangeLeft() {
        return 8;
    }

    @Override
    public int getMaxRangeRight() {
        return 8;
    }

    @Override
    public int getMaxRangeUp() {
        return 16;
    }

    @Override
    public int getMaxRangeDown() {
        return 0;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new BreedingWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"hundred_years_war.breeding_workstation");
    }

    @Override
    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("workTimer", this.workTimer);
        tag.method_10569("maxAnimals", this.maxAnimals);
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.workTimer = tag.method_10550("workTimer");
        this.maxAnimals = tag.method_10545("maxAnimals") ? tag.method_10550("maxAnimals") : 10;
        this.maxAnimals = Math.max(0, Math.min(this.maxAnimals, 50));
    }
}

