/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;

public class CraftingWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int INVENTORY_SIZE = 27;
    private static final int RECIPE_GRID_SIZE = 9;
    private final class_1799[] recipeTemplate = new class_1799[9];
    private class_1799 expectedOutput = class_1799.field_8037;

    public CraftingWorkstationBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.CRAFTING_WORKSTATION, pos, state);
        this.inventory = new class_1277(27);
        for (int i = 0; i < 9; ++i) {
            this.recipeTemplate[i] = class_1799.field_8037;
        }
        this.workRangeLeft = 0;
        this.workRangeRight = 0;
        this.workRangeUp = 0;
        this.workRangeDown = 0;
        this.showRange = false;
    }

    @Override
    public int getMaxRangeLeft() {
        return 0;
    }

    @Override
    public int getMaxRangeRight() {
        return 0;
    }

    @Override
    public int getMaxRangeUp() {
        return 0;
    }

    @Override
    public int getMaxRangeDown() {
        return 0;
    }

    @Override
    public class_2350 getFacing() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)CraftingWorkstation.FACING)) {
            return (class_2350)state.method_11654((class_2769)CraftingWorkstation.FACING);
        }
        return class_2350.field_11043;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new CraftingWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"block.hundred_years_war.crafting_workstation");
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CraftingWorkstationBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
    }

    public class_1799[] getRecipeTemplate() {
        return this.recipeTemplate;
    }

    public void setRecipeTemplateSlot(int index, class_1799 stack) {
        if (index >= 0 && index < 9) {
            this.recipeTemplate[index] = stack.method_7972();
            this.recipeTemplate[index].method_7939(1);
            this.updateExpectedOutput();
            this.method_5431();
        }
    }

    public class_1799 getExpectedOutput() {
        return this.expectedOutput;
    }

    public void setExpectedOutput(class_1799 output) {
        this.expectedOutput = output.method_7972();
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    private void updateExpectedOutput() {
        if (this.field_11863 == null) {
            return;
        }
        class_1715 craftingInventory = new class_1715(new class_1703(null, -1){

            public class_1799 method_7601(class_1657 player, int slot) {
                return class_1799.field_8037;
            }

            public boolean method_7597(class_1657 player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftingInventory.method_5447(i, this.recipeTemplate[i].method_7972());
        }
        Optional recipe = this.field_11863.method_8433().method_8132(class_3956.field_17545, (class_1263)craftingInventory, this.field_11863);
        this.expectedOutput = recipe.isPresent() ? ((class_3955)recipe.get()).method_8116((class_1263)craftingInventory, this.field_11863.method_30349()) : class_1799.field_8037;
        if (!this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public boolean performCrafting() {
        class_1799 invStack;
        int j;
        int i;
        if (this.field_11863 == null || this.field_11863.field_9236 || this.expectedOutput.method_7960()) {
            return false;
        }
        int[] requiredCounts = new int[9];
        for (i = 0; i < 9; ++i) {
            if (this.recipeTemplate[i].method_7960()) continue;
            requiredCounts[i] = 1;
        }
        for (i = 0; i < 9; ++i) {
            if (this.recipeTemplate[i].method_7960()) continue;
            boolean hasEnough = false;
            for (j = 0; j < 27; ++j) {
                invStack = this.inventory.method_5438(j);
                if (!class_1799.method_31577((class_1799)invStack, (class_1799)this.recipeTemplate[i]) || invStack.method_7947() < requiredCounts[i]) continue;
                hasEnough = true;
                break;
            }
            if (hasEnough) continue;
            return false;
        }
        for (i = 0; i < 9; ++i) {
            if (this.recipeTemplate[i].method_7960()) continue;
            int toConsume = 1;
            for (j = 0; j < 27 && toConsume > 0; ++j) {
                invStack = this.inventory.method_5438(j);
                if (!class_1799.method_31577((class_1799)invStack, (class_1799)this.recipeTemplate[i])) continue;
                int consumed = Math.min(toConsume, invStack.method_7947());
                invStack.method_7934(consumed);
                toConsume -= consumed;
            }
        }
        class_1799 output = this.expectedOutput.method_7972();
        for (int i2 = 0; i2 < 27 && !output.method_7960(); ++i2) {
            class_1799 slot = this.inventory.method_5438(i2);
            if (slot.method_7960()) {
                this.inventory.method_5447(i2, output);
                output = class_1799.field_8037;
                continue;
            }
            if (!class_1799.method_31577((class_1799)slot, (class_1799)output)) continue;
            int space = slot.method_7914() - slot.method_7947();
            int toAdd = Math.min(space, output.method_7947());
            slot.method_7933(toAdd);
            output.method_7934(toAdd);
        }
        if (!output.method_7960()) {
            class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)(this.field_11867.method_10264() + 1), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)output);
        }
        this.method_5431();
        return true;
    }

    @Override
    public void triggerWork() {
        this.performCrafting();
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2499 recipeList = new class_2499();
        for (int i = 0; i < 9; ++i) {
            if (this.recipeTemplate[i].method_7960()) continue;
            class_2487 slotTag = new class_2487();
            slotTag.method_10567("Slot", (byte)i);
            slotTag.method_10566("Item", (class_2520)this.recipeTemplate[i].method_7953(new class_2487()));
            recipeList.add((Object)slotTag);
        }
        tag.method_10566("RecipeTemplate", (class_2520)recipeList);
        if (!this.expectedOutput.method_7960()) {
            tag.method_10566("ExpectedOutput", (class_2520)this.expectedOutput.method_7953(new class_2487()));
        }
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        for (int i = 0; i < 9; ++i) {
            this.recipeTemplate[i] = class_1799.field_8037;
        }
        class_2499 recipeList = tag.method_10554("RecipeTemplate", 10);
        for (int i = 0; i < recipeList.size(); ++i) {
            class_2487 slotTag = recipeList.method_10602(i);
            byte slot = slotTag.method_10571("Slot");
            if (slot < 0 || slot >= 9) continue;
            this.recipeTemplate[slot] = class_1799.method_7915((class_2487)slotTag.method_10562("Item"));
        }
        this.expectedOutput = tag.method_10545("ExpectedOutput") ? class_1799.method_7915((class_2487)tag.method_10562("ExpectedOutput")) : class_1799.field_8037;
    }

    @Override
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }
}

