/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationScreenHandler;

public class MiningWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int WORK_INTERVAL = 20;
    private static final int MINING_SCAN_RANGE = 3;
    public static final int MAX_RANGE_LEFT = 25;
    public static final int MAX_RANGE_RIGHT = 25;
    public static final int MAX_RANGE_UP = 50;
    public static final int MAX_RANGE_DOWN = 50;
    public static final int MIN_RANGE_DOWN = -50;
    private final Set<class_2338> miningPositions = new HashSet<class_2338>();
    private int workTimer = 0;
    private Integer currentMiningLevel = null;
    private boolean miningDirection = true;
    private int levelsUpMined = 0;
    private int levelsDownMined = 0;

    public MiningWorkstationBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.MINING_WORKSTATION_BLOCK_ENTITY, pos, blockState);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = -1;
        this.showRange = true;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, MiningWorkstationBlockEntity blockEntity) {
        if (level != null && !level.field_9236) {
            blockEntity.serverTick();
        }
    }

    private void serverTick() {
        if (!this.activated) {
            return;
        }
        --this.workTimer;
        if (this.workTimer <= 0) {
            this.workTimer = 20;
            if (this.miningPositions.isEmpty()) {
                this.scanForMiningTargets();
            }
            if (!this.miningPositions.isEmpty()) {
                this.performMining();
            }
        }
    }

    @Override
    public void triggerWork() {
        this.collectDroppedItems();
        if (this.miningPositions.isEmpty()) {
            this.scanForMiningTargets();
        }
        if (!this.miningPositions.isEmpty()) {
            this.performMining();
        }
    }

    private void scanForMiningTargets() {
        boolean foundAnyBlocks;
        this.miningPositions.clear();
        class_238 workArea = this.getWorkArea();
        int minX = (int)Math.floor(workArea.field_1323);
        int maxX = (int)Math.floor(workArea.field_1320 - 0.01);
        int minY = (int)Math.floor(workArea.field_1322);
        int maxY = (int)Math.floor(workArea.field_1325 - 0.01);
        int minZ = (int)Math.floor(workArea.field_1321);
        int maxZ = (int)Math.floor(workArea.field_1324 - 0.01);
        if (this.currentMiningLevel == null) {
            this.currentMiningLevel = this.method_11016().method_10264();
            this.currentMiningLevel = Math.max(minY, Math.min(maxY, this.currentMiningLevel));
        }
        if (!(foundAnyBlocks = this.scanLevel(this.currentMiningLevel, minX, maxX, minZ, maxZ))) {
            boolean foundNewLevel = false;
            for (int offset = 1; offset <= Math.max(maxY - this.currentMiningLevel, this.currentMiningLevel - minY); ++offset) {
                int upLevel = this.currentMiningLevel + offset;
                if (upLevel <= maxY && this.scanLevel(upLevel, minX, maxX, minZ, maxZ)) {
                    this.currentMiningLevel = upLevel;
                    foundNewLevel = true;
                    break;
                }
                int downLevel = this.currentMiningLevel - offset;
                if (downLevel < minY || !this.scanLevel(downLevel, minX, maxX, minZ, maxZ)) continue;
                this.currentMiningLevel = downLevel;
                foundNewLevel = true;
                break;
            }
            if (!foundNewLevel) {
                this.currentMiningLevel = this.method_11016().method_10264();
                this.currentMiningLevel = Math.max(minY, Math.min(maxY, this.currentMiningLevel));
            }
        }
    }

    private boolean scanLevel(int y, int minX, int maxX, int minZ, int maxZ) {
        boolean foundAny = false;
        int centerX = this.method_11016().method_10263();
        int centerZ = this.method_11016().method_10260();
        ArrayList<class_2338> levelPositions = new ArrayList<class_2338>();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                class_2338 checkPos = new class_2338(x, y, z);
                if (!this.canMineAt(checkPos)) continue;
                levelPositions.add(checkPos);
                foundAny = true;
            }
        }
        levelPositions.sort((pos1, pos2) -> {
            double dist1 = Math.pow(pos1.method_10263() - centerX, 2.0) + Math.pow(pos1.method_10260() - centerZ, 2.0);
            double dist2 = Math.pow(pos2.method_10263() - centerX, 2.0) + Math.pow(pos2.method_10260() - centerZ, 2.0);
            return Double.compare(dist1, dist2);
        });
        this.miningPositions.addAll(levelPositions);
        return foundAny;
    }

    private boolean performMining() {
        if (this.miningPositions.isEmpty()) {
            return false;
        }
        Iterator<class_2338> iterator = this.miningPositions.iterator();
        class_2338 minePos = iterator.next();
        iterator.remove();
        if (this.canMineAt(minePos)) {
            class_2680 state = this.field_11863.method_8320(minePos);
            class_2248 block = state.method_26204();
            class_8567.class_8568 lootBuilder = new class_8567.class_8568((class_3218)this.field_11863).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)minePos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51874(class_181.field_1224, (Object)state);
            class_52 lootTable = this.field_11863.method_8503().method_3857().getLootTable(block.method_26162());
            ObjectArrayList drops = lootTable.method_51878(lootBuilder.method_51875(class_173.field_1172));
            boolean canStoreAll = true;
            ArrayList<class_1799> remainingItems = new ArrayList<class_1799>();
            for (class_1799 drop : drops) {
                class_1799 simulated = this.simulateInsertItem(drop.method_7972());
                if (simulated.method_7960()) continue;
                canStoreAll = false;
                remainingItems.add(simulated);
            }
            if (canStoreAll || drops.isEmpty()) {
                this.field_11863.method_8652(minePos, class_2246.field_10124.method_9564(), 3);
                this.field_11863.method_8396(null, minePos, state.method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
                this.spawnBreakParticles(minePos, state);
                for (class_1799 drop : drops) {
                    class_1799 remaining = this.insertItem(drop.method_7972());
                    if (remaining.method_7960()) continue;
                    class_2248.method_9577((class_1937)this.field_11863, (class_2338)minePos, (class_1799)remaining);
                }
                return true;
            }
            this.miningPositions.add(minePos);
            return false;
        }
        return !this.miningPositions.isEmpty();
    }

    private boolean canMineAt(class_2338 pos) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return false;
        }
        class_2680 state = this.field_11863.method_8320(pos);
        class_2248 block = state.method_26204();
        if (state.method_26215() || block == class_2246.field_9987 || state.method_26227().method_15771()) {
            return false;
        }
        if (pos.equals((Object)this.method_11016())) {
            return false;
        }
        return this.isMineableBlock(state);
    }

    private boolean isMineableBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        float hardness = state.method_26214((class_1922)this.field_11863, class_2338.field_10980);
        if (hardness < 0.0f) {
            return false;
        }
        if (hardness <= 0.0f) {
            return false;
        }
        if (block == class_2246.field_10260 || block == class_2246.field_9987 || block == class_2246.field_10398 || block == class_2246.field_10027 || block == class_2246.field_10316 || block == class_2246.field_10499) {
            return false;
        }
        return hardness >= 0.1f && hardness <= 50.0f;
    }

    private class_1799 insertItem(class_1799 stack) {
        for (int i = 0; i < this.inventory.method_5439() && !(stack = this.inventory.method_5491(stack)).method_7960(); ++i) {
        }
        return stack;
    }

    private class_1799 simulateInsertItem(class_1799 stack) {
        class_1799 remaining = stack.method_7972();
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            int space;
            class_1799 slotStack = this.inventory.method_5438(i);
            if (slotStack.method_7960()) {
                return class_1799.field_8037;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)remaining) || (space = slotStack.method_7914() - slotStack.method_7947()) <= 0) continue;
            int toInsert = Math.min(space, remaining.method_7947());
            remaining.method_7934(toInsert);
            if (!remaining.method_7960()) continue;
            return class_1799.field_8037;
        }
        return remaining;
    }

    @Override
    public int getMaxRangeDown() {
        return 50;
    }

    @Override
    public int getMaxRangeLeft() {
        return 25;
    }

    @Override
    public int getMaxRangeRight() {
        return 25;
    }

    @Override
    public int getMaxRangeUp() {
        return 50;
    }

    @Override
    public void setWorkRangeLeft(int range) {
        super.setWorkRangeLeft(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeRight(int range) {
        super.setWorkRangeRight(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeUp(int range) {
        super.setWorkRangeUp(range);
        this.clearWorkCache();
    }

    @Override
    public void setWorkRangeDown(int range) {
        this.workRangeDown = Math.max(-50, Math.min(range, this.getMaxRangeDown()));
        this.updateWorkCenter();
        this.method_5431();
        this.syncToClient();
        this.updateRangeChunkLoading();
        this.clearWorkCache();
    }

    private void clearWorkCache() {
        this.miningPositions.clear();
        this.currentMiningLevel = null;
        this.levelsUpMined = 0;
        this.levelsDownMined = 0;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new MiningWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"hundred_years_war.mining_workstation");
    }

    @Override
    public class_2350 getFacing() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)MiningWorkstation.FACING)) {
            return (class_2350)state.method_11654((class_2769)MiningWorkstation.FACING);
        }
        return class_2350.field_11043;
    }

    private void spawnBreakParticles(class_2338 pos, class_2680 state) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        class_3218 serverLevel = (class_3218)this.field_11863;
        class_5819 random = serverLevel.method_8409();
        class_2388 particleOption = new class_2388(class_2398.field_11217, state);
        double centerX = (double)pos.method_10263() + 0.5;
        double centerY = (double)pos.method_10264() + 0.5;
        double centerZ = (double)pos.method_10260() + 0.5;
        for (int i = 0; i < 12; ++i) {
            double offsetX = (random.method_43058() - 0.5) * 0.8;
            double offsetY = (random.method_43058() - 0.5) * 0.8;
            double offsetZ = (random.method_43058() - 0.5) * 0.8;
            double velX = (random.method_43058() - 0.5) * 0.2;
            double velY = random.method_43058() * 0.15;
            double velZ = (random.method_43058() - 0.5) * 0.2;
            serverLevel.method_14199((class_2394)particleOption, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 1, velX, velY, velZ, 0.1);
        }
    }
}

