/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4255;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.action.CancelAction;
import ydmsama.hundred_years_war.main.entity.action.HoldAction;
import ydmsama.hundred_years_war.main.entity.action.PatrolAction;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.utils.ChunkLoadingUtils;

public abstract class BaseWorkerEntity
extends BaseCombatEntity {
    private boolean chunkLoadingActive = false;
    private class_1923 lastChunkPos = null;

    public BaseWorkerEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_4255((class_1308)this, true));
        this.field_6201.method_6277(1, (class_1352)new FollowEntityGoal(this, 1.0, ServerModConfig.INSTANCE.getFollowDistanceInner(), ServerModConfig.INSTANCE.getFollowDistanceOuter(), 25.0, 50.0));
        this.field_6201.method_6277(2, (class_1352)new PatrolGoal(this, 1.0, 40));
        this.field_6201.method_6277(2, (class_1352)new FollowEntityGoal(this, 1.0, ServerModConfig.INSTANCE.getFollowDistanceInner(), ServerModConfig.INSTANCE.getFollowDistanceInner(), Double.MAX_VALUE, 0.0));
        this.field_6201.method_6277(4, (class_1352)new ReturnToHomeGoal(this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    @Override
    protected void initActions() {
        this.getActions().add(new HoldAction());
        this.getActions().add(new CancelAction());
        this.getActions().add(new PatrolAction());
        this.initCustomActions();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.updateChunkLoading();
        }
    }

    private void updateChunkLoading() {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_2338 currentBlockPos = this.method_24515();
        class_1923 currentChunkPos = new class_1923(currentBlockPos);
        if (!this.chunkLoadingActive) {
            ChunkLoadingUtils.addWorkerChunkLoading(serverLevel, currentBlockPos);
            this.chunkLoadingActive = true;
            this.lastChunkPos = currentChunkPos;
        } else if (this.lastChunkPos == null || !this.lastChunkPos.equals((Object)currentChunkPos)) {
            if (this.lastChunkPos != null) {
                class_2338 oldPos = new class_2338(this.lastChunkPos.method_33940(), currentBlockPos.method_10264(), this.lastChunkPos.method_33942());
                ChunkLoadingUtils.removeWorkerChunkLoading(serverLevel, oldPos);
            }
            ChunkLoadingUtils.addWorkerChunkLoading(serverLevel, currentBlockPos);
            this.lastChunkPos = currentChunkPos;
        }
    }

    private void deactivateChunkLoading() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.chunkLoadingActive) {
                class_2338 pos = this.lastChunkPos != null ? new class_2338(this.lastChunkPos.method_33940(), this.method_24515().method_10264(), this.lastChunkPos.method_33942()) : this.method_24515();
                ChunkLoadingUtils.removeWorkerChunkLoading(serverLevel, pos);
                this.chunkLoadingActive = false;
                this.lastChunkPos = null;
            }
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.deactivateChunkLoading();
        super.method_5650(reason);
    }
}

