/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4059;
import net.minecraft.class_5132;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5819;
import net.minecraft.class_7688;
import net.minecraft.class_7923;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.entity.utils.json.EnchantmentData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.item.BaseScrollItem;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class HywHorseEntity
extends class_1498
implements BaseCombatSupport {
    private UUID ownerUUID;
    private BaseCombatEntity riderEntity;
    private int equipmentLevel = 1;
    private class_2338 homePosition;
    private static final class_2940<Boolean> IS_NPC_HORSE = class_2945.method_12791(HywHorseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_RANDOMIZED_APPEARANCE = class_2945.method_12791(HywHorseEntity.class, (class_2941)class_2943.field_13323);
    private boolean deferredSaddleEquip = false;
    private static EquipmentData equipmentData;
    private final Random random = new Random();

    private void setDeferredSaddleEquip(boolean defer) {
        this.deferredSaddleEquip = defer;
    }

    public HywHorseEntity(class_1299<? extends class_1498> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
        this.method_5971();
        this.method_6766(true);
        this.method_6749(this.method_6755());
        if (!world.field_9236) {
            this.setDeferredSaddleEquip(true);
        }
        this.randomizeIfNeeded();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_NPC_HORSE, (Object)false);
        this.field_6011.method_12784(HAS_RANDOMIZED_APPEARANCE, (Object)false);
    }

    public static class_5132.class_5133 createHorseAttributes() {
        return class_1498.method_26899();
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && this.deferredSaddleEquip) {
            this.field_6962.method_5447(0, new class_1799((class_1935)class_1802.field_8175));
            this.method_6731();
            this.deferredSaddleEquip = false;
        }
    }

    public void setRiderEntity(BaseCombatEntity rider) {
        this.riderEntity = rider;
    }

    public BaseCombatEntity getRiderEntity() {
        return this.riderEntity;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1799 playerItem;
        class_1657 player;
        if (this.method_37908().field_9236) {
            return super.method_5643(source, amount);
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_5715() && ServerRelationHelper.hasControlOver(player, (class_1297)this) && ServerModConfig.INSTANCE.isAllowEquipmentChange() && this.isHorseArmor(playerItem = player.method_5998(class_1268.field_5808))) {
            class_1799 currentArmor;
            class_1799 class_17992 = currentArmor = this.field_6962 != null ? this.field_6962.method_5438(1) : class_1799.field_8037;
            if (this.field_6962 != null) {
                this.field_6962.method_5447(1, playerItem.method_7972());
                this.method_6731();
                player.method_6122(class_1268.field_5808, class_1799.field_8037);
                if (!currentArmor.method_7960()) {
                    player.method_6122(class_1268.field_5808, currentArmor);
                }
            }
            return false;
        }
        return super.method_5643(source, amount);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_37908().field_9236) {
            class_1297 class_12972;
            if (this.isNpcHorse() && (class_12972 = this.method_31483()) instanceof BaseCombatEntity) {
                BaseCombatEntity rider = (BaseCombatEntity)class_12972;
                return rider.method_5992(player, hand);
            }
            if (this.isNpcHorse()) {
                return class_1269.field_5811;
            }
            if (player.method_5715()) {
                if (this.getScrollType() != null) {
                    boolean canRecall = false;
                    if (player.method_7337()) {
                        canRecall = CreativeModeSettings.canControlAllUnits(player);
                    } else {
                        boolean bl = canRecall = ServerModConfig.INSTANCE.isAllowSoldierRecall() && ServerRelationHelper.hasControlOver(player, (class_1297)this);
                    }
                    if (canRecall) {
                        class_1799 stack = new class_1799((class_1935)this.getScrollType());
                        class_2487 entityData = new class_2487();
                        this.method_5647(entityData);
                        ((BaseScrollItem)stack.method_7909()).saveEntityDataToItem(stack, entityData);
                        if (!player.method_31548().method_7394(stack)) {
                            player.method_7328(stack, false);
                        }
                        this.spawnParticles(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
                        this.method_31472();
                    }
                }
                return class_1269.field_5812;
            }
        }
        return super.method_5992(player, hand);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.ownerUUID != null) {
            compound.method_25927("OwnerUUID", this.ownerUUID);
        }
        compound.method_10556("DeferredSaddleEquip", this.deferredSaddleEquip);
        compound.method_10556("IsNpcHorse", this.isNpcHorse());
        compound.method_10556("HasRandomizedAppearance", this.hasRandomizedAppearance());
        compound.method_10569("EquipmentLevel", this.equipmentLevel);
        if (this.homePosition != null) {
            compound.method_10544("HomePosition", this.homePosition.method_10063());
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_25928("OwnerUUID")) {
            this.ownerUUID = compound.method_25926("OwnerUUID");
        }
        if (compound.method_10545("DeferredSaddleEquip")) {
            this.deferredSaddleEquip = compound.method_10577("DeferredSaddleEquip");
        }
        if (compound.method_10545("IsNpcHorse")) {
            this.setNpcHorse(compound.method_10577("IsNpcHorse"));
        }
        if (compound.method_10545("HasRandomizedAppearance")) {
            this.setHasRandomizedAppearance(compound.method_10577("HasRandomizedAppearance"));
        }
        if (compound.method_10545("EquipmentLevel")) {
            this.equipmentLevel = compound.method_10550("EquipmentLevel");
        }
        if (compound.method_10545("HomePosition")) {
            this.homePosition = class_2338.method_10092((long)compound.method_10537("HomePosition"));
        }
    }

    public boolean isNpcHorse() {
        return (Boolean)this.field_6011.method_12789(IS_NPC_HORSE);
    }

    public void setNpcHorse(boolean isNpcHorse) {
        this.field_6011.method_12778(IS_NPC_HORSE, (Object)isNpcHorse);
    }

    public boolean method_5810() {
        return true;
    }

    protected boolean method_5860(class_1297 entity) {
        if (this.isNpcHorse()) {
            if (entity instanceof class_1657) {
                return false;
            }
            return entity instanceof BaseCombatEntity;
        }
        return super.method_5860(entity);
    }

    public boolean method_5873(class_1297 entity, boolean force) {
        if (this.isNpcHorse() && this.method_31483() instanceof class_1657) {
            return false;
        }
        return super.method_5873(entity, force);
    }

    protected void method_5627(class_1297 passenger) {
        if (this.isNpcHorse() && passenger instanceof class_1657) {
            return;
        }
        if (this.isNpcHorse() && !this.method_5685().isEmpty() && passenger instanceof class_1657) {
            return;
        }
        super.method_5627(passenger);
    }

    @Override
    public void setEquipment(int level) {
        this.loadEquipmentData();
        if (equipmentData != null) {
            EquipmentLevelData levelData = equipmentData.getLevels().get(String.valueOf(level));
            if (levelData == null) {
                this.setDefaultEquipment();
                return;
            }
            this.setEquipmentFromLevelData(levelData);
            this.setEquipmentLevel(level);
        } else {
            this.setDefaultEquipment();
        }
    }

    @Override
    public int getEquipmentLevel() {
        return this.equipmentLevel;
    }

    @Override
    public void setEquipmentLevel(int equipmentLevel) {
        this.equipmentLevel = equipmentLevel;
    }

    @Override
    public void method_6732(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public UUID method_6139() {
        return this.ownerUUID;
    }

    @Override
    public void setHomePosition(class_2338 homePosition) {
        this.homePosition = homePosition;
    }

    @Override
    public class_2338 getHomePosition() {
        return this.homePosition;
    }

    @Override
    public class_1792 getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> HywItemRegistry.SCROLL_HORSE;
            case 2 -> HywItemRegistry.SCROLL_HORSE_1;
            case 3 -> HywItemRegistry.SCROLL_HORSE_2;
            case 4 -> HywItemRegistry.SCROLL_HORSE_3;
            default -> null;
        };
    }

    @Override
    public class_1309 asLivingEntity() {
        return this;
    }

    protected String getEquipmentJsonPath() {
        class_2960 entityId = class_7923.field_41177.method_10221((Object)this.method_5864());
        if (entityId == null) {
            return null;
        }
        String entityName = entityId.method_12832();
        String equipmentFile = ServerModConfig.getCurrentEquipmentFileName();
        return "hundred_years_war:hyw/npc/" + entityName + "/" + equipmentFile;
    }

    protected void loadEquipmentData() {
        String configResourcePath = this.getEquipmentJsonPath();
        if (configResourcePath == null) {
            return;
        }
        String[] parts = configResourcePath.split(":");
        if (parts.length != 2) {
            return;
        }
        String namespace = parts[0];
        String path = parts[1];
        String fullPath = "/assets/" + namespace + "/" + path;
        InputStream is = this.getClass().getResourceAsStream(fullPath);
        if (is == null) {
            return;
        }
        try (InputStream inputStream = is;
             InputStreamReader reader = new InputStreamReader(inputStream);){
            Gson gson = new Gson();
            equipmentData = (EquipmentData)gson.fromJson((Reader)reader, EquipmentData.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected EquipmentOption selectRandomItem(List<EquipmentOption> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        double totalProbability = 0.0;
        for (EquipmentOption option : options) {
            totalProbability += option.getProbability();
        }
        double randomValue = this.random.nextDouble() * totalProbability;
        double cumulativeProbability = 0.0;
        for (EquipmentOption option : options) {
            if (!(randomValue <= (cumulativeProbability += option.getProbability()))) continue;
            return option;
        }
        return null;
    }

    protected class_1799 createItemStack(EquipmentOption option) {
        if (option == null || option.getItem() == null) {
            return class_1799.field_8037;
        }
        class_2960 itemId = new class_2960(option.getItem());
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
        if (item == class_1802.field_8162) {
            System.err.println("missing\uff1a" + option.getItem());
            return class_1799.field_8037;
        }
        class_1799 itemStack = new class_1799((class_1935)item);
        if (option.getEnchantments() != null) {
            for (EnchantmentData enchantmentData : option.getEnchantments()) {
                class_2960 enchantmentId = new class_2960(enchantmentData.getEnchantment());
                class_1887 enchantment = (class_1887)class_7923.field_41176.method_10223(enchantmentId);
                if (enchantment != null) {
                    itemStack.method_7978(enchantment, enchantmentData.getLevel());
                    continue;
                }
                System.err.println("missing\uff1a" + enchantmentData.getEnchantment());
            }
        }
        return itemStack;
    }

    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        EquipmentOption horseArmorOption;
        class_1799 horseArmor;
        if (levelData.getHorseArmor() != null && !levelData.getHorseArmor().isEmpty() && !(horseArmor = this.createItemStack(horseArmorOption = this.selectRandomItem(levelData.getHorseArmor()))).method_7960() && this.field_6962 != null) {
            this.field_6962.method_5447(1, horseArmor);
            this.method_6731();
        }
    }

    protected void setDefaultEquipment() {
    }

    private boolean isHorseArmor(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        return item instanceof class_4059;
    }

    private void spawnParticles(class_1937 world, double x, double y, double z) {
        int particleCount = 40;
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (world.field_9229.method_43058() - 0.5) * 1.0;
                double offsetY = world.field_9229.method_43058() * 0.5 + 0.5;
                double offsetZ = (world.field_9229.method_43058() - 0.5) * 1.0;
                serverLevel.method_14199((class_2394)class_2398.field_11204, x, y + 0.5, z, 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    protected void method_16078() {
        if (ServerModConfig.INSTANCE.isAllowEquipmentDrop()) {
            super.method_16078();
        }
    }

    public void randomizeIfNeeded() {
        if (!this.method_37908().field_9236 && !this.hasRandomizedAppearance()) {
            class_5819 randomSource = this.method_37908().method_8409();
            class_5149[] variants = class_5149.values();
            class_5149 variant = variants[randomSource.method_43048(variants.length)];
            class_5148[] markingsArray = class_5148.values();
            class_5148 markings = markingsArray[randomSource.method_43048(markingsArray.length)];
            this.method_47873(variant);
            try {
                Method setVariantAndMarkingsMethod = class_1498.class.getDeclaredMethod("setVariantAndMarkings", class_5149.class, class_5148.class);
                setVariantAndMarkingsMethod.setAccessible(true);
                setVariantAndMarkingsMethod.invoke((Object)this, variant, markings);
            }
            catch (Exception e) {
                this.method_47873(variant);
            }
            this.method_6001(this.method_6051());
            this.setHasRandomizedAppearance(true);
        }
    }

    public boolean hasRandomizedAppearance() {
        return (Boolean)this.field_6011.method_12789(HAS_RANDOMIZED_APPEARANCE);
    }

    public void setHasRandomizedAppearance(boolean hasRandomized) {
        this.field_6011.method_12778(HAS_RANDOMIZED_APPEARANCE, (Object)hasRandomized);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.2));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0, class_1496.class));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        if (this.method_45349()) {
            this.field_6201.method_6277(9, (class_1352)new class_7688((class_1496)this));
        }
        this.method_6764();
    }
}

