/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.projectile;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.BlockBreakable;
import ydmsama.hundred_years_war.main.utils.BlockBreakHandler;
import ydmsama.hundred_years_war.main.utils.ProjectileHitUtils;

public class MangonelsBulletEntity
extends class_1665
implements BlockBreakable {
    private boolean canBreakBlocks = false;
    private float breakRadius = 1.5f;
    private float maxBreakableHardness = 3.0f;
    private int maxBreakableBlocks = 5;
    private float baseBreakProbability = 0.5f;

    public MangonelsBulletEntity(class_1299<? extends MangonelsBulletEntity> entityType, class_1309 livingEntity, class_1937 level) {
        super(entityType, livingEntity, level);
    }

    public MangonelsBulletEntity(class_1299<MangonelsBulletEntity> MangonelsBulletEntityEntityType, class_1937 level) {
        super(MangonelsBulletEntityEntityType, level);
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            class_243 hitPos = ProjectileHitUtils.getPreciseHitLocation(hitResult, (class_1676)this);
            this.method_37908().method_8537((class_1297)this, hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, 1.0f, false, class_1937.class_7867.field_40888);
            this.applyAreaDamage(hitPos);
            if (this.canBreakBlocks) {
                BlockBreakHandler.getInstance().handleBlockBreaking((class_1676)this, this.method_37908(), hitPos);
            }
            if (this.method_37908() instanceof class_3218) {
                this.sendParticlesToAllNearby((class_3218)this.method_37908(), class_2398.field_11236, hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, 1, 0.0, 0.0, 0.0, 0.1);
            }
            this.method_31472();
        }
    }

    private void applyAreaDamage(class_243 hitPos) {
        double damageRadius = 5.0;
        float damageAmount = (float)this.method_7448() * 0.5f;
        class_238 damageArea = new class_238(hitPos.field_1352 - damageRadius, hitPos.field_1351 - damageRadius, hitPos.field_1350 - damageRadius, hitPos.field_1352 + damageRadius, hitPos.field_1351 + damageRadius, hitPos.field_1350 + damageRadius);
        class_6880.class_6883 explosionDamageType = this.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42331);
        class_1282 damageSource = new class_1282((class_6880)explosionDamageType, this.method_24921(), (class_1297)this);
        for (class_1297 entity : this.method_37908().method_8335((class_1297)this, damageArea)) {
            BaseCombatEntity combatEntity;
            class_1297 class_12972;
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            if (entity == this.method_24921() || !((class_12972 = this.method_24921()) instanceof BaseCombatEntity) || !(combatEntity = (BaseCombatEntity)class_12972).isValidTarget(livingEntity)) continue;
            entity.method_5643(damageSource, damageAmount);
        }
    }

    public void method_5773() {
        super.method_5773();
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
    }

    protected class_1799 method_7445() {
        return null;
    }

    protected class_3414 method_7440() {
        return class_3417.field_14927;
    }

    public <T extends class_2394> int sendParticlesToAllNearby(class_3218 serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        class_2675 packet = new class_2675(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (class_3222 serverPlayer : serverLevel.method_18456()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (class_2596<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(class_3218 serverLevel, class_3222 serverPlayer, double x, double y, double z, class_2596<?> packet) {
        if (serverPlayer.method_37908() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.method_19538().method_1025(new class_243(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.field_13987.method_14364(packet);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBreakBlocks() {
        return this.canBreakBlocks;
    }

    @Override
    public void setCanBreakBlocks(boolean canBreak) {
        this.canBreakBlocks = canBreak;
    }

    @Override
    public float getBreakRadius() {
        return this.breakRadius;
    }

    @Override
    public float getMaxBreakableHardness() {
        return this.maxBreakableHardness;
    }

    @Override
    public int getMaxBreakableBlocks() {
        return this.maxBreakableBlocks;
    }

    @Override
    public float getBaseBreakProbability() {
        return this.baseBreakProbability;
    }
}

