/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.projectile;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.utils.ProjectileHitUtils;

public class RocketEntity
extends class_1665 {
    private static final float BURN_TIME_FACTOR = 3.0f;
    private static final float ACCELERATION_FACTOR = 0.01f;
    private static final float AW2_GRAVITY_FACTOR = 0.024525002f;
    private int rocketBurnTime = 0;
    private boolean hasFuel = false;
    private float accelerationX;
    private float accelerationY;
    private float accelerationZ;

    public RocketEntity(class_1299<? extends RocketEntity> entityType, class_1309 livingEntity, class_1937 level) {
        super(entityType, livingEntity, level);
        this.method_5875(true);
    }

    public RocketEntity(class_1299<RocketEntity> rocketEntityType, class_1937 level) {
        super(rocketEntityType, level);
        this.method_5875(true);
    }

    public void setRocketParams(float velocityX, float velocityY, float velocityZ) {
        float motionX = velocityX * 0.05f;
        float motionY = velocityY * 0.05f;
        float motionZ = velocityZ * 0.05f;
        float motionMagnitude = class_3532.method_15355((float)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        float burnTimeVariation = 0.95f + this.field_5974.method_43057() * 0.1f;
        this.rocketBurnTime = (int)(motionMagnitude * 20.0f * 3.0f * burnTimeVariation);
        boolean bl = this.hasFuel = this.rocketBurnTime > 0;
        if (motionMagnitude > 0.0f) {
            this.accelerationX = motionX / motionMagnitude * 0.01f;
            this.accelerationY = motionY / motionMagnitude * 0.01f;
            this.accelerationZ = motionZ / motionMagnitude * 0.01f;
            this.method_18800(this.accelerationX, this.accelerationY, this.accelerationZ);
        }
    }

    public void setRocketParamsFromCalculator(float velocityX, float velocityY, float velocityZ, float calculatedVelocity) {
        float motionX = velocityX * 0.05f;
        float motionY = velocityY * 0.05f;
        float motionZ = velocityZ * 0.05f;
        float motionMagnitude = class_3532.method_15355((float)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        float burnTimeVariation = 0.95f + this.field_5974.method_43057() * 0.1f;
        this.rocketBurnTime = (int)(motionMagnitude * 20.0f * 3.0f * burnTimeVariation);
        boolean bl = this.hasFuel = this.rocketBurnTime > 0;
        if (motionMagnitude > 0.0f) {
            this.accelerationX = motionX / motionMagnitude * 0.01f;
            this.accelerationY = motionY / motionMagnitude * 0.01f;
            this.accelerationZ = motionZ / motionMagnitude * 0.01f;
            this.method_18800(this.accelerationX, this.accelerationY, this.accelerationZ);
        }
    }

    public void method_5773() {
        if (!this.method_37908().field_9236) {
            if (this.hasFuel && this.rocketBurnTime > 0) {
                this.rocketBurnPhase();
            } else {
                this.gravityPhase();
            }
        }
        this.method_5875(true);
        super.method_5773();
        if (this.field_6012 > 6000) {
            this.method_31472();
        }
    }

    private void rocketBurnPhase() {
        class_243 currentMotion = this.method_18798();
        this.method_18800(currentMotion.field_1352 + (double)this.accelerationX, currentMotion.field_1351 + (double)this.accelerationY, currentMotion.field_1350 + (double)this.accelerationZ);
        --this.rocketBurnTime;
        if (this.rocketBurnTime <= 0) {
            this.hasFuel = false;
        }
        if (this.method_37908() instanceof class_3218 && this.field_6012 % 3 == 0) {
            this.sendParticlesToAllNearby((class_3218)this.method_37908(), class_2398.field_11240, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.2);
            this.sendParticlesToAllNearby((class_3218)this.method_37908(), class_2398.field_11251, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.02);
        }
    }

    private void gravityPhase() {
        class_243 currentMotion = this.method_18798();
        this.method_18800(currentMotion.field_1352, currentMotion.field_1351 - 0.024525001645088196, currentMotion.field_1350);
        if (this.method_37908() instanceof class_3218 && this.field_6012 % 3 == 0) {
            this.sendParticlesToAllNearby((class_3218)this.method_37908(), class_2398.field_11251, this.method_23317(), this.method_23318(), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.02);
        }
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            if (this.method_37908() instanceof class_3218) {
                class_243 hitPos = ProjectileHitUtils.getPreciseHitLocation(hitResult, (class_1676)this);
                this.applyRocketAreaDamage(hitPos);
                this.sendParticlesToAllNearby((class_3218)this.method_37908(), class_2398.field_11236, hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, 1, 0.5, 0.5, 0.5, 0.1);
                this.method_37908().method_43128(null, hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, class_3417.field_15152, this.method_5634(), 3.5f, 1.0f + (this.field_5974.method_43057() - 0.5f) * 0.2f);
            }
            this.method_31472();
        }
    }

    private void applyRocketAreaDamage(class_243 hitPos) {
        double damageRadius = 5.0;
        float damageAmount = (float)this.method_7448() * 0.6f;
        class_238 damageArea = new class_238(hitPos.field_1352 - damageRadius, hitPos.field_1351 - damageRadius, hitPos.field_1350 - damageRadius, hitPos.field_1352 + damageRadius, hitPos.field_1351 + damageRadius, hitPos.field_1350 + damageRadius);
        class_6880.class_6883 explosionDamageType = this.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42331);
        class_1282 damageSource = new class_1282((class_6880)explosionDamageType, this.method_24921(), (class_1297)this);
        for (class_1297 entity : this.method_37908().method_8335((class_1297)this, damageArea)) {
            float finalDamage;
            float distanceFactor;
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            if (entity == this.method_24921()) continue;
            class_1297 class_12972 = this.method_24921();
            if (class_12972 instanceof BaseCombatEntity) {
                BaseCombatEntity combatEntity = (BaseCombatEntity)class_12972;
                if (!combatEntity.isValidTarget(livingEntity)) continue;
                double distance = livingEntity.method_19538().method_1022(hitPos);
                distanceFactor = Math.max(0.3f, 1.0f - (float)(distance / damageRadius));
                finalDamage = damageAmount * distanceFactor;
                entity.method_5643(damageSource, finalDamage);
                continue;
            }
            double distance = livingEntity.method_19538().method_1022(hitPos);
            distanceFactor = Math.max(0.3f, 1.0f - (float)(distance / damageRadius));
            finalDamage = damageAmount * distanceFactor;
            entity.method_5643(damageSource, finalDamage);
        }
    }

    protected class_1799 method_7445() {
        return class_1799.field_8037;
    }

    protected class_3414 method_7440() {
        return class_3417.field_15152;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("RocketBurnTime", this.rocketBurnTime);
        compound.method_10556("HasFuel", this.hasFuel);
        compound.method_10548("AccelerationX", this.accelerationX);
        compound.method_10548("AccelerationY", this.accelerationY);
        compound.method_10548("AccelerationZ", this.accelerationZ);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.rocketBurnTime = compound.method_10550("RocketBurnTime");
        this.hasFuel = compound.method_10577("HasFuel");
        this.accelerationX = compound.method_10583("AccelerationX");
        this.accelerationY = compound.method_10583("AccelerationY");
        this.accelerationZ = compound.method_10583("AccelerationZ");
    }

    public boolean isInPropulsionPhase() {
        return this.hasFuel && this.rocketBurnTime > 0;
    }

    public int getRemainingBurnTime() {
        return this.rocketBurnTime;
    }

    public <T extends class_2394> int sendParticlesToAllNearby(class_3218 serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        class_2675 packet = new class_2675(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (class_3222 serverPlayer : serverLevel.method_18456()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (class_2596<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(class_3218 serverLevel, class_3222 serverPlayer, double x, double y, double z, class_2596<?> packet) {
        if (serverPlayer.method_37908() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.method_19538().method_1025(new class_243(x, y, z));
        if (distanceSquared < 65536.0) {
            serverPlayer.field_13987.method_14364(packet);
            return true;
        }
        return false;
    }
}

