/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.navigation;

import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_9;
import ydmsama.hundred_years_war.main.entity.navigation.BaseCombatNavigation;

public class LadderAwareMoveControl
extends class_1335 {
    private static final double LADDER_CLIMB_SPEED = 0.2;
    private static final double LADDER_DESCEND_SPEED = 0.3;
    private static final double HORIZONTAL_MOVE_THRESHOLD = 0.3;

    public LadderAwareMoveControl(class_1308 mob) {
        super(mob);
    }

    public void method_6240() {
        if (this.isStandingOnPlatform() || this.isAtLadderTopNearPlatform()) {
            super.method_6240();
        } else if (this.isOnLadder()) {
            this.handleLadderMovement();
        } else {
            super.method_6240();
        }
    }

    private void handleLadderMovement() {
        class_9 nextNode;
        class_11 path;
        if (this.field_6374 != class_1335.class_1336.field_6378) {
            if (this.hasActiveMovementTarget()) {
                this.field_6374 = class_1335.class_1336.field_6378;
            } else {
                if (this.isStandingOnPlatform() || this.isAtLadderTopNearPlatform()) {
                    super.method_6240();
                    return;
                }
                this.field_6371.method_18799(this.field_6371.method_18798().method_18805(1.0, 0.0, 1.0));
                return;
            }
        }
        if ((path = this.field_6371.method_5942().method_6345()) == null || path.method_46()) {
            if (this.tryCreateNewPath()) {
                path = this.field_6371.method_5942().method_6345();
            } else {
                this.stopOnLadder();
                return;
            }
        }
        if ((nextNode = this.getNextPathNode(path)) == null) {
            this.stopOnLadder();
            return;
        }
        class_243 nodePos = new class_243((double)nextNode.field_40 + 0.5, (double)nextNode.field_39, (double)nextNode.field_38 + 0.5);
        if (this.hasReachedPlatformTarget(nodePos)) {
            this.field_6371.method_5942().method_6340();
            return;
        }
        class_243 targetPos = new class_243((double)nextNode.field_40 + 0.5, (double)nextNode.field_39, (double)nextNode.field_38 + 0.5);
        class_243 currentPos = this.field_6371.method_19538();
        double dx = targetPos.field_1352 - currentPos.field_1352;
        double dy = targetPos.field_1351 - currentPos.field_1351;
        double dz = targetPos.field_1350 - currentPos.field_1350;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        if (horizontalDist > 0.1) {
            this.field_6371.method_36456(this.method_6238(this.field_6371.method_36454(), (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f, 90.0f));
        }
        class_243 motion = class_243.field_1353;
        if (Math.abs(dy) > 0.05) {
            class_2338 targetBlockPos = new class_2338((int)targetPos.field_1352, (int)targetPos.field_1351, (int)targetPos.field_1350);
            boolean isPlatformTarget = this.isAdjacentPlatform(targetBlockPos);
            if (dy > 0.0) {
                double verticalSpeed = isPlatformTarget && dy < 1.5 ? 0.30000000000000004 : 0.2;
                double horizontalSpeed = Math.min(horizontalDist, 0.1) * this.field_6372 * 0.3;
                motion = horizontalDist > 0.01 ? new class_243(dx / horizontalDist * horizontalSpeed, verticalSpeed, dz / horizontalDist * horizontalSpeed) : new class_243(0.0, verticalSpeed, 0.0);
            } else {
                double verticalSpeed = -0.3;
                if (this.isTargetOnLadderPath(targetBlockPos)) {
                    double safeHorizontalSpeed = Math.min(horizontalDist, 0.05) * 0.5;
                    motion = horizontalDist > 0.002 ? new class_243(dx / horizontalDist * safeHorizontalSpeed, verticalSpeed, dz / horizontalDist * safeHorizontalSpeed) : new class_243(0.0, verticalSpeed, 0.0);
                } else {
                    double horizontalSpeed = Math.min(horizontalDist, 0.08) * this.field_6372 * 0.2;
                    motion = new class_243(dx / horizontalDist * horizontalSpeed, verticalSpeed, dz / horizontalDist * horizontalSpeed);
                }
            }
        } else if (horizontalDist > 0.1) {
            class_2338 targetBlockPos = new class_2338((int)targetPos.field_1352, (int)targetPos.field_1351, (int)targetPos.field_1350);
            if (this.isAdjacentPlatform(targetBlockPos)) {
                double moveSpeed = this.field_6372 * 0.2;
                double jumpHeight = 0.1;
                motion = new class_243(dx / horizontalDist * moveSpeed, jumpHeight, dz / horizontalDist * moveSpeed);
            } else {
                double moveSpeed = this.field_6372 * 0.1;
                motion = new class_243(dx / horizontalDist * moveSpeed, 0.0, dz / horizontalDist * moveSpeed);
            }
        }
        this.field_6371.method_18799(motion);
        this.field_6371.method_5930(0.0f);
        this.field_6371.method_5938(0.0f);
        this.field_6371.method_6100(false);
        this.field_6374 = class_1335.class_1336.field_6377;
    }

    private void stopOnLadder() {
        this.field_6371.method_18800(0.0, 0.0, 0.0);
        this.field_6371.method_5930(0.0f);
        this.field_6371.method_5938(0.0f);
        this.field_6371.method_6100(false);
    }

    private boolean isOnLadder() {
        if (this.isOnSafeGround()) {
            return false;
        }
        if (this.isStandingOnPlatform()) {
            return false;
        }
        if (this.isAtLadderTopNearPlatform()) {
            return false;
        }
        class_2338 pos = this.field_6371.method_24515();
        boolean hasClimbableBlock = this.field_6371.method_37908().method_8320(pos).method_26164(class_3481.field_22414) || this.field_6371.method_37908().method_8320(pos.method_10074()).method_26164(class_3481.field_22414);
        return hasClimbableBlock;
    }

    private class_9 getNextPathNode(class_11 path) {
        int nextIndex = path.method_39();
        if (nextIndex < path.method_38()) {
            return path.method_40(nextIndex);
        }
        if (nextIndex > 0 && nextIndex - 1 < path.method_38()) {
            return path.method_40(nextIndex - 1);
        }
        return null;
    }

    private boolean isAdjacentPlatform(class_2338 targetPos) {
        class_2338 currentPos = this.field_6371.method_24515();
        if (Math.abs(targetPos.method_10264() - currentPos.method_10264()) <= 2) {
            int dx = Math.abs(targetPos.method_10263() - currentPos.method_10263());
            int dz = Math.abs(targetPos.method_10260() - currentPos.method_10260());
            if (dx <= 1 && dz == 0 || dx == 0 && dz <= 1) {
                return this.field_6371.method_37908().method_8320(targetPos).method_26215() && this.field_6371.method_37908().method_8320(targetPos.method_10074()).method_26216((class_1922)this.field_6371.method_37908(), targetPos.method_10074());
            }
        }
        return false;
    }

    private boolean isStandingOnPlatform() {
        class_2338 currentPos = this.field_6371.method_24515();
        class_2338 belowPos = currentPos.method_10074();
        boolean isOnSolidGround = this.field_6371.method_37908().method_8320(belowPos).method_26216((class_1922)this.field_6371.method_37908(), belowPos);
        boolean hasHeadroom = this.field_6371.method_37908().method_8320(currentPos.method_10084()).method_26215();
        class_243 entityPos = this.field_6371.method_19538();
        double floorY = (double)belowPos.method_10264() + 1.0;
        boolean isNearGround = Math.abs(entityPos.field_1351 - floorY) < 0.3;
        return isOnSolidGround && hasHeadroom && isNearGround;
    }

    private boolean isAtLadderTopNearPlatform() {
        class_2350[] directions;
        boolean noLadderAbove;
        class_2338 currentPos = this.field_6371.method_24515();
        boolean hasLadderBelow = this.field_6371.method_37908().method_8320(currentPos).method_26164(class_3481.field_22414) || this.field_6371.method_37908().method_8320(currentPos.method_10074()).method_26164(class_3481.field_22414);
        boolean bl = noLadderAbove = !this.field_6371.method_37908().method_8320(currentPos.method_10084()).method_26164(class_3481.field_22414);
        if (!hasLadderBelow || !noLadderAbove) {
            return false;
        }
        for (class_2350 dir : directions = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            class_2338 adjacentPos = currentPos.method_10093(dir);
            if (this.isPlatformAccessible(adjacentPos)) {
                return true;
            }
            class_2338 adjacentAbove = adjacentPos.method_10084();
            if (!this.isPlatformAccessible(adjacentAbove)) continue;
            return true;
        }
        return false;
    }

    private boolean isPlatformAccessible(class_2338 pos) {
        boolean isSolidBlock = this.field_6371.method_37908().method_8320(pos).method_26216((class_1922)this.field_6371.method_37908(), pos);
        boolean hasSpace1 = this.field_6371.method_37908().method_8320(pos.method_10084()).method_26215();
        boolean hasSpace2 = this.field_6371.method_37908().method_8320(pos.method_10086(2)).method_26215();
        return isSolidBlock && hasSpace1 && hasSpace2;
    }

    private boolean isTargetOnLadderPath(class_2338 targetPos) {
        if (this.field_6371.method_37908().method_8320(targetPos).method_26164(class_3481.field_22414)) {
            return true;
        }
        if (this.field_6371.method_37908().method_8320(targetPos.method_10074()).method_26164(class_3481.field_22414)) {
            return true;
        }
        class_243 currentPos = this.field_6371.method_19538();
        int currentY = (int)currentPos.field_1351;
        int targetY = targetPos.method_10264();
        if (targetPos.method_10263() == (int)currentPos.field_1352 && targetPos.method_10260() == (int)currentPos.field_1350) {
            int minY = Math.min(currentY, targetY);
            int maxY = Math.max(currentY, targetY);
            for (int y = minY; y <= maxY; ++y) {
                class_2338 checkPos = new class_2338(targetPos.method_10263(), y, targetPos.method_10260());
                if (this.field_6371.method_37908().method_8320(checkPos).method_26164(class_3481.field_22414)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasReachedPlatformTarget(class_243 targetPos) {
        class_243 currentPos = this.field_6371.method_19538();
        class_2338 targetBlockPos = new class_2338((int)targetPos.field_1352, (int)targetPos.field_1351, (int)targetPos.field_1350);
        if (!this.isAdjacentPlatform(targetBlockPos)) {
            return false;
        }
        double horizontalDist = Math.sqrt(Math.pow(currentPos.field_1352 - targetPos.field_1352, 2.0) + Math.pow(currentPos.field_1350 - targetPos.field_1350, 2.0));
        double verticalDist = Math.abs(currentPos.field_1351 - targetPos.field_1351);
        boolean isWithinRange = horizontalDist < 0.6 && verticalDist < 0.5;
        boolean isOnSolidGround = this.field_6371.method_37908().method_8320(this.field_6371.method_24515().method_10074()).method_26216((class_1922)this.field_6371.method_37908(), this.field_6371.method_24515().method_10074());
        return isWithinRange && isOnSolidGround;
    }

    private boolean hasActiveMovementTarget() {
        class_11 path = this.field_6371.method_5942().method_6345();
        if (path != null && !path.method_46()) {
            return true;
        }
        return this.field_6370 != 0.0 || this.field_6369 != 0.0 || this.field_6367 != 0.0;
    }

    private boolean tryCreateNewPath() {
        class_1408 navigation = this.field_6371.method_5942();
        if (!(navigation instanceof BaseCombatNavigation)) {
            return this.tryBasicPathRecreation();
        }
        BaseCombatNavigation combatNav = (BaseCombatNavigation)navigation;
        if (this.field_6370 != 0.0 || this.field_6369 != 0.0 || this.field_6367 != 0.0) {
            return combatNav.method_6337(this.field_6370, this.field_6369, this.field_6367, this.field_6372);
        }
        if (navigation.method_6355() != null) {
            class_2338 targetPos = navigation.method_6355();
            return combatNav.method_6337(targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260(), this.field_6372);
        }
        if (this.field_6371.method_5968() != null) {
            return combatNav.method_6335((class_1297)this.field_6371.method_5968(), this.field_6372);
        }
        return false;
    }

    private boolean tryBasicPathRecreation() {
        class_1408 navigation = this.field_6371.method_5942();
        if (this.field_6370 != 0.0 || this.field_6369 != 0.0 || this.field_6367 != 0.0) {
            return navigation.method_6337(this.field_6370, this.field_6369, this.field_6367, this.field_6372);
        }
        if (this.field_6371.method_5968() != null) {
            return navigation.method_6335((class_1297)this.field_6371.method_5968(), this.field_6372);
        }
        return false;
    }

    protected float method_6238(float current, float target, float maxDelta) {
        float result;
        float delta = class_3532.method_15393((float)(target - current));
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (delta < -maxDelta) {
            delta = -maxDelta;
        }
        if ((result = current + delta) < 0.0f) {
            result += 360.0f;
        } else if (result > 360.0f) {
            result -= 360.0f;
        }
        return result;
    }

    private boolean isOnSafeGround() {
        class_2350[] directions;
        class_2338 currentPos = this.field_6371.method_24515();
        class_2338 belowPos = currentPos.method_10074();
        if (!this.field_6371.method_24828()) {
            return false;
        }
        if (!this.field_6371.method_37908().method_8320(belowPos).method_26216((class_1922)this.field_6371.method_37908(), belowPos)) {
            return false;
        }
        if (this.field_6371.method_37908().method_8320(currentPos).method_26164(class_3481.field_22414) || this.field_6371.method_37908().method_8320(belowPos).method_26164(class_3481.field_22414)) {
            return false;
        }
        for (class_2350 dir : directions = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            for (int i = 1; i <= 3; ++i) {
                class_2338 checkPos = currentPos.method_10079(dir, i);
                if (!this.field_6371.method_37908().method_8320(checkPos).method_26164(class_3481.field_22414) && !this.field_6371.method_37908().method_8320(checkPos.method_10074()).method_26164(class_3481.field_22414) && !this.field_6371.method_37908().method_8320(checkPos.method_10084()).method_26164(class_3481.field_22414)) continue;
                return false;
            }
        }
        class_243 entityPos = this.field_6371.method_19538();
        double expectedY = (double)belowPos.method_10264() + 1.0;
        return !(Math.abs(entityPos.field_1351 - expectedY) > 0.1);
    }
}

