/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.server.MinecraftServer;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationInventoryScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.network.WorkstationOpenRequest;
import ydmsama.hundred_years_war.main.network.packets.BombardPositionPacket;
import ydmsama.hundred_years_war.main.network.packets.BreedingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.BuildCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.ClearFollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.ClearSelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAddEntityPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAttackPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffFollowPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffMovePacket;
import ydmsama.hundred_years_war.main.network.packets.CraftingRecipeUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.CreativeSettingsSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.CreativeSettingsUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.FarmingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.FishingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.FollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.FreecamTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.LumberWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.MiningWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.MoveAttackCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.MoveCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationAckPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentConfigUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.SelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.SiegeModeTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.SquadCreatePacket;
import ydmsama.hundred_years_war.main.network.packets.SquadSelectPacket;
import ydmsama.hundred_years_war.main.network.packets.TargetUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamJoinRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamLeaveRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamListRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamManageRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.TransportActionPacket;
import ydmsama.hundred_years_war.main.network.packets.TransportDataUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.UnbindTransportOrderPacket;
import ydmsama.hundred_years_war.main.network.packets.UnloadPassengersPacket;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.ServerManager;

public class ServerPacketHandler {
    private static final Map<UUID, WorkstationOpenRequest> pendingRequests = new ConcurrentHashMap<UUID, WorkstationOpenRequest>();
    private static final ScheduledExecutorService cleanupExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "WorkstationRequestCleanup");
        t.setDaemon(true);
        return t;
    });

    public static void registerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RelationRequestPacket.RELATION_REQUEST_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            RelationRequestPacket packet = RelationRequestPacket.decode(buf);
            server.execute(() -> RelationRequestPacket.handle(player));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RelationUpdatePacket.RELATION_UPDATE_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            RelationUpdatePacket packet = RelationUpdatePacket.decode(buf);
            server.execute(() -> RelationUpdatePacket.handleUpdate(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamInfoRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamInfoRequestPacket packet = TeamInfoRequestPacket.decode(buf);
            server.execute(() -> TeamInfoRequestPacket.handle(player));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamCreateRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamCreateRequestPacket packet = TeamCreateRequestPacket.decode(buf);
            server.execute(() -> TeamCreateRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamJoinRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamJoinRequestPacket packet = TeamJoinRequestPacket.decode(buf);
            server.execute(() -> TeamJoinRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamLeaveRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamLeaveRequestPacket packet = TeamLeaveRequestPacket.decode(buf);
            server.execute(() -> TeamLeaveRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamManageRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamManageRequestPacket packet = TeamManageRequestPacket.decode(buf);
            server.execute(() -> TeamManageRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SelectionPacket.ID, (server, player, handler, buf, responseSender) -> {
            SelectionPacket packet = SelectionPacket.decode(buf);
            server.execute(() -> SelectionPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CommandPacket.ID, (server, player, handler, buf, responseSender) -> {
            CommandPacket packet = CommandPacket.decode(buf);
            server.execute(() -> CommandPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MoveCommandPacket.ID, (server, player, handler, buf, responseSender) -> {
            MoveCommandPacket packet = MoveCommandPacket.decode(buf);
            server.execute(() -> MoveCommandPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MoveAttackCommandPacket.ID, (server, player, handler, buf, responseSender) -> {
            MoveAttackCommandPacket packet = MoveAttackCommandPacket.decode(buf);
            server.execute(() -> MoveAttackCommandPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TargetUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            TargetUpdatePacket packet = TargetUpdatePacket.decode(buf);
            server.execute(() -> TargetUpdatePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BuildCommandPacket.ID, (server, player, handler, buf, responseSender) -> {
            BuildCommandPacket packet = BuildCommandPacket.decode(buf);
            server.execute(() -> BuildCommandPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PatrolPointPacket.ID, (server, player, handler, buf, responseSender) -> {
            PatrolPointPacket packet = PatrolPointPacket.decode(buf);
            server.execute(() -> PatrolPointPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FollowTargetPacket.ID, (server, player, handler, buf, responseSender) -> {
            FollowTargetPacket packet = FollowTargetPacket.decode(buf);
            server.execute(() -> FollowTargetPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PatrolPointsRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            PatrolPointsRequestPacket packet = PatrolPointsRequestPacket.decode(buf);
            server.execute(() -> PatrolPointsRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SquadCreatePacket.ID, (server, player, handler, buf, responseSender) -> {
            SquadCreatePacket packet = SquadCreatePacket.decode(buf);
            server.execute(() -> SquadCreatePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SquadSelectPacket.ID, (server, player, handler, buf, responseSender) -> {
            SquadSelectPacket packet = SquadSelectPacket.decode(buf);
            server.execute(() -> SquadSelectPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CreativeSettingsUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            CreativeSettingsUpdatePacket packet = CreativeSettingsUpdatePacket.decode(buf);
            server.execute(() -> {
                CreativeSettingsUpdatePacket.handle(player, packet);
                ServerPacketHandler.sendCreativeSettingsSync(player);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamRelationRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamRelationRequestPacket packet = TeamRelationRequestPacket.decode(buf);
            server.execute(() -> TeamRelationRequestPacket.handle(player, packet.getTeamUUID()));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamRelationUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamRelationUpdatePacket packet = TeamRelationUpdatePacket.decode(buf);
            server.execute(() -> TeamRelationUpdatePacket.handleUpdate(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CommandStaffAddEntityPacket.ID, (server, player, handler, buf, responseSender) -> {
            CommandStaffAddEntityPacket packet = CommandStaffAddEntityPacket.decode(buf);
            server.execute(() -> CommandStaffAddEntityPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CommandStaffMovePacket.ID, (server, player, handler, buf, responseSender) -> {
            CommandStaffMovePacket packet = CommandStaffMovePacket.decode(buf);
            server.execute(() -> CommandStaffMovePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CommandStaffFollowPacket.ID, (server, player, handler, buf, responseSender) -> {
            CommandStaffFollowPacket packet = CommandStaffFollowPacket.decode(buf);
            server.execute(() -> CommandStaffFollowPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CommandStaffAttackPacket.ID, (server, player, handler, buf, responseSender) -> {
            CommandStaffAttackPacket packet = CommandStaffAttackPacket.decode(buf);
            server.execute(() -> CommandStaffAttackPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamListRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamListRequestPacket packet = TeamListRequestPacket.decode(buf);
            server.execute(() -> TeamListRequestPacket.handle(player));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamMembersRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamMembersRequestPacket packet = TeamMembersRequestPacket.decode(buf);
            server.execute(() -> TeamMembersRequestPacket.handle(player, packet.getTeamUUID()));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamApplicationsRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamApplicationsRequestPacket packet = TeamApplicationsRequestPacket.decode(buf);
            server.execute(() -> TeamApplicationsRequestPacket.handle(player));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SiegeModeTogglePacket.ID, (server, player, handler, buf, responseSender) -> {
            SiegeModeTogglePacket packet = SiegeModeTogglePacket.decode(buf);
            server.execute(() -> SiegeModeTogglePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BombardPositionPacket.ID, (server, player, handler, buf, responseSender) -> {
            BombardPositionPacket packet = BombardPositionPacket.decode(buf);
            server.execute(() -> BombardPositionPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)UnloadPassengersPacket.ID, (server, player, handler, buf, responseSender) -> {
            UnloadPassengersPacket packet = UnloadPassengersPacket.decode(buf);
            server.execute(() -> UnloadPassengersPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RecruitmentDataRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            RecruitmentDataRequestPacket packet = RecruitmentDataRequestPacket.decode(buf);
            server.execute(() -> RecruitmentDataRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RecruitmentConfigUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            RecruitmentConfigUpdatePacket packet = RecruitmentConfigUpdatePacket.decode(buf);
            server.execute(() -> RecruitmentConfigUpdatePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FreecamTogglePacket.ID, (server, player, handler, buf, responseSender) -> {
            FreecamTogglePacket packet = FreecamTogglePacket.decode(buf);
            server.execute(() -> FreecamTogglePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)LumberWorkstationRangePacket.ID, (server, player, handler, buf, responseSender) -> {
            LumberWorkstationRangePacket packet = LumberWorkstationRangePacket.decode(buf);
            server.execute(() -> LumberWorkstationRangePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FarmingWorkstationRangePacket.ID, (server, player, handler, buf, responseSender) -> {
            FarmingWorkstationRangePacket packet = FarmingWorkstationRangePacket.decode(buf);
            server.execute(() -> FarmingWorkstationRangePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MiningWorkstationRangePacket.ID, (server, player, handler, buf, responseSender) -> {
            MiningWorkstationRangePacket packet = MiningWorkstationRangePacket.decode(buf);
            server.execute(() -> MiningWorkstationRangePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BreedingWorkstationRangePacket.ID, (server, player, handler, buf, responseSender) -> {
            BreedingWorkstationRangePacket packet = BreedingWorkstationRangePacket.decode(buf);
            server.execute(() -> BreedingWorkstationRangePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FishingWorkstationRangePacket.ID, (server, player, handler, buf, responseSender) -> {
            FishingWorkstationRangePacket packet = FishingWorkstationRangePacket.decode(buf);
            server.execute(() -> FishingWorkstationRangePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TransportDataUpdatePacket.ID, (server, player, handler, buf, responseSender) -> TransportDataUpdatePacket.handle(player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "unbind_transport_order"), (server, player, handler, buf, responseSender) -> server.execute(() -> UnbindTransportOrderPacket.handle(player)));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CraftingRecipeUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            CraftingRecipeUpdatePacket packet = CraftingRecipeUpdatePacket.decode(buf);
            server.execute(() -> CraftingRecipeUpdatePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "transport_action"), (server, player, handler, buf, responseSender) -> {
            boolean isMainHand = buf.readBoolean();
            server.execute(() -> TransportActionPacket.handle(player, isMainHand));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "open_crafting_inventory"), (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            server.execute(() -> {
                class_1937 world = player.method_37908();
                class_2586 blockEntity = world.method_8321(pos);
                if (blockEntity instanceof CraftingWorkstationBlockEntity) {
                    final CraftingWorkstationBlockEntity craftingWorkstation = (CraftingWorkstationBlockEntity)blockEntity;
                    class_3908 factory = new class_3908(){

                        public class_2561 method_5476() {
                            return class_2561.method_43471((String)"block.hundred_years_war.crafting_workstation");
                        }

                        public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                            return new CraftingWorkstationInventoryScreenHandler(syncId, playerInventory, craftingWorkstation);
                        }
                    };
                    player.method_17355(factory);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "open_crafting_recipe"), (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            server.execute(() -> CraftingWorkstation.openRecipeScreen(player, pos));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)OpenWorkstationAckPacket.ID, (server, player, handler, buf, responseSender) -> {
            OpenWorkstationAckPacket packet = OpenWorkstationAckPacket.decode(buf);
            server.execute(() -> ServerPacketHandler.handleWorkstationAck(packet));
        });
    }

    public static void sendCreativeSettingsSync(class_3222 player) {
        CreativeModeSettings.Settings settings = CreativeModeSettings.getSettings((class_1657)player);
        CreativeSettingsSyncPacket packet = new CreativeSettingsSyncPacket(settings.isSummonFriendly(), settings.isControlAllUnits());
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CreativeSettingsSyncPacket.ID, (class_2540)buf);
    }

    public static void sendClearFollowTargetToAll(UUID entityUUID) {
        MinecraftServer server = ServerManager.getServer();
        if (server != null) {
            ClearFollowTargetPacket packet = new ClearFollowTargetPacket(entityUUID);
            class_2540 buf = PacketByteBufs.create();
            packet.encode(buf);
            for (class_3222 player : server.method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)ClearFollowTargetPacket.ID, (class_2540)buf);
            }
        }
    }

    public static void sendClearSelectionToAll(UUID entityUUID) {
        MinecraftServer server = ServerManager.getServer();
        if (server != null) {
            ClearSelectionPacket packet = new ClearSelectionPacket(entityUUID);
            class_2540 buf = PacketByteBufs.create();
            packet.encode(buf);
            for (class_3222 player : server.method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)ClearSelectionPacket.ID, (class_2540)buf);
            }
        }
    }

    public static void sendOpenWorkstationSync(class_3222 player, class_2338 pos, OpenWorkstationSyncPacket.WorkstationType type) {
        WorkstationOpenRequest request = new WorkstationOpenRequest(player, pos, type);
        pendingRequests.put(request.getRequestId(), request);
        OpenWorkstationSyncPacket packet = new OpenWorkstationSyncPacket(request.getRequestId(), pos, type);
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)OpenWorkstationSyncPacket.ID, (class_2540)buf);
        cleanupExecutor.schedule(() -> {
            WorkstationOpenRequest req = pendingRequests.get(request.getRequestId());
            if (req != null && req.isExpired()) {
                pendingRequests.remove(request.getRequestId());
            }
        }, 10L, TimeUnit.SECONDS);
    }

    private static void handleWorkstationAck(OpenWorkstationAckPacket packet) {
        UUID requestId = packet.getRequestId();
        WorkstationOpenRequest request = pendingRequests.remove(requestId);
        if (request == null || request.isExpired()) {
            return;
        }
        ServerPacketHandler.openWorkstationMenu(request.getPlayer(), request.getPos(), request.getType());
    }

    private static void openWorkstationMenu(class_3222 player, class_2338 pos, OpenWorkstationSyncPacket.WorkstationType type) {
        class_1937 level = player.method_37908();
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity == null) {
            return;
        }
        class_3908 menuProvider = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case OpenWorkstationSyncPacket.WorkstationType.FARMING -> ServerPacketHandler.createMenuProvider("hundred_years_war.farming_workstation", (syncId, inventory, p) -> new FarmingWorkstationScreenHandler(syncId, inventory, (FarmingWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.MINING -> ServerPacketHandler.createMenuProvider("hundred_years_war.mining_workstation", (syncId, inventory, p) -> new MiningWorkstationScreenHandler(syncId, inventory, (MiningWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.TRANSPORT -> ServerPacketHandler.createMenuProvider("hundred_years_war.transport_workstation", (syncId, inventory, p) -> new TransportWorkstationScreenHandler(syncId, inventory, (TransportWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.FISHING -> ServerPacketHandler.createMenuProvider("hundred_years_war.fishing_workstation", (syncId, inventory, p) -> new FishingWorkstationScreenHandler(syncId, inventory, (FishingWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.LUMBER -> ServerPacketHandler.createMenuProvider("hundred_years_war.lumber_workstation", (syncId, inventory, p) -> new LumberWorkstationScreenHandler(syncId, inventory, (LumberWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.CRAFTING -> ServerPacketHandler.createMenuProvider("hundred_years_war.crafting_workstation", (syncId, inventory, p) -> new CraftingWorkstationScreenHandler(syncId, inventory, (CraftingWorkstationBlockEntity)blockEntity));
            case OpenWorkstationSyncPacket.WorkstationType.BREEDING -> ServerPacketHandler.createMenuProvider("hundred_years_war.breeding_workstation", (syncId, inventory, p) -> new BreedingWorkstationScreenHandler(syncId, inventory, (BreedingWorkstationBlockEntity)blockEntity));
        };
        player.method_17355(menuProvider);
    }

    private static class_3908 createMenuProvider(final String translationKey, final MenuFactory factory) {
        return new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43471((String)translationKey);
            }

            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                return factory.create(syncId, playerInventory, player);
            }
        };
    }

    @FunctionalInterface
    private static interface MenuFactory {
        public class_1703 create(int var1, class_1661 var2, class_1657 var3);
    }
}

