/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;

public class CommandStaffAddEntityPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "command_staff_add_entity_packet");
    private final UUID staffUUID;
    private final UUID entityUUID;
    private final boolean isAdding;

    public CommandStaffAddEntityPacket(UUID staffUUID, UUID entityUUID, boolean isAdding) {
        this.staffUUID = staffUUID;
        this.entityUUID = entityUUID;
        this.isAdding = isAdding;
    }

    public CommandStaffAddEntityPacket(class_2540 buf) {
        this.staffUUID = buf.method_10790();
        this.entityUUID = buf.method_10790();
        this.isAdding = buf.readBoolean();
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.staffUUID);
        buf.method_10797(this.entityUUID);
        buf.writeBoolean(this.isAdding);
    }

    public static CommandStaffAddEntityPacket decode(class_2540 buf) {
        return new CommandStaffAddEntityPacket(buf);
    }

    public static void handle(class_3222 player, CommandStaffAddEntityPacket packet) {
        class_1799 itemStack;
        class_3218 world = (class_3218)((EntityAccessor)player).getLevel();
        class_1297 entity = world.method_14190(packet.entityUUID);
        if (entity instanceof BaseCombatEntity && !(itemStack = CommandStaffAddEntityPacket.findCommandStaffItem(player, packet.staffUUID)).method_7960()) {
            class_2487 nbt = itemStack.method_7948();
            if (!nbt.method_25928("ItemUUID")) {
                nbt.method_25927("ItemUUID", UUID.randomUUID());
            }
            class_2499 uuidList = nbt.method_10573("TeamEntityUUIDs", 9) ? nbt.method_10554("TeamEntityUUIDs", 8) : new class_2499();
            String entityUUIDString = packet.entityUUID.toString();
            boolean found = false;
            for (int i = 0; i < uuidList.size(); ++i) {
                if (!uuidList.method_10608(i).equals(entityUUIDString)) continue;
                found = true;
                if (packet.isAdding) break;
                uuidList.method_10536(i);
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.command_staff.entity_removed"), true);
                break;
            }
            if (packet.isAdding && !found) {
                uuidList.add((Object)class_2519.method_23256((String)entityUUIDString));
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.command_staff.entity_added"), true);
            }
            nbt.method_10566("TeamEntityUUIDs", (class_2520)uuidList);
            itemStack.method_7980(nbt);
        }
    }

    private static class_1799 findCommandStaffItem(class_3222 player, UUID staffUUID) {
        class_2487 tag;
        class_1799 mainHandItem = player.method_6047();
        if (!mainHandItem.method_7960() && mainHandItem.method_7909() instanceof CommandStaffItem && (tag = mainHandItem.method_7969()) != null && tag.method_25928("ItemUUID") && tag.method_25926("ItemUUID").equals(staffUUID)) {
            return mainHandItem;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_2487 tag2;
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !(stack.method_7909() instanceof CommandStaffItem) || (tag2 = stack.method_7969()) == null || !tag2.method_25928("ItemUUID") || !tag2.method_25926("ItemUUID").equals(staffUUID)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }
}

