/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.network.packets.SquadPacket;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class SquadSelectPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "squad_select_packet");
    private final int number;

    public SquadSelectPacket(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public static SquadSelectPacket decode(class_2540 buf) {
        int number = buf.readInt();
        return new SquadSelectPacket(number);
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.number);
    }

    public static void handle(class_3222 player, SquadSelectPacket packet) {
        int number = packet.getNumber();
        List playerSquads = SelectionSystem.getSquads().computeIfAbsent(player.method_5667(), k -> new ArrayList());
        if (number >= 0 && number < playerSquads.size() && playerSquads.get(number) != null) {
            SelectionSystem.Squad squad = (SelectionSystem.Squad)playerSquads.get(number);
            List<UUID> entityUUIDs = squad.getEntityUUIDs();
            ArrayList<BaseCombatEntity> selectedEntities = new ArrayList<BaseCombatEntity>();
            for (UUID uuid : entityUUIDs) {
                class_3218 serverWorld = (class_3218)((EntityAccessor)player).getLevel();
                class_1297 entity = serverWorld.method_14190(uuid);
                if (!(entity instanceof BaseCombatEntity)) continue;
                selectedEntities.add((BaseCombatEntity)entity);
            }
            SelectionSystem.getSelections().put(player, new SelectionSystem.Selection(selectedEntities));
            SquadPacket responsePacket = new SquadPacket(entityUUIDs);
            class_2540 responseBuf = new class_2540(Unpooled.buffer());
            responsePacket.encode(responseBuf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)SquadPacket.ID, (class_2540)responseBuf);
        }
    }
}

