/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.TargetAttackGoal;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class TargetUpdatePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "target_update_packet");
    private final UUID targetUUID;
    private final boolean queueMode;

    public TargetUpdatePacket(UUID targetUUID, boolean queueMode) {
        this.targetUUID = targetUUID;
        this.queueMode = queueMode;
    }

    public TargetUpdatePacket(class_2540 buf) {
        this.targetUUID = buf.method_10790();
        this.queueMode = buf.readBoolean();
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.targetUUID);
        buf.writeBoolean(this.queueMode);
    }

    public static TargetUpdatePacket decode(class_2540 buf) {
        return new TargetUpdatePacket(buf);
    }

    public static void handle(class_3222 player, TargetUpdatePacket packet) {
        class_3218 world = (class_3218)((EntityAccessor)player).getLevel();
        class_1297 targetEntity = world.method_14190(packet.targetUUID);
        if (targetEntity instanceof class_1309) {
            for (BaseCombatEntity entity : SelectionSystem.getSelection(player).getEntities()) {
                TargetAttackGoal targetAttackGoal = new TargetAttackGoal(entity, 1.0, entity.getAttackReach(), (class_1309)targetEntity);
                if (!packet.queueMode) {
                    entity.clearCommandedGoals();
                }
                entity.clearPatrolPoints();
                entity.addCustomGoal(1, targetAttackGoal);
            }
        }
    }
}

