/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1676;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import ydmsama.hundred_years_war.main.entity.entities.projectile.BlockBreakable;

public class BlockBreakHandler {
    private static BlockBreakHandler instance;
    private final Random random = new Random();

    private BlockBreakHandler() {
    }

    public static BlockBreakHandler getInstance() {
        if (instance == null) {
            instance = new BlockBreakHandler();
        }
        return instance;
    }

    public void handleBlockBreaking(class_1676 projectile, class_1937 level, class_243 pos) {
        if (!(projectile instanceof BlockBreakable)) {
            return;
        }
        BlockBreakable breakable = (BlockBreakable)projectile;
        if (!breakable.canBreakBlocks()) {
            return;
        }
        float radius = breakable.getBreakRadius();
        float maxHardness = breakable.getMaxBreakableHardness();
        int maxBlocks = breakable.getMaxBreakableBlocks();
        float baseProb = breakable.getBaseBreakProbability();
        this.breakBlocks(level, pos, radius, maxHardness, maxBlocks, baseProb);
    }

    private void breakBlocks(class_1937 level, class_243 center, float radius, float maxHardness, int maxBlocks, float baseProb) {
        if (!level.field_9236 && radius > 0.0f && maxHardness > 0.0f && maxBlocks > 0 && baseProb > 0.0f) {
            class_2680 state;
            class_2338 centerPos = new class_2338((int)Math.floor(center.field_1352), (int)Math.floor(center.field_1351), (int)Math.floor(center.field_1350));
            List<class_2338> affectedBlocks = this.getBlocksInRadius(centerPos, radius);
            ArrayList<class_2338> blocksToBreak = new ArrayList<class_2338>();
            for (class_2338 pos : affectedBlocks) {
                float hardness;
                if (blocksToBreak.size() >= maxBlocks) break;
                state = level.method_8320(pos);
                if (state.method_26215() || state.method_26204() == class_2246.field_9987 || (hardness = state.method_26214((class_1922)level, pos)) < 0.0f || hardness > maxHardness) continue;
                double distance = Math.sqrt(pos.method_10262((class_2382)centerPos));
                float distanceFactor = 1.0f - (float)(distance / (double)radius);
                float breakProbability = baseProb * distanceFactor;
                if (!(this.random.nextFloat() <= breakProbability)) continue;
                blocksToBreak.add(pos);
            }
            for (class_2338 pos : blocksToBreak) {
                state = level.method_8320(pos);
                level.method_22352(pos, false);
            }
        }
    }

    private List<class_2338> getBlocksInRadius(class_2338 center, float radius) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        int intRadius = (int)Math.ceil(radius);
        for (int x = -intRadius; x <= intRadius; ++x) {
            for (int y = -intRadius; y <= intRadius; ++y) {
                for (int z = -intRadius; z <= intRadius; ++z) {
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (!(distance <= (double)radius)) continue;
                    blocks.add(center.method_10069(x, y, z));
                }
            }
        }
        return blocks;
    }
}

