/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public final class CreativeModeSettings {
    private static final Map<UUID, Settings> SETTINGS = new ConcurrentHashMap<UUID, Settings>();

    private CreativeModeSettings() {
    }

    private static Settings getSettings(UUID playerId) {
        return SETTINGS.computeIfAbsent(playerId, id -> new Settings());
    }

    public static Settings getSettings(class_1657 player) {
        return CreativeModeSettings.getSettings(player.method_5667());
    }

    public static void setSummonFriendly(class_1657 player, boolean friendly) {
        CreativeModeSettings.getSettings(player).setSummonFriendly(friendly);
    }

    public static void setControlAllUnits(class_1657 player, boolean allow) {
        CreativeModeSettings.getSettings(player).setControlAllUnits(allow);
    }

    public static boolean isSummonFriendly(class_1657 player) {
        if (!(player instanceof class_3222) || !player.method_7337()) {
            return false;
        }
        return CreativeModeSettings.getSettings(player).isSummonFriendly();
    }

    public static boolean canControlAllUnits(class_1657 player) {
        if (!(player instanceof class_3222) || !player.method_7337()) {
            return false;
        }
        return CreativeModeSettings.getSettings(player).isControlAllUnits();
    }

    public static void remove(class_1657 player) {
        SETTINGS.remove(player.method_5667());
    }

    public static void sendSummonFeedback(class_1657 player) {
        if (!(player instanceof class_3222) || !player.method_7337()) {
            return;
        }
        boolean friendly = CreativeModeSettings.isSummonFriendly(player);
        class_5250 alignment = class_2561.method_43471((String)(friendly ? "hud.hundred_years_war.creative_summon_relation.friendly" : "hud.hundred_years_war.creative_summon_relation.hostile")).method_27692(friendly ? class_124.field_1060 : class_124.field_1061);
        class_5250 message = class_2561.method_43469((String)"message.hundred_years_war.creative_summon_state", (Object[])new Object[]{alignment});
        player.method_7353((class_2561)message, true);
    }

    public static final class Settings {
        private boolean summonFriendly;
        private boolean controlAllUnits = true;

        public boolean isSummonFriendly() {
            return this.summonFriendly;
        }

        public void setSummonFriendly(boolean summonFriendly) {
            this.summonFriendly = summonFriendly;
        }

        public boolean isControlAllUnits() {
            return this.controlAllUnits;
        }

        public void setControlAllUnits(boolean controlAllUnits) {
            this.controlAllUnits = controlAllUnits;
        }
    }
}

