/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import ydmsama.hundred_years_war.main.config.ServerModConfig;

public class TreeFellingHandler {
    private static TreeFellingHandler instance;
    private final Random random = new Random();
    private static final int MAX_SEARCH_RADIUS = 20;
    private static final int[][] DIRECTIONS_26;

    private TreeFellingHandler() {
    }

    public static TreeFellingHandler getInstance() {
        if (instance == null) {
            instance = new TreeFellingHandler();
        }
        return instance;
    }

    public int fellTreesAroundSiegeEntity(class_1937 level, class_1297 siegeEntity) {
        if (level.field_9236) {
            return 0;
        }
        class_238 boundingBox = siegeEntity.method_5829();
        double entityWidth = Math.max(boundingBox.method_17939(), boundingBox.method_17941());
        double entityHeight = boundingBox.method_17940();
        double horizontalRadius = entityWidth / 2.0 + ServerModConfig.INSTANCE.siegeTreeFellingExtraRange;
        double verticalRadius = entityHeight + ServerModConfig.INSTANCE.siegeTreeFellingExtraRange;
        int fellCount = 0;
        HashSet<class_2338> processedPositions = new HashSet<class_2338>();
        int intHorizontalRadius = (int)Math.ceil(horizontalRadius);
        int intVerticalRadius = (int)Math.ceil(verticalRadius);
        class_243 center = siegeEntity.method_19538();
        class_2338 centerPos = new class_2338((int)center.field_1352, (int)center.field_1351, (int)center.field_1350);
        for (int x = -intHorizontalRadius; x <= intHorizontalRadius; ++x) {
            for (int y = -intVerticalRadius; y <= intVerticalRadius; ++y) {
                for (int z = -intHorizontalRadius; z <= intHorizontalRadius; ++z) {
                    TreeStructure tree;
                    class_2680 blockState;
                    class_2338 checkPos = centerPos.method_10069(x, y, z);
                    if (processedPositions.contains(checkPos)) continue;
                    double horizontalDistance = Math.sqrt(x * x + z * z);
                    double verticalDistance = Math.abs(y);
                    if (horizontalDistance > horizontalRadius || verticalDistance > verticalRadius || !this.isLogBlock(blockState = level.method_8320(checkPos)) && !this.isLeafBlock(blockState) || (tree = this.analyzeTree(level, checkPos, processedPositions)) == null || !this.isValidNaturalTree(tree)) continue;
                    this.fellTree(level, tree, center);
                    processedPositions.addAll(tree.getAllPositions());
                    ++fellCount;
                }
            }
        }
        return fellCount;
    }

    private TreeStructure analyzeTree(class_1937 level, class_2338 startPos, Set<class_2338> globalProcessed) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        HashSet<class_2338> logPositions = new HashSet<class_2338>();
        HashSet<class_2338> leafPositions = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.offer(startPos);
        visited.add(startPos);
        int minY = startPos.method_10264();
        int maxY = startPos.method_10264();
        while (!queue.isEmpty() && visited.size() < ServerModConfig.INSTANCE.maxTreeLogCount + 200) {
            class_2338 current = (class_2338)queue.poll();
            class_2680 currentState = level.method_8320(current);
            if (this.isLogBlock(currentState)) {
                logPositions.add(current);
                minY = Math.min(minY, current.method_10264());
                maxY = Math.max(maxY, current.method_10264());
                if (maxY - minY > ServerModConfig.INSTANCE.maxTreeHeight) {
                    return null;
                }
            } else if (this.isLeafBlock(currentState)) {
                leafPositions.add(current);
            }
            for (int[] dir : DIRECTIONS_26) {
                class_2680 neighborState;
                class_2338 neighborPos = current.method_10069(dir[0], dir[1], dir[2]);
                if (Math.abs(neighborPos.method_10263() - startPos.method_10263()) > 20 || Math.abs(neighborPos.method_10260() - startPos.method_10260()) > 20 || Math.abs(neighborPos.method_10264() - startPos.method_10264()) > ServerModConfig.INSTANCE.maxTreeHeight || visited.contains(neighborPos) || globalProcessed.contains(neighborPos) || !this.isLogBlock(neighborState = level.method_8320(neighborPos)) && !this.isLeafBlock(neighborState)) continue;
                visited.add(neighborPos);
                queue.offer(neighborPos);
            }
        }
        if (logPositions.size() >= ServerModConfig.INSTANCE.minTreeLogCount || logPositions.isEmpty() && !leafPositions.isEmpty()) {
            return new TreeStructure(logPositions, leafPositions, minY, maxY);
        }
        return null;
    }

    private boolean isValidNaturalTree(TreeStructure tree) {
        int logCount = tree.logPositions.size();
        int leafCount = tree.leafPositions.size();
        int height = tree.maxY - tree.minY + 1;
        if (logCount == 0 && leafCount > 0) {
            return true;
        }
        if (logCount > 0) {
            if (logCount < ServerModConfig.INSTANCE.minTreeLogCount || logCount > ServerModConfig.INSTANCE.maxTreeLogCount) {
                return false;
            }
            if (height < ServerModConfig.INSTANCE.minTreeHeight || height > ServerModConfig.INSTANCE.maxTreeHeight) {
                return false;
            }
            if ((double)leafCount < (double)logCount * 0.5) {
                return false;
            }
            return this.hasVerticalTrunk(tree);
        }
        return false;
    }

    private boolean hasVerticalTrunk(TreeStructure tree) {
        HashSet<class_2338> bottomLogs = new HashSet<class_2338>();
        for (class_2338 pos : tree.logPositions) {
            if (pos.method_10264() != tree.minY) continue;
            bottomLogs.add(pos);
        }
        for (class_2338 bottomLog : bottomLogs) {
            int consecutiveHeight = 1;
            class_2338 checkPos = bottomLog.method_10084();
            while (tree.logPositions.contains(checkPos) && consecutiveHeight < tree.getHeight()) {
                ++consecutiveHeight;
                checkPos = checkPos.method_10084();
            }
            if (consecutiveHeight < Math.min(1, tree.getHeight() / 2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void fellTree(class_1937 level, TreeStructure tree, class_243 siegePosition) {
        HashMap<String, List> verticalColumns = new HashMap<String, List>();
        for (class_2338 class_23382 : tree.leafPositions) {
            String string = class_23382.method_10263() + "," + class_23382.method_10260();
            verticalColumns.computeIfAbsent(string, k -> new ArrayList()).add(class_23382);
        }
        for (class_2338 class_23383 : tree.logPositions) {
            String string = class_23383.method_10263() + "," + class_23383.method_10260();
            verticalColumns.computeIfAbsent(string, k -> new ArrayList()).add(class_23383);
        }
        ArrayList<VerticalColumnDistance> columnsToDestroy = new ArrayList<VerticalColumnDistance>();
        for (Map.Entry entry : verticalColumns.entrySet()) {
            List columnBlocks = (List)entry.getValue();
            if (columnBlocks.isEmpty()) continue;
            class_2338 representative = (class_2338)columnBlocks.get(0);
            double horizontalDistance = Math.sqrt(Math.pow((double)representative.method_10263() - siegePosition.field_1352, 2.0) + Math.pow((double)representative.method_10260() - siegePosition.field_1350, 2.0));
            columnBlocks.sort(Comparator.comparingInt(class_2382::method_10264));
            columnsToDestroy.add(new VerticalColumnDistance(columnBlocks, horizontalDistance));
        }
        columnsToDestroy.sort(Comparator.comparingDouble(c -> c.horizontalDistance));
        int n = ServerModConfig.INSTANCE.maxSiegeTreeBlocksPerAction;
        boolean bl = false;
        block3: for (VerticalColumnDistance columnInfo : columnsToDestroy) {
            void var7_17;
            if (var7_17 >= n) break;
            for (class_2338 pos : columnInfo.columnBlocks) {
                if (var7_17 >= n) continue block3;
                class_2680 state = level.method_8320(pos);
                if (state.method_26215()) continue;
                if (this.random.nextFloat() < ServerModConfig.INSTANCE.siegeTreeParticleChance) {
                    level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                }
                level.method_8652(pos, class_2246.field_10124.method_9564(), 18);
                ++var7_17;
            }
        }
    }

    private boolean isLogBlock(class_2680 state) {
        return state.method_26164(class_3481.field_15475) || state.method_26164(class_3481.field_23210);
    }

    private boolean isLeafBlock(class_2680 state) {
        return state.method_26164(class_3481.field_15503);
    }

    static {
        DIRECTIONS_26 = new int[][]{{-1, 0, -1}, {-1, 0, 0}, {-1, 0, 1}, {0, 0, -1}, {0, 0, 1}, {1, 0, -1}, {1, 0, 0}, {1, 0, 1}, {-1, 1, -1}, {-1, 1, 0}, {-1, 1, 1}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {1, 1, -1}, {1, 1, 0}, {1, 1, 1}, {-1, -1, -1}, {-1, -1, 0}, {-1, -1, 1}, {0, -1, -1}, {0, -1, 0}, {0, -1, 1}, {1, -1, -1}, {1, -1, 0}, {1, -1, 1}};
    }

    private static class TreeStructure {
        final Set<class_2338> logPositions;
        final Set<class_2338> leafPositions;
        final int minY;
        final int maxY;

        TreeStructure(Set<class_2338> logPositions, Set<class_2338> leafPositions, int minY, int maxY) {
            this.logPositions = logPositions;
            this.leafPositions = leafPositions;
            this.minY = minY;
            this.maxY = maxY;
        }

        Set<class_2338> getAllPositions() {
            HashSet<class_2338> all = new HashSet<class_2338>(this.logPositions);
            all.addAll(this.leafPositions);
            return all;
        }

        int getHeight() {
            return this.maxY - this.minY + 1;
        }
    }

    private static class VerticalColumnDistance {
        final List<class_2338> columnBlocks;
        final double horizontalDistance;

        VerticalColumnDistance(List<class_2338> columnBlocks, double horizontalDistance) {
            this.columnBlocks = columnBlocks;
            this.horizontalDistance = horizontalDistance;
        }
    }
}

